/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PatchChangeBuilder {
    @NotNull
    private final StringBuilder myBuilder = new StringBuilder();
    @NotNull
    private final List<Hunk> myHunks = new ArrayList<Hunk>();
    @NotNull
    private final LineNumberConvertor.Builder myConvertor = new LineNumberConvertor.Builder();
    @NotNull
    private final TIntArrayList myChangedLines = new TIntArrayList();
    private int totalLines = 0;

    PatchChangeBuilder() {
    }

    public void exec(@NotNull List<AppliedTextPatch.AppliedSplitPatchHunk> splitHunks) {
        if (splitHunks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitHunks", "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder", "exec"));
        }
        int lastBeforeLine = -1;
        for (AppliedTextPatch.AppliedSplitPatchHunk hunk : splitHunks) {
            List<String> contextBefore = hunk.getContextBefore();
            List<String> contextAfter = hunk.getContextAfter();
            LineRange beforeRange = hunk.getLineRangeBefore();
            LineRange afterRange = hunk.getLineRangeAfter();
            int overlappedContext = 0;
            if (lastBeforeLine != -1) {
                if (lastBeforeLine >= beforeRange.start) {
                    overlappedContext = lastBeforeLine - beforeRange.start + 1;
                } else if (lastBeforeLine < beforeRange.start - 1) {
                    this.appendSeparator();
                }
            }
            List<String> trimContext = contextBefore.subList(overlappedContext, contextBefore.size());
            this.addContext(trimContext, beforeRange.start + overlappedContext, afterRange.start + overlappedContext);
            int deletion = this.totalLines;
            this.appendLines(hunk.getDeletedLines());
            int insertion = this.totalLines;
            this.appendLines(hunk.getInsertedLines());
            int hunkEnd = this.totalLines;
            this.myConvertor.put1(deletion, beforeRange.start + contextBefore.size(), insertion - deletion);
            this.myConvertor.put2(insertion, afterRange.start + contextBefore.size(), hunkEnd - insertion);
            this.addContext(contextAfter, beforeRange.end - contextAfter.size(), afterRange.end - contextAfter.size());
            lastBeforeLine = beforeRange.end - 1;
            LineRange deletionRange = new LineRange(deletion, insertion);
            LineRange insertionRange = new LineRange(insertion, hunkEnd);
            this.myHunks.add(new Hunk(hunk.getInsertedLines(), deletionRange, insertionRange, hunk.getAppliedTo(), hunk.getStatus()));
        }
    }

    private void addContext(@NotNull List<String> context, int beforeLineNumber, int afterLineNumber) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder", "addContext"));
        }
        this.myConvertor.put1(this.totalLines, beforeLineNumber, context.size());
        this.myConvertor.put2(this.totalLines, afterLineNumber, context.size());
        this.appendLines(context);
    }

    private void appendLines(@NotNull List<String> lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder", "appendLines"));
        }
        for (String line : lines) {
            this.myBuilder.append(line).append("\n");
        }
        this.totalLines += lines.size();
    }

    private void appendSeparator() {
        this.myChangedLines.add(this.totalLines);
        this.myBuilder.append("\n");
        ++this.totalLines;
    }

    @NotNull
    public CharSequence getPatchContent() {
        StringBuilder stringBuilder = this.myBuilder;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder", "getPatchContent"));
        }
        return stringBuilder;
    }

    @NotNull
    public List<Hunk> getHunks() {
        List<Hunk> list = this.myHunks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder", "getHunks"));
        }
        return list;
    }

    @NotNull
    public LineNumberConvertor getLineConvertor() {
        LineNumberConvertor lineNumberConvertor = this.myConvertor.build();
        if (lineNumberConvertor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder", "getLineConvertor"));
        }
        return lineNumberConvertor;
    }

    @NotNull
    public TIntArrayList getSeparatorLines() {
        TIntArrayList tIntArrayList = this.myChangedLines;
        if (tIntArrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder", "getSeparatorLines"));
        }
        return tIntArrayList;
    }

    static class Hunk {
        @NotNull
        private final List<String> myInsertedLines;
        @NotNull
        private final LineRange myPatchDeletionRange;
        @NotNull
        private final LineRange myPatchInsertionRange;
        @Nullable
        private final LineRange myAppliedToLines;
        @NotNull
        private final AppliedTextPatch.HunkStatus myStatus;

        public Hunk(@NotNull List<String> insertedLines, @NotNull LineRange patchDeletionRange, @NotNull LineRange patchInsertionRange, @Nullable LineRange appliedToLines, @NotNull AppliedTextPatch.HunkStatus status) {
            if (insertedLines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertedLines", "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk", "<init>"));
            }
            if (patchDeletionRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchDeletionRange", "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk", "<init>"));
            }
            if (patchInsertionRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchInsertionRange", "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk", "<init>"));
            }
            if (status == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk", "<init>"));
            }
            this.myInsertedLines = insertedLines;
            this.myPatchDeletionRange = patchDeletionRange;
            this.myPatchInsertionRange = patchInsertionRange;
            this.myAppliedToLines = appliedToLines;
            this.myStatus = status;
        }

        @NotNull
        public LineRange getPatchDeletionRange() {
            LineRange lineRange = this.myPatchDeletionRange;
            if (lineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk", "getPatchDeletionRange"));
            }
            return lineRange;
        }

        @NotNull
        public LineRange getPatchInsertionRange() {
            LineRange lineRange = this.myPatchInsertionRange;
            if (lineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk", "getPatchInsertionRange"));
            }
            return lineRange;
        }

        @NotNull
        public AppliedTextPatch.HunkStatus getStatus() {
            AppliedTextPatch.HunkStatus hunkStatus = this.myStatus;
            if (hunkStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk", "getStatus"));
            }
            return hunkStatus;
        }

        @Nullable
        public LineRange getAppliedToLines() {
            return this.myAppliedToLines;
        }

        @NotNull
        private List<String> getInsertedLines() {
            List<String> list = this.myInsertedLines;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk", "getInsertedLines"));
            }
            return list;
        }
    }
}

