/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchViewer;
import com.intellij.openapi.vcs.changes.patch.tool.PatchChangeBuilder;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ApplyPatchChange {
    @NotNull
    private final ApplyPatchViewer myViewer;
    private final int myIndex;
    @NotNull
    private final LineRange myPatchDeletionRange;
    @NotNull
    private final LineRange myPatchInsertionRange;
    @NotNull
    private final AppliedTextPatch.HunkStatus myStatus;
    @Nullable
    private final List<DiffFragment> myPatchInnerDifferences;
    @NotNull
    private final List<MyGutterOperation> myOperations;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;
    private boolean myResolved;

    public ApplyPatchChange(@NotNull PatchChangeBuilder.Hunk hunk, int index, @NotNull ApplyPatchViewer viewer) {
        if (hunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hunk", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "<init>"));
        }
        if (viewer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "<init>"));
        }
        this.myOperations = new ArrayList<MyGutterOperation>();
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myIndex = index;
        this.myViewer = viewer;
        this.myPatchDeletionRange = hunk.getPatchDeletionRange();
        this.myPatchInsertionRange = hunk.getPatchInsertionRange();
        this.myStatus = hunk.getStatus();
        this.myPatchInnerDifferences = ApplyPatchChange.calcPatchInnerDifferences(hunk, viewer);
    }

    @Nullable
    private static List<DiffFragment> calcPatchInnerDifferences(@NotNull PatchChangeBuilder.Hunk hunk, @NotNull ApplyPatchViewer viewer) {
        if (hunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hunk", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "calcPatchInnerDifferences"));
        }
        if (viewer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "calcPatchInnerDifferences"));
        }
        LineRange deletionRange = hunk.getPatchDeletionRange();
        LineRange insertionRange = hunk.getPatchInsertionRange();
        if (deletionRange.isEmpty() || insertionRange.isEmpty()) {
            return null;
        }
        try {
            DocumentEx patchDocument = viewer.getPatchEditor().getDocument();
            CharSequence deleted = DiffUtil.getLinesContent(patchDocument, deletionRange.start, deletionRange.end);
            CharSequence inserted = DiffUtil.getLinesContent(patchDocument, insertionRange.start, insertionRange.end);
            return ByWord.compare(deleted, inserted, ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        }
        catch (DiffTooBigException ignore) {
            return null;
        }
    }

    public void reinstallHighlighters() {
        this.destroyHighlighters();
        this.installHighlighters();
        this.myViewer.repaintDivider();
    }

    private void installHighlighters() {
        this.createResultHighlighters();
        this.createPatchHighlighters();
        this.createStatusHighlighter();
        this.createOperations();
    }

    private void createPatchHighlighters() {
        EditorEx patchEditor = this.myViewer.getPatchEditor();
        this.myHighlighters.addAll(DiffDrawUtil.createUnifiedChunkHighlighters(patchEditor, this.myPatchDeletionRange, this.myPatchInsertionRange, this.myPatchInnerDifferences));
    }

    private void createResultHighlighters() {
        LineRange resultRange = this.getResultRange();
        if (resultRange == null) {
            return;
        }
        EditorEx editor = this.myViewer.getResultEditor();
        int startLine = resultRange.start;
        int endLine = resultRange.end;
        TextDiffType type = this.getDiffType();
        boolean resolved = this.isRangeApplied();
        this.myHighlighters.addAll(DiffDrawUtil.createHighlighter(editor, startLine, endLine, type, false, resolved, false));
    }

    private void createStatusHighlighter() {
        int line1 = this.myPatchDeletionRange.start;
        int line2 = this.myPatchInsertionRange.end;
        Color color = this.getStatusColor();
        if (this.isResolved()) {
            color = ColorUtil.mix((Color)color, (Color)this.myViewer.getPatchEditor().getGutterComponentEx().getBackground(), (double)0.6f);
        }
        String tooltip = this.getStatusText();
        EditorEx patchEditor = this.myViewer.getPatchEditor();
        DocumentEx document = patchEditor.getDocument();
        MarkupModelEx markupModel = patchEditor.getMarkupModel();
        TextRange textRange = DiffUtil.getLinesRange(document, line1, line2);
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 6000, null, HighlighterTargetArea.LINES_IN_RANGE);
        PairConsumer clickHandler = this.getResultRange() != null ? (e, event) -> this.myViewer.scrollToChange(this, Side.RIGHT, false) : null;
        highlighter.setLineMarkerRenderer(LineStatusMarkerRenderer.createRenderer(line1, line2, color, tooltip, (PairConsumer<Editor, MouseEvent>)clickHandler));
        this.myHighlighters.add(highlighter);
    }

    private void destroyHighlighters() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (MyGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    public int getIndex() {
        return this.myIndex;
    }

    @NotNull
    public AppliedTextPatch.HunkStatus getStatus() {
        AppliedTextPatch.HunkStatus hunkStatus = this.myStatus;
        if (hunkStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "getStatus"));
        }
        return hunkStatus;
    }

    @NotNull
    public LineRange getPatchRange() {
        LineRange lineRange = new LineRange(this.myPatchDeletionRange.start, this.myPatchInsertionRange.end);
        if (lineRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "getPatchRange"));
        }
        return lineRange;
    }

    @NotNull
    public LineRange getPatchAffectedRange() {
        LineRange lineRange = this.isRangeApplied() ? this.myPatchInsertionRange : this.myPatchDeletionRange;
        if (lineRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "getPatchAffectedRange"));
        }
        return lineRange;
    }

    @NotNull
    public LineRange getPatchDeletionRange() {
        LineRange lineRange = this.myPatchDeletionRange;
        if (lineRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "getPatchDeletionRange"));
        }
        return lineRange;
    }

    @NotNull
    public LineRange getPatchInsertionRange() {
        LineRange lineRange = this.myPatchInsertionRange;
        if (lineRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "getPatchInsertionRange"));
        }
        return lineRange;
    }

    @Nullable
    public LineRange getResultRange() {
        ApplyPatchViewer.MyModel model = this.myViewer.getModel();
        int lineStart = model.getLineStart(this.myIndex);
        int lineEnd = model.getLineEnd(this.myIndex);
        if (lineStart != -1 || lineEnd != -1) {
            return new LineRange(lineStart, lineEnd);
        }
        return null;
    }

    public boolean isResolved() {
        return this.myResolved;
    }

    public void setResolved(boolean resolved) {
        this.myResolved = resolved;
    }

    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType textDiffType = DiffUtil.getDiffType(!this.myPatchDeletionRange.isEmpty(), !this.myPatchInsertionRange.isEmpty());
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "getDiffType"));
        }
        return textDiffType;
    }

    public boolean isRangeApplied() {
        return this.myResolved || this.getStatus() == AppliedTextPatch.HunkStatus.ALREADY_APPLIED;
    }

    @NotNull
    private String getStatusText() {
        switch (this.myStatus) {
            case ALREADY_APPLIED: {
                if ("Already applied" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "getStatusText"));
                }
                return "Already applied";
            }
            case EXACTLY_APPLIED: {
                if ("Automatically applied" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "getStatusText"));
                }
                return "Automatically applied";
            }
            case NOT_APPLIED: {
                if ("Not applied" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "getStatusText"));
                }
                return "Not applied";
            }
        }
        throw new IllegalStateException();
    }

    @NotNull
    private Color getStatusColor() {
        switch (this.myStatus) {
            case ALREADY_APPLIED: {
                Color color = JBColor.YELLOW.darker();
                if (color == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "getStatusColor"));
                }
                return color;
            }
            case EXACTLY_APPLIED: {
                JBColor jBColor = new JBColor(new Color(0, 180, 5), new Color(0, 147, 5));
                if (jBColor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "getStatusColor"));
                }
                return jBColor;
            }
            case NOT_APPLIED: {
                Color color = JBColor.RED.darker();
                if (color == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "getStatusColor"));
                }
                return color;
            }
        }
        throw new IllegalStateException();
    }

    private void createOperations() {
        if (this.myViewer.isReadOnly()) {
            return;
        }
        if (this.isResolved()) {
            return;
        }
        if (this.myStatus == AppliedTextPatch.HunkStatus.EXACTLY_APPLIED) {
            ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(OperationType.APPLY));
        }
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(OperationType.IGNORE));
    }

    @Nullable
    private MyGutterOperation createOperation(@NotNull OperationType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "createOperation"));
        }
        if (this.isResolved()) {
            return null;
        }
        int line = this.getPatchRange().start;
        EditorEx editor = this.myViewer.getPatchEditor();
        DocumentEx document = editor.getDocument();
        int offset = line == DiffUtil.getLineCount(document) ? document.getTextLength() : document.getLineStartOffset(line);
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(offset, offset, 3000, null, HighlighterTargetArea.LINES_IN_RANGE);
        return new MyGutterOperation(highlighter, type);
    }

    @Nullable
    private GutterIconRenderer createApplyRenderer() {
        return ApplyPatchChange.createIconRenderer(DiffBundle.message((String)"merge.dialog.apply.change.action.name", (Object[])new Object[0]), DiffUtil.getArrowIcon(Side.RIGHT), () -> this.myViewer.executeCommand("Accept change", () -> this.myViewer.replaceChange(this)));
    }

    @Nullable
    private GutterIconRenderer createIgnoreRenderer() {
        return ApplyPatchChange.createIconRenderer(DiffBundle.message((String)"merge.dialog.ignore.change.action.name", (Object[])new Object[0]), AllIcons.Diff.Remove, () -> this.myViewer.executeCommand("Ignore change", () -> this.myViewer.markChangeResolved(this)));
    }

    @Nullable
    private static GutterIconRenderer createIconRenderer(@NotNull String text, @NotNull Icon icon, final @NotNull Runnable perform) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "createIconRenderer"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "createIconRenderer"));
        }
        if (perform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "perform", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "createIconRenderer"));
        }
        String tooltipText = DiffUtil.createTooltipText(text, null);
        return new DiffGutterRenderer(icon, tooltipText){

            @Override
            protected void performAction(AnActionEvent e) {
                perform.run();
            }
        };
    }

    @NotNull
    public State storeState() {
        LineRange resultRange = this.getResultRange();
        State state = new State(this.myIndex, resultRange != null ? resultRange.start : -1, resultRange != null ? resultRange.end : -1, this.myResolved);
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "storeState"));
        }
        return state;
    }

    public void restoreState(@NotNull State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange", "restoreState"));
        }
        this.myResolved = state.myResolved;
    }

    public static class State
    extends MergeModelBase.State {
        private final boolean myResolved;

        public State(int index, int startLine, int endLine, boolean resolved) {
            super(index, startLine, endLine);
            this.myResolved = resolved;
        }
    }

    private static enum OperationType {
        APPLY,
        IGNORE;

    }

    private class MyGutterOperation {
        @NotNull
        private final RangeHighlighter myHighlighter;
        @NotNull
        private final OperationType myType;

        private MyGutterOperation(@NotNull RangeHighlighter highlighter, OperationType type) {
            if (highlighter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange$MyGutterOperation", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange$MyGutterOperation", "<init>"));
            }
            this.myHighlighter = highlighter;
            this.myType = type;
            this.myHighlighter.setGutterIconRenderer(this.createRenderer());
        }

        public void dispose() {
            this.myHighlighter.dispose();
        }

        @Nullable
        public GutterIconRenderer createRenderer() {
            switch (this.myType) {
                case APPLY: {
                    return ApplyPatchChange.this.createApplyRenderer();
                }
                case IGNORE: {
                    return ApplyPatchChange.this.createIgnoreRenderer();
                }
            }
            throw new IllegalArgumentException(this.myType.name());
        }
    }
}

