/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeGoToChangePopupAction;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeDiffRequestChain
extends UserDataHolderBase
implements DiffRequestChain,
GoToChangePopupBuilder.Chain {
    @NotNull
    private final List<ChangeDiffRequestProducer> myRequests;
    private int myIndex;

    public ChangeDiffRequestChain(@NotNull List<ChangeDiffRequestProducer> requests) {
        if (requests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestChain", "<init>"));
        }
        this.myRequests = requests;
    }

    @NotNull
    public List<? extends ChangeDiffRequestProducer> getRequests() {
        List<ChangeDiffRequestProducer> list = this.myRequests;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestChain", "getRequests"));
        }
        return list;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public void setIndex(int index) {
        assert (index >= 0 && index < this.myRequests.size());
        this.myIndex = index;
    }

    @Override
    @NotNull
    public AnAction createGoToChangeAction(@NotNull Consumer<Integer> onSelected) {
        if (onSelected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSelected", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestChain", "createGoToChangeAction"));
        }
        ChangeGoToChangePopupAction<ChangeDiffRequestChain> changeGoToChangePopupAction = new ChangeGoToChangePopupAction<ChangeDiffRequestChain>(this, onSelected){

            @Override
            protected int findSelectedStep(@Nullable Change change) {
                if (change == null) {
                    return -1;
                }
                for (int i2 = 0; i2 < ChangeDiffRequestChain.this.myRequests.size(); ++i2) {
                    Change c = ((ChangeDiffRequestProducer)ChangeDiffRequestChain.this.myRequests.get(i2)).getChange();
                    if (!c.equals((Object)change)) continue;
                    return i2;
                }
                return -1;
            }

            @Override
            @NotNull
            protected List<Change> getChanges() {
                List list = ContainerUtil.mapNotNull(((ChangeDiffRequestChain)this.myChain).getRequests(), (Function)new Function<ChangeDiffRequestProducer, Change>(){

                    public Change fun(ChangeDiffRequestProducer presentable) {
                        return presentable.getChange();
                    }
                });
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestChain$1", "getChanges"));
                }
                return list;
            }

            @Override
            @Nullable
            protected Change getCurrentSelection() {
                return ((ChangeDiffRequestChain)this.myChain).getRequests().get(((ChangeDiffRequestChain)this.myChain).getIndex()).getChange();
            }
        };
        if (changeGoToChangePopupAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeDiffRequestChain", "createGoToChangeAction"));
        }
        return changeGoToChangePopupAction;
    }
}

