/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.Details;
import com.intellij.openapi.vcs.GenericDetailsLoader;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.DetailsPanel;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.Consumer;
import com.intellij.util.continuation.ModalityIgnorantBackgroundableTask;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRefreshablePanel<T>
implements RefreshablePanel<Change> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.AbstractRefreshablePanel");
    private final Ticket myTicket;
    private final DetailsPanel myDetailsPanel;
    private final GenericDetailsLoader<Ticket, T> myDetailsLoader;
    private final BackgroundTaskQueue myQueue;
    private volatile boolean myDisposed;

    protected AbstractRefreshablePanel(Project project2, String loadingTitle, BackgroundTaskQueue queue) {
        this.myQueue = queue;
        this.myTicket = new Ticket();
        this.myDetailsPanel = new DetailsPanel();
        this.myDetailsPanel.loading();
        this.myDetailsPanel.layout();
        this.myDetailsLoader = new GenericDetailsLoader(ticket -> {
            Loader loader = new Loader(project2, loadingTitle, this.myTicket.copy());
            loader.runSteadily((Consumer<Task.Backgroundable>)((Consumer)backgroundable -> this.myQueue.run((Task.Backgroundable)backgroundable)));
        }, (ticket, t) -> this.acceptData(t));
    }

    @Override
    public boolean refreshDataSynch() {
        return false;
    }

    @Override
    public void dataChanged() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myTicket.increment();
    }

    @Override
    public void refresh() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!Comparing.equal((Object)this.myDetailsLoader.getCurrentlySelected(), (Object)this.myTicket)) {
            Ticket copy = this.myTicket.copy();
            this.myDetailsLoader.updateSelection((Object)copy, false);
            this.myDetailsPanel.loading();
            this.myDetailsPanel.layout();
        } else {
            this.refreshPresentation();
        }
    }

    protected abstract void refreshPresentation();

    protected abstract T loadImpl() throws VcsException;

    protected abstract JPanel dataToPresentation(T var1);

    protected abstract void disposeImpl();

    private void acceptData(T t) {
        JPanel panel2 = this.dataToPresentation(t);
        this.myDetailsPanel.data(panel2);
        this.myDetailsPanel.layout();
    }

    @Override
    public JPanel getPanel() {
        return this.myDetailsPanel.getPanel();
    }

    @Override
    public boolean isStillValid(Change data) {
        return true;
    }

    public void dispose() {
        this.myDisposed = true;
        this.disposeImpl();
    }

    private static class Ticket {
        private int myId;

        public Ticket() {
            this.myId = 0;
        }

        public Ticket(int id) {
            this.myId = id;
        }

        public Ticket copy() {
            return new Ticket(this.myId);
        }

        public void increment() {
            ++this.myId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Ticket ticket = (Ticket)o;
            return this.myId == ticket.myId;
        }

        public int hashCode() {
            return this.myId;
        }
    }

    private class Loader
    extends ModalityIgnorantBackgroundableTask {
        private final Ticket myTicketCopy;
        private T myT;

        private Loader(@NotNull Project project2, String title, Ticket ticketCopy) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/changes/AbstractRefreshablePanel$Loader", "<init>"));
            }
            super(project2, title, false);
            this.myTicketCopy = ticketCopy;
        }

        @Override
        protected void doInAwtIfFail(Exception e) {
            Exception cause = e instanceof RuntimeException && e.getCause() != null ? (Exception)e.getCause() : e;
            LOG.info((Throwable)e);
            String message = cause.getMessage() == null ? e.getMessage() : cause.getMessage();
            message = message == null ? "Unknown error" : message;
            VcsBalloonProblemNotifier.showOverChangesView(this.myProject, message, MessageType.ERROR, new NamedRunnable[0]);
        }

        @Override
        protected void doInAwtIfCancel() {
        }

        @Override
        protected void doInAwtIfSuccess() {
            if (AbstractRefreshablePanel.this.myDisposed) {
                return;
            }
            try {
                AbstractRefreshablePanel.this.myDetailsLoader.take((Object)this.myTicketCopy, this.myT);
            }
            catch (Details.AlreadyDisposedException alreadyDisposedException) {
                // empty catch block
            }
        }

        @Override
        protected void runImpl(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/AbstractRefreshablePanel$Loader", "runImpl"));
            }
            if (AbstractRefreshablePanel.this.myDisposed) {
                return;
            }
            try {
                this.myT = AbstractRefreshablePanel.this.loadImpl();
            }
            catch (VcsException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

