/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelImpl;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableItem;
import com.intellij.openapi.roots.ui.configuration.classpath.InvalidJdkItem;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.ListTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import org.jetbrains.annotations.Nullable;

class ClasspathTableModel
extends ListTableModel<ClasspathTableItem<?>>
implements ItemRemovable {
    static final String EXPORT_COLUMN_NAME = ProjectBundle.message((String)"modules.order.export.export.column", (Object[])new Object[0]);
    private static final ColumnInfo<ClasspathTableItem<?>, Boolean> EXPORT_COLUMN_INFO = new ColumnInfo<ClasspathTableItem<?>, Boolean>(EXPORT_COLUMN_NAME){

        @Nullable
        public Boolean valueOf(ClasspathTableItem<?> item) {
            return item.isExported();
        }

        public void setValue(ClasspathTableItem<?> item, Boolean value) {
            item.setExported(value);
        }

        public boolean isCellEditable(ClasspathTableItem<?> item) {
            return item.isExportable();
        }

        public Class getColumnClass() {
            return Boolean.class;
        }
    };
    private static final String SCOPE_COLUMN_NAME = ProjectBundle.message((String)"modules.order.export.scope.column", (Object[])new Object[0]);
    private static final Comparator<DependencyScope> DEPENDENCY_SCOPE_COMPARATOR = (o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
    private static final Comparator<ClasspathTableItem<?>> CLASSPATH_ITEM_SCOPE_COMPARATOR = (o1, o2) -> Comparing.compare((Object)o1.getScope(), (Object)o2.getScope(), DEPENDENCY_SCOPE_COMPARATOR);
    private static final ColumnInfo<ClasspathTableItem<?>, DependencyScope> SCOPE_COLUMN_INFO = new ColumnInfo<ClasspathTableItem<?>, DependencyScope>(SCOPE_COLUMN_NAME){

        @Nullable
        public DependencyScope valueOf(ClasspathTableItem<?> item) {
            return item.getScope();
        }

        public void setValue(ClasspathTableItem<?> item, DependencyScope value) {
            item.setScope(value);
        }

        public boolean isCellEditable(ClasspathTableItem<?> item) {
            return item.isExportable();
        }

        public Class getColumnClass() {
            return DependencyScope.class;
        }

        @Nullable
        public Comparator<ClasspathTableItem<?>> getComparator() {
            return CLASSPATH_ITEM_SCOPE_COMPARATOR;
        }
    };
    public static final int EXPORT_COLUMN = 0;
    public static final int ITEM_COLUMN = 1;
    public static final int SCOPE_COLUMN = 2;
    private final ModuleConfigurationState myState;
    private StructureConfigurableContext myContext;

    public ClasspathTableModel(ModuleConfigurationState state, StructureConfigurableContext context) {
        super(new ColumnInfo[]{EXPORT_COLUMN_INFO, new ClasspathTableItemClasspathColumnInfo(context), SCOPE_COLUMN_INFO});
        this.myState = state;
        this.myContext = context;
        this.init();
    }

    public RowSorter.SortKey getDefaultSortKey() {
        return new RowSorter.SortKey(1, SortOrder.UNSORTED);
    }

    private ModifiableRootModel getModel() {
        return this.myState.getRootModel();
    }

    public void init() {
        OrderEntry[] orderEntries = this.getModel().getOrderEntries();
        boolean hasJdkOrderEntry = false;
        ArrayList items = new ArrayList();
        for (OrderEntry orderEntry : orderEntries) {
            if (orderEntry instanceof JdkOrderEntry) {
                hasJdkOrderEntry = true;
            }
            items.add(ClasspathTableItem.createItem(orderEntry, this.myContext));
        }
        if (!hasJdkOrderEntry) {
            items.add(0, new InvalidJdkItem());
        }
        this.setItems(items);
    }

    public void exchangeRows(int idx1, int idx2) {
        super.exchangeRows(idx1, idx2);
        List<OrderEntry> entries = this.getEntries();
        this.myState.getRootModel().rearrangeOrderEntries(entries.toArray(new OrderEntry[entries.size()]));
    }

    public void clear() {
        this.setItems(Collections.emptyList());
    }

    private List<OrderEntry> getEntries() {
        int count = this.getRowCount();
        ArrayList<OrderEntry> entries = new ArrayList<OrderEntry>(count);
        for (int row = 0; row < count; ++row) {
            Object entry = ((ClasspathTableItem)this.getItem(row)).getEntry();
            if (entry == null) continue;
            entries.add((OrderEntry)entry);
        }
        return entries;
    }

    private static class ClasspathTableItemClasspathColumnInfo
    extends ColumnInfo<ClasspathTableItem<?>, ClasspathTableItem<?>> {
        private final Comparator<ClasspathTableItem<?>> myItemComparator = (o1, o2) -> {
            String text1 = ClasspathPanelImpl.getCellAppearance(o1, context, false).getText();
            String text2 = ClasspathPanelImpl.getCellAppearance(o2, context, false).getText();
            return text1.compareToIgnoreCase(text2);
        };

        public ClasspathTableItemClasspathColumnInfo(StructureConfigurableContext context) {
            super("");
        }

        @Nullable
        public Comparator<ClasspathTableItem<?>> getComparator() {
            return this.myItemComparator;
        }

        @Nullable
        public ClasspathTableItem<?> valueOf(ClasspathTableItem<?> item) {
            return item;
        }

        public boolean isCellEditable(ClasspathTableItem<?> item) {
            return false;
        }

        public Class getColumnClass() {
            return ClasspathTableItem.class;
        }
    }
}

