/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceInArtifact
extends PlaceInProjectStructure {
    private final Artifact myArtifact;
    private final ArtifactsStructureConfigurableContext myContext;
    private final String myParentPath;
    private final PackagingElement<?> myPackagingElement;

    public PlaceInArtifact(Artifact artifact, ArtifactsStructureConfigurableContext context, @Nullable String parentPath, @Nullable PackagingElement<?> packagingElement) {
        this.myArtifact = artifact;
        this.myContext = context;
        this.myParentPath = parentPath;
        this.myPackagingElement = packagingElement;
    }

    @Override
    @NotNull
    public ProjectStructureElement getContainingElement() {
        ArtifactProjectStructureElement artifactProjectStructureElement = this.myContext.getOrCreateArtifactElement(this.myArtifact);
        if (artifactProjectStructureElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/PlaceInArtifact", "getContainingElement"));
        }
        return artifactProjectStructureElement;
    }

    @Override
    public String getPlacePath() {
        if (this.myParentPath != null && this.myPackagingElement != null) {
            return this.myParentPath + "/" + this.myPackagingElement.getType().getId();
        }
        return null;
    }

    @Override
    @NotNull
    public ActionCallback navigate() {
        Artifact artifact = this.myContext.getArtifactModel().getArtifactByOriginal(this.myArtifact);
        ActionCallback actionCallback = ProjectStructureConfigurable.getInstance(this.myContext.getProject()).select(this.myArtifact, true).doWhenDone(() -> {
            ArtifactEditorEx artifactEditor = (ArtifactEditorEx)this.myContext.getOrCreateEditor(artifact);
            if (this.myParentPath != null && this.myPackagingElement != null) {
                artifactEditor.getLayoutTreeComponent().selectNode(this.myParentPath, this.myPackagingElement);
            }
        });
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/PlaceInArtifact", "navigate"));
        }
        return actionCallback;
    }
}

