/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.util.Producer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextEditorState
implements FileEditorState {
    public CaretState[] CARETS;
    public int RELATIVE_CARET_POSITION;
    private CodeFoldingState myFoldingState;
    @Nullable
    private Producer<CodeFoldingState> myDelayedFoldInfoProducer;
    private static final int MIN_CHANGE_DISTANCE = 4;

    public void setDelayedFoldState(@NotNull Producer<CodeFoldingState> producer) {
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/openapi/fileEditor/impl/text/TextEditorState", "setDelayedFoldState"));
        }
        this.myDelayedFoldInfoProducer = producer;
    }

    @Nullable
    public CodeFoldingState getFoldingState() {
        if (this.myFoldingState == null && this.myDelayedFoldInfoProducer != null) {
            this.myFoldingState = (CodeFoldingState)this.myDelayedFoldInfoProducer.produce();
            if (this.myFoldingState != null) {
                this.myDelayedFoldInfoProducer = null;
            }
        }
        return this.myFoldingState;
    }

    public void setFoldingState(@Nullable CodeFoldingState foldingState) {
        this.myFoldingState = foldingState;
        this.myDelayedFoldInfoProducer = null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TextEditorState)) {
            return false;
        }
        TextEditorState textEditorState = (TextEditorState)o;
        if (!Arrays.equals(this.CARETS, textEditorState.CARETS)) {
            return false;
        }
        if (this.RELATIVE_CARET_POSITION != textEditorState.RELATIVE_CARET_POSITION) {
            return false;
        }
        CodeFoldingState localFoldingState = this.getFoldingState();
        CodeFoldingState theirFoldingState = textEditorState.getFoldingState();
        return !(localFoldingState == null ? theirFoldingState != null : !localFoldingState.equals(theirFoldingState));
    }

    public int hashCode() {
        int result2 = 0;
        if (this.CARETS != null) {
            for (CaretState caretState : this.CARETS) {
                if (caretState == null) continue;
                result2 += caretState.hashCode();
            }
        }
        return result2;
    }

    public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
        if (!(otherState instanceof TextEditorState)) {
            return false;
        }
        TextEditorState other = (TextEditorState)otherState;
        return level == FileEditorStateLevel.NAVIGATION && this.CARETS != null && this.CARETS.length == 1 && other.CARETS != null && other.CARETS.length == 1 && Math.abs(this.CARETS[0].LINE - other.CARETS[0].LINE) < 4;
    }

    public String toString() {
        return Arrays.toString(this.CARETS);
    }

    public static class CaretState {
        public int LINE;
        public int COLUMN;
        public boolean LEAN_FORWARD;
        public int SELECTION_START_LINE;
        public int SELECTION_START_COLUMN;
        public int SELECTION_END_LINE;
        public int SELECTION_END_COLUMN;

        public boolean equals(Object o) {
            if (!(o instanceof CaretState)) {
                return false;
            }
            CaretState caretState = (CaretState)o;
            if (this.COLUMN != caretState.COLUMN) {
                return false;
            }
            if (this.LINE != caretState.LINE) {
                return false;
            }
            if (this.LEAN_FORWARD != caretState.LEAN_FORWARD) {
                return false;
            }
            if (this.SELECTION_START_LINE != caretState.SELECTION_START_LINE) {
                return false;
            }
            if (this.SELECTION_START_COLUMN != caretState.SELECTION_START_COLUMN) {
                return false;
            }
            if (this.SELECTION_END_LINE != caretState.SELECTION_END_LINE) {
                return false;
            }
            return this.SELECTION_END_COLUMN == caretState.SELECTION_END_COLUMN;
        }

        public int hashCode() {
            return this.LINE + this.COLUMN;
        }

        public String toString() {
            return "[" + this.LINE + "," + this.COLUMN + "]";
        }
    }
}

