/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;

public abstract class ExternalSystemToggleAction
extends ToggleAction
implements DumbAware {
    public void update(AnActionEvent e) {
        super.update(e);
        Presentation p = e.getPresentation();
        boolean visible = this.isVisible(e);
        p.setVisible(visible);
        p.setEnabled(visible && this.isEnabled(e));
    }

    protected boolean isEnabled(AnActionEvent e) {
        return this.hasProject(e);
    }

    protected boolean isVisible(AnActionEvent e) {
        return true;
    }

    public boolean isSelected(AnActionEvent e) {
        if (!this.isEnabled(e)) {
            return false;
        }
        return this.doIsSelected(e);
    }

    protected abstract boolean doIsSelected(AnActionEvent var1);

    protected Project getProject(AnActionEvent e) {
        return e.getProject();
    }

    protected boolean hasProject(AnActionEvent e) {
        return this.getProject(e) != null;
    }

    protected ProjectSystemId getSystemId(AnActionEvent e) {
        return (ProjectSystemId)ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.getData(e.getDataContext());
    }

    protected void setText(String message) {
        this.getTemplatePresentation().setText(message);
    }

    protected void setDescription(String message) {
        this.getTemplatePresentation().setDescription(message);
    }

    protected void setText(AnActionEvent e, String message) {
        e.getPresentation().setText(message);
    }

    protected void setDescription(AnActionEvent e, String message) {
        e.getPresentation().setDescription(message);
    }
}

