/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VisualLinesIterator {
    private final EditorImpl myEditor;
    private final Document myDocument;
    private final FoldRegion[] myFoldRegions;
    private final List<? extends SoftWrap> mySoftWraps;
    @NotNull
    private Location myLocation;
    private Location myNextLocation;

    public VisualLinesIterator(@NotNull EditorImpl editor, int startVisualLine) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/view/VisualLinesIterator", "<init>"));
        }
        this.myEditor = editor;
        SoftWrapModelImpl softWrapModel = this.myEditor.getSoftWrapModel();
        this.myDocument = this.myEditor.getDocument();
        FoldRegion[] regions = this.myEditor.getFoldingModel().fetchTopLevel();
        this.myFoldRegions = regions == null ? FoldRegion.EMPTY_ARRAY : regions;
        this.mySoftWraps = softWrapModel.getRegisteredSoftWraps();
        this.myLocation = new Location(startVisualLine);
    }

    public boolean atEnd() {
        return this.myLocation.atEnd();
    }

    public void advance() {
        this.checkEnd();
        if (this.myNextLocation == null) {
            this.myLocation.advance();
        } else {
            this.myLocation = this.myNextLocation;
            this.myNextLocation = null;
        }
    }

    public int getVisualLine() {
        this.checkEnd();
        return this.myLocation.visualLine;
    }

    public int getVisualLineStartOffset() {
        this.checkEnd();
        return this.myLocation.offset;
    }

    public int getVisualLineEndOffset() {
        this.checkEnd();
        if (this.myNextLocation == null) {
            this.myNextLocation = this.myLocation.clone();
            this.myNextLocation.advance();
        }
        return this.myNextLocation.atEnd() ? this.myDocument.getTextLength() : (this.myNextLocation.softWrap == this.myLocation.softWrap ? this.myDocument.getLineEndOffset(this.myNextLocation.logicalLine - 2) : this.myNextLocation.offset);
    }

    public int getStartLogicalLine() {
        this.checkEnd();
        return this.myLocation.logicalLine - 1;
    }

    public int getStartOrPrevWrapIndex() {
        this.checkEnd();
        return this.myLocation.softWrap - 1;
    }

    public int getStartFoldingIndex() {
        this.checkEnd();
        return this.myLocation.foldRegion;
    }

    public int getY() {
        this.checkEnd();
        return this.myLocation.y;
    }

    private void checkEnd() {
        if (this.atEnd()) {
            throw new IllegalStateException("Iteration finished");
        }
    }

    private final class Location
    implements Cloneable {
        private final int lineHeight;
        private int visualLine;
        private int offset;
        private int logicalLine = 1;
        private int foldRegion;
        private int softWrap;
        private int y;

        private Location(int startVisualLine) {
            this.lineHeight = VisualLinesIterator.this.myEditor.getLineHeight();
            if (startVisualLine < 0 || startVisualLine >= VisualLinesIterator.this.myEditor.getVisibleLineCount()) {
                this.offset = -1;
            } else if (startVisualLine > 0) {
                this.visualLine = startVisualLine;
                this.offset = VisualLinesIterator.this.myEditor.visualLineStartOffset(startVisualLine);
                this.logicalLine = VisualLinesIterator.this.myDocument.getLineNumber(this.offset) + 1;
                this.softWrap = VisualLinesIterator.this.myEditor.getSoftWrapModel().getSoftWrapIndex(this.offset) + 1;
                if (this.softWrap <= 0) {
                    this.softWrap = -this.softWrap;
                }
                this.foldRegion = VisualLinesIterator.this.myEditor.getFoldingModel().getLastCollapsedRegionBefore(this.offset) + 1;
                this.y = VisualLinesIterator.this.myEditor.visibleLineToY(startVisualLine);
            }
        }

        private void advance() {
            int nextWrapOffset = this.getNextSoftWrapOffset();
            this.offset = this.getNextVisualLineStartOffset(nextWrapOffset);
            if (this.offset == Integer.MAX_VALUE) {
                this.offset = -1;
            } else if (this.offset == nextWrapOffset) {
                ++this.softWrap;
            }
            ++this.visualLine;
            while (this.foldRegion < VisualLinesIterator.this.myFoldRegions.length && VisualLinesIterator.this.myFoldRegions[this.foldRegion].getStartOffset() < this.offset) {
                ++this.foldRegion;
            }
            this.y += this.lineHeight;
        }

        private int getNextSoftWrapOffset() {
            return this.softWrap < VisualLinesIterator.this.mySoftWraps.size() ? ((SoftWrap)VisualLinesIterator.this.mySoftWraps.get(this.softWrap)).getStart() : Integer.MAX_VALUE;
        }

        private int getNextVisualLineStartOffset(int nextWrapOffset) {
            while (this.logicalLine < VisualLinesIterator.this.myDocument.getLineCount()) {
                int lineStartOffset = VisualLinesIterator.this.myDocument.getLineStartOffset(this.logicalLine);
                if (lineStartOffset > nextWrapOffset) {
                    return nextWrapOffset;
                }
                ++this.logicalLine;
                if (this.isCollapsed(lineStartOffset)) continue;
                return lineStartOffset;
            }
            return nextWrapOffset;
        }

        private boolean isCollapsed(int offset) {
            while (this.foldRegion < VisualLinesIterator.this.myFoldRegions.length) {
                FoldRegion region = VisualLinesIterator.this.myFoldRegions[this.foldRegion];
                if (offset <= region.getStartOffset()) {
                    return false;
                }
                if (offset <= region.getEndOffset()) {
                    return true;
                }
                ++this.foldRegion;
            }
            return false;
        }

        private boolean atEnd() {
            return this.offset == -1;
        }

        protected Location clone() {
            try {
                return (Location)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

