/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.editor.impl.view.TextFragment;
import com.intellij.util.BitUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

class ComplexTextFragment
extends TextFragment {
    private static final Logger LOG = Logger.getInstance(ComplexTextFragment.class);
    private static final double CLIP_MARGIN = 10000.0;
    @NotNull
    private final GlyphVector myGlyphVector;
    private static ComplexTextFragment lastFragment;
    private static int lastStartColumn;
    private static int lastEndColumn;
    private static Color lastColor;
    private static float lastStartX;
    private static float lastEndX;
    private static float lastY;
    private static long ourDrawingCount;
    private static long ourCharsProcessed;
    private static long ourGlyphsProcessed;

    ComplexTextFragment(@NotNull char[] lineChars, int start, int end, boolean isRtl, @NotNull Font font, @NotNull FontRenderContext fontRenderContext) {
        float lastX;
        float totalWidth;
        if (lineChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineChars", "com/intellij/openapi/editor/impl/view/ComplexTextFragment", "<init>"));
        }
        if (font == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/intellij/openapi/editor/impl/view/ComplexTextFragment", "<init>"));
        }
        if (fontRenderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontRenderContext", "com/intellij/openapi/editor/impl/view/ComplexTextFragment", "<init>"));
        }
        super(end - start);
        assert (start >= 0);
        assert (end <= lineChars.length);
        assert (start < end);
        this.myGlyphVector = FontLayoutService.getInstance().layoutGlyphVector(font, fontRenderContext, lineChars, start, end, isRtl);
        int numChars = end - start;
        int numGlyphs = this.myGlyphVector.getNumGlyphs();
        this.myCharPositions[numChars - 1] = totalWidth = (float)this.myGlyphVector.getGlyphPosition(numGlyphs).getX();
        int lastCharIndex = -1;
        float prevX = lastX = isRtl ? totalWidth : 0.0f;
        for (int i2 = 0; i2 < numGlyphs; ++i2) {
            Rectangle2D bounds;
            int visualGlyphIndex = isRtl ? numGlyphs - 1 - i2 : i2;
            int charIndex = this.myGlyphVector.getGlyphCharIndex(visualGlyphIndex);
            if (charIndex <= lastCharIndex || (bounds = this.myGlyphVector.getGlyphLogicalBounds(visualGlyphIndex).getBounds2D()).isEmpty()) continue;
            if (charIndex > lastCharIndex + 1) {
                for (int j = Math.max(0, lastCharIndex); j < charIndex; ++j) {
                    this.setCharPosition(j, prevX + (lastX - prevX) * (float)(j - lastCharIndex + 1) / (float)(charIndex - lastCharIndex), isRtl, numChars);
                }
            }
            float newX = isRtl ? Math.min(lastX, (float)bounds.getMinX()) : Math.max(lastX, (float)bounds.getMaxX());
            newX = Math.max(0.0f, Math.min(totalWidth, newX));
            this.setCharPosition(charIndex, newX, isRtl, numChars);
            prevX = lastX;
            lastX = newX;
            lastCharIndex = charIndex;
        }
        if (lastCharIndex < numChars - 1) {
            for (int j = Math.max(0, lastCharIndex); j < numChars - 1; ++j) {
                this.setCharPosition(j, prevX + (lastX - prevX) * (float)(j - lastCharIndex + 1) / (float)(numChars - lastCharIndex), isRtl, numChars);
            }
        }
    }

    private void setCharPosition(int logicalCharIndex, float x, boolean isRtl, int numChars) {
        int charPosition;
        int n = charPosition = isRtl ? numChars - logicalCharIndex - 2 : logicalCharIndex;
        if (charPosition >= 0 && charPosition < numChars - 1) {
            this.myCharPositions[charPosition] = x;
        }
    }

    @Override
    boolean isRtl() {
        return BitUtil.isSet((int)this.myGlyphVector.getLayoutFlags(), (int)4);
    }

    @Override
    public void draw(Graphics2D g, float x, float y, int startColumn, int endColumn) {
        assert (startColumn >= 0);
        assert (endColumn <= this.myCharPositions.length);
        assert (startColumn < endColumn);
        Color color = g.getColor();
        assert (color != null);
        float newX = x - this.getX(startColumn) + this.getX(endColumn);
        if (lastFragment == this && lastEndColumn == startColumn && lastEndX == x && lastY == y && color.equals(lastColor)) {
            lastEndColumn = endColumn;
            lastEndX = newX;
            return;
        }
        ComplexTextFragment.flushDrawingCache(g);
        lastFragment = this;
        lastStartColumn = startColumn;
        lastEndColumn = endColumn;
        lastColor = color;
        lastStartX = x;
        lastEndX = newX;
        lastY = y;
    }

    private void doDraw(Graphics2D g, float x, float y, int startColumn, int endColumn) {
        ComplexTextFragment.updateStats(endColumn - startColumn, this.myCharPositions.length);
        if (startColumn == 0 && endColumn == this.myCharPositions.length) {
            g.drawGlyphVector(this.myGlyphVector, x, y);
        } else {
            Shape savedClip = g.getClip();
            float startX = x - this.getX(startColumn);
            double xMin = (double)x - (startColumn == 0 ? 10000.0 : 0.0);
            double xMax = (double)(startX + this.getX(endColumn)) + (endColumn == this.myCharPositions.length ? 10000.0 : 0.0);
            double yMin = (double)y - 10000.0;
            double yMax = (double)y + 10000.0;
            g.clip(new Rectangle2D.Double(xMin, yMin, xMax - xMin, yMax - yMin));
            g.drawGlyphVector(this.myGlyphVector, startX, y);
            g.setClip(savedClip);
        }
    }

    public static void flushDrawingCache(Graphics2D g) {
        if (lastFragment != null) {
            g.setColor(lastColor);
            lastFragment.doDraw(g, lastStartX, lastY, lastStartColumn, lastEndColumn);
            lastFragment = null;
        }
    }

    private static void updateStats(int charCount, int glyphCount) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        ourCharsProcessed += (long)charCount;
        ourGlyphsProcessed += (long)glyphCount;
        if (++ourDrawingCount == 10000L) {
            LOG.debug("Text rendering stats: " + ourCharsProcessed + " chars, " + ourGlyphsProcessed + " glyps, ratio - " + (float)ourGlyphsProcessed / (float)ourCharsProcessed);
            ourDrawingCount = 0L;
            ourCharsProcessed = 0L;
            ourGlyphsProcessed = 0L;
        }
    }
}

