/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import org.jetbrains.annotations.NotNull;

public class DocumentUtil {
    @NotNull
    public static String getText(@NotNull RangeMarker range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/diff/impl/util/DocumentUtil", "getText"));
        }
        String string = range.getDocument().getText().substring(range.getStartOffset(), range.getEndOffset());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/util/DocumentUtil", "getText"));
        }
        return string;
    }

    public static boolean isEmpty(@NotNull RangeMarker rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/openapi/diff/impl/util/DocumentUtil", "isEmpty"));
        }
        return rangeMarker.getStartOffset() == rangeMarker.getEndOffset();
    }

    public static int getStartLine(@NotNull RangeMarker range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/diff/impl/util/DocumentUtil", "getStartLine"));
        }
        Document doc = range.getDocument();
        if (doc.getTextLength() == 0) {
            return 0;
        }
        return doc.getLineNumber(range.getStartOffset());
    }

    public static int getEndLine(@NotNull RangeMarker range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/diff/impl/util/DocumentUtil", "getEndLine"));
        }
        Document document = range.getDocument();
        int endOffset = range.getEndOffset();
        int endLine = document.getLineNumber(endOffset);
        if (document.getTextLength() == endOffset && DocumentUtil.lastLineIsNotEmpty(document, endLine)) {
            return document.getLineCount();
        }
        return endLine;
    }

    private static boolean lastLineIsNotEmpty(@NotNull Document document, int line) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/diff/impl/util/DocumentUtil", "lastLineIsNotEmpty"));
        }
        return document.getTextLength() != document.getLineStartOffset(line);
    }

    public static int getLength(@NotNull RangeMarker rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/openapi/diff/impl/util/DocumentUtil", "getLength"));
        }
        return rangeMarker.getEndOffset() - rangeMarker.getStartOffset();
    }
}

