/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.actions.DiffPanelComboBoxAction;
import com.intellij.openapi.diff.ex.DiffPanelEx;
import com.intellij.openapi.diff.impl.processing.HighlightMode;
import org.jetbrains.annotations.NotNull;

public class HighlightModeAction
extends DiffPanelComboBoxAction<HighlightMode> {
    private static final HighlightMode[] ourActionOrder = new HighlightMode[]{HighlightMode.BY_WORD, HighlightMode.BY_LINE, HighlightMode.NO_HIGHLIGHTING};

    public HighlightModeAction() {
        super(ourActionOrder);
        this.addAction(HighlightMode.BY_WORD, (AnAction)new HighlightingModeAction(DiffBundle.message((String)"diff.acton.highlight.mode.action.by.word", (Object[])new Object[0]), HighlightMode.BY_WORD));
        this.addAction(HighlightMode.BY_LINE, (AnAction)new HighlightingModeAction(DiffBundle.message((String)"diff.acton.highlight.mode.action.by.line", (Object[])new Object[0]), HighlightMode.BY_LINE));
        this.addAction(HighlightMode.NO_HIGHLIGHTING, (AnAction)new HighlightingModeAction(DiffBundle.message((String)"diff.acton.highlight.mode.action.no.highlighting", (Object[])new Object[0]), HighlightMode.NO_HIGHLIGHTING));
    }

    @Override
    @NotNull
    protected String getActionName() {
        String string = DiffBundle.message((String)"diff.acton.highlight.mode.action.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/actions/HighlightModeAction", "getActionName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected HighlightMode getCurrentOption(@NotNull DiffPanelEx diffPanel) {
        if (diffPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffPanel", "com/intellij/openapi/diff/actions/HighlightModeAction", "getCurrentOption"));
        }
        HighlightMode highlightMode = diffPanel.getHighlightMode();
        if (highlightMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/actions/HighlightModeAction", "getCurrentOption"));
        }
        return highlightMode;
    }

    private static class HighlightingModeAction
    extends DiffPanelComboBoxAction.DiffPanelAction {
        private final HighlightMode myHighlightMode;

        public HighlightingModeAction(String text, HighlightMode highlightMode) {
            super(text);
            this.myHighlightMode = highlightMode;
        }

        @Override
        protected void perform(@NotNull DiffPanelEx diffPanel) {
            if (diffPanel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffPanel", "com/intellij/openapi/diff/actions/HighlightModeAction$HighlightingModeAction", "perform"));
            }
            diffPanel.setHighlightMode(this.myHighlightMode);
        }
    }
}

