/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.diGraph.analyzer;

import com.intellij.internal.diGraph.analyzer.Mark;
import com.intellij.internal.diGraph.analyzer.MarkedEdge;
import com.intellij.internal.diGraph.analyzer.MarkedNode;
import com.intellij.internal.diGraph.analyzer.OneEndFunctor;
import com.intellij.internal.diGraph.analyzer.TwoEndsFunctor;
import com.intellij.openapi.util.Pair;
import java.util.Iterator;
import java.util.LinkedList;

public class GlobalAnalyzer {
    private static boolean stepOneEnd(MarkedNode currNode, LinkedList worklist, OneEndFunctor functor) {
        boolean result2 = false;
        Iterator i2 = currNode.outIterator();
        while (i2.hasNext()) {
            MarkedEdge currEdge = (MarkedEdge)i2.next();
            MarkedNode nextNode = (MarkedNode)currEdge.end();
            Mark theMark = functor.compute(currNode.getMark(), currEdge.getMark(), nextNode.getMark());
            if (theMark.coincidesWith(nextNode.getMark())) continue;
            result2 = true;
            nextNode.setMark(theMark);
            worklist.addFirst(nextNode);
        }
        return result2;
    }

    private static boolean stepTwoEnds(MarkedNode currNode, LinkedList worklist, TwoEndsFunctor functor) {
        boolean result2 = false;
        Iterator i2 = currNode.outIterator();
        while (i2.hasNext()) {
            MarkedEdge currEdge = (MarkedEdge)i2.next();
            MarkedNode nextNode = (MarkedNode)currEdge.end();
            Pair<Mark, Mark> markPair = functor.compute(currNode.getMark(), currEdge.getMark(), nextNode.getMark());
            Mark leftMark = (Mark)markPair.getFirst();
            Mark rightMark = (Mark)markPair.getSecond();
            if (!leftMark.coincidesWith(currNode.getMark())) {
                result2 = true;
                currNode.setMark(leftMark);
                worklist.addFirst(currNode);
            }
            if (rightMark.coincidesWith(nextNode.getMark())) continue;
            result2 = true;
            nextNode.setMark(rightMark);
            worklist.addFirst(nextNode);
        }
        return result2;
    }

    public static <T extends MarkedNode> boolean doOneEnd(LinkedList<T> init, OneEndFunctor functor) {
        boolean result2 = false;
        LinkedList worklist = new LinkedList();
        Iterator i2 = init.iterator();
        while (i2.hasNext()) {
            result2 = GlobalAnalyzer.stepOneEnd((MarkedNode)i2.next(), worklist, functor) || result2;
        }
        while (worklist.size() > 0) {
            result2 = GlobalAnalyzer.stepOneEnd((MarkedNode)worklist.removeFirst(), worklist, functor) || result2;
        }
        return result2;
    }

    public static <T extends MarkedNode> boolean doTwoEnds(LinkedList<T> init, TwoEndsFunctor functor) {
        boolean result2 = false;
        LinkedList worklist = new LinkedList();
        Iterator i2 = init.iterator();
        while (i2.hasNext()) {
            result2 = GlobalAnalyzer.stepTwoEnds((MarkedNode)i2.next(), worklist, functor) || result2;
        }
        while (worklist.size() > 0) {
            result2 = GlobalAnalyzer.stepTwoEnds((MarkedNode)worklist.removeFirst(), worklist, functor) || result2;
        }
        return result2;
    }
}

