/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.util.ResourceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class DumpInspectionDescriptionsAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.internal.DumpInspectionDescriptionsAction");

    public DumpInspectionDescriptionsAction() {
        super("Dump inspection descriptions");
    }

    public void actionPerformed(AnActionEvent event) {
        File groupsFile;
        boolean groupsOk;
        InspectionProfileImpl profile = InspectionProfileManager.getInstance().getCurrentProfile();
        InspectionToolWrapper[] tools = profile.getInspectionTools(null);
        final TreeSet classes = ContainerUtil.newTreeSet();
        final TreeMap groups = ContainerUtil.newTreeMap();
        String tempDirectory = FileUtil.getTempDirectory();
        File descDirectory = new File(tempDirectory, "inspections");
        if (!descDirectory.mkdirs() && !descDirectory.isDirectory()) {
            LOG.error("Unable to create directory: " + descDirectory.getAbsolutePath());
            return;
        }
        for (InspectionToolWrapper toolWrapper : tools) {
            classes.add(DumpInspectionDescriptionsAction.getInspectionClass(toolWrapper).getName());
            String group = DumpInspectionDescriptionsAction.getGroupName(toolWrapper);
            Collection names = (Collection)groups.get(group);
            if (names == null) {
                names = ContainerUtil.newTreeSet();
                groups.put(group, names);
            }
            names.add(toolWrapper.getShortName());
            final URL url = DumpInspectionDescriptionsAction.getDescriptionUrl(toolWrapper);
            if (url == null) continue;
            DumpInspectionDescriptionsAction.doDump(new File(descDirectory, toolWrapper.getShortName() + ".html"), new Processor(){

                @Override
                public void process(BufferedWriter writer) throws Exception {
                    writer.write(ResourceUtil.loadText((URL)url));
                }
            });
        }
        DumpInspectionDescriptionsAction.doNotify("Inspection descriptions dumped to\n" + descDirectory.getAbsolutePath());
        File fqnListFile = new File(tempDirectory, "inspection_fqn_list.txt");
        boolean fqnOk = DumpInspectionDescriptionsAction.doDump(fqnListFile, new Processor(){

            @Override
            public void process(BufferedWriter writer) throws Exception {
                for (String name : classes) {
                    writer.write(name);
                    writer.newLine();
                }
            }
        });
        if (fqnOk) {
            DumpInspectionDescriptionsAction.doNotify("Inspection class names dumped to\n" + fqnListFile.getAbsolutePath());
        }
        if (groupsOk = DumpInspectionDescriptionsAction.doDump(groupsFile = new File(tempDirectory, "inspection_groups.txt"), new Processor(){

            @Override
            public void process(BufferedWriter writer) throws Exception {
                for (Map.Entry entry : groups.entrySet()) {
                    writer.write((String)entry.getKey());
                    writer.write(58);
                    writer.newLine();
                    for (String name : (Collection)entry.getValue()) {
                        writer.write("  ");
                        writer.write(name);
                        writer.newLine();
                    }
                }
            }
        })) {
            DumpInspectionDescriptionsAction.doNotify("Inspection groups dumped to\n" + fqnListFile.getAbsolutePath());
        }
    }

    private static Class getInspectionClass(InspectionToolWrapper toolWrapper) {
        return toolWrapper instanceof LocalInspectionToolWrapper ? ((LocalInspectionTool)((LocalInspectionToolWrapper)toolWrapper).getTool()).getClass() : toolWrapper.getClass();
    }

    private static String getGroupName(InspectionToolWrapper toolWrapper) {
        String name = toolWrapper.getGroupDisplayName();
        return StringUtil.isEmptyOrSpaces((String)name) ? "General" : name;
    }

    private static URL getDescriptionUrl(InspectionToolWrapper toolWrapper) {
        Class aClass = DumpInspectionDescriptionsAction.getInspectionClass(toolWrapper);
        return ResourceUtil.getResource((Class)aClass, (String)"/inspectionDescriptions", (String)(toolWrapper.getShortName() + ".html"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doDump(File file2, Processor processor2) {
        boolean bl;
        BufferedWriter writer = new BufferedWriter(new FileWriter(file2));
        try {
            processor2.process(writer);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                writer.close();
                throw throwable;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return false;
            }
        }
        writer.close();
        return bl;
    }

    private static void doNotify(String message) {
        Notifications.Bus.notify((Notification)new Notification("Actions", "Inspection descriptions dumped", message, NotificationType.INFORMATION));
    }

    private static interface Processor {
        public void process(BufferedWriter var1) throws Exception;
    }
}

