/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import javax.swing.Icon;

public class ProjectWizardUtil {
    private ProjectWizardUtil() {
    }

    public static String findNonExistingFileName(String searchDirectory, String preferredName, String extension) {
        int idx = 0;
        String fileName;
        while (new File(searchDirectory, fileName = (idx > 0 ? preferredName + idx : preferredName) + extension).exists()) {
            ++idx;
        }
        return fileName;
    }

    public static boolean createDirectoryIfNotExists(String promptPrefix, String directoryPath, boolean promptUser) {
        File dir = new File(directoryPath);
        if (!dir.exists()) {
            String ide;
            String message;
            int answer;
            if (promptUser && (answer = Messages.showOkCancelDialog((String)(message = IdeBundle.message((String)"prompt.project.wizard.directory.does.not.exist", (Object[])new Object[]{promptPrefix, dir, ide = ApplicationNamesInfo.getInstance().getFullProductName()})), (String)IdeBundle.message((String)"title.directory.does.not.exist", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
                return false;
            }
            if (!FileUtil.createDirectory((File)dir)) {
                Messages.showErrorDialog((String)IdeBundle.message((String)"error.failed.to.create.directory", (Object[])new Object[]{dir.getPath()}), (String)CommonBundle.getErrorTitle());
                return false;
            }
        }
        if (SystemInfo.isUnix && !dir.canWrite()) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.directory.read.only", (Object[])new Object[]{dir.getPath()}), (String)CommonBundle.getErrorTitle());
            return false;
        }
        return true;
    }
}

