/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.ide.passwordSafe.PasswordStorage;
import com.intellij.ide.passwordSafe.impl.providers.EncryptionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasePasswordSafeProvider
implements PasswordStorage {
    @NotNull
    protected abstract byte[] key();

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/ide/passwordSafe/impl/providers/BasePasswordSafeProvider", "get"));
        }
        byte[] masterKey = this.key();
        byte[] encryptedPassword = this.getEncryptedPassword(EncryptionUtil.encryptKey(masterKey, EncryptionUtil.rawKey(attributes)));
        OneTimeString password = encryptedPassword == null ? null : EncryptionUtil.decryptText(masterKey, encryptedPassword);
        return password == null ? null : new Credentials(attributes.getUserName(), password);
    }

    protected abstract byte[] getEncryptedPassword(@NotNull byte[] var1);

    protected abstract void removeEncryptedPassword(byte[] var1);

    public final void set(@NotNull CredentialAttributes attributes, @Nullable Credentials value) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/ide/passwordSafe/impl/providers/BasePasswordSafeProvider", "set"));
        }
        byte[] key2 = EncryptionUtil.encryptKey(this.key(), EncryptionUtil.rawKey(attributes));
        if (value == null || value.getPassword() == null) {
            this.removeEncryptedPassword(key2);
        } else {
            this.storeEncryptedPassword(key2, EncryptionUtil.encryptText(this.key(), value.getPassword()));
        }
    }

    protected abstract void storeEncryptedPassword(byte[] var1, byte[] var2);
}

