/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.impl.DataValidator;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.ide.impl.dataRules.CopyProviderRule;
import com.intellij.ide.impl.dataRules.CutProviderRule;
import com.intellij.ide.impl.dataRules.FileEditorRule;
import com.intellij.ide.impl.dataRules.FileTextRule;
import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.ide.impl.dataRules.InactiveEditorRule;
import com.intellij.ide.impl.dataRules.NavigatableArrayRule;
import com.intellij.ide.impl.dataRules.PasteProviderRule;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.reference.SoftReference;
import com.intellij.util.KeyedLazyInstanceEP;
import com.intellij.util.containers.WeakValueHashMap;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataManagerImpl
extends DataManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.impl.DataManagerImpl");
    private final ConcurrentMap<String, GetDataRule> myDataConstantToRuleMap = new ConcurrentHashMap<String, GetDataRule>();
    private WindowManagerEx myWindowManager;
    private static final Set<String> ourSafeKeys = new HashSet<String>(Arrays.asList(CommonDataKeys.PROJECT.getName(), CommonDataKeys.EDITOR.getName(), PlatformDataKeys.IS_MODAL_CONTEXT.getName(), PlatformDataKeys.CONTEXT_COMPONENT.getName(), PlatformDataKeys.MODALITY_STATE.getName()));

    public DataManagerImpl() {
        this.registerRules();
    }

    @Nullable
    private Object getData(@NotNull String dataId, Component focusedComponent) {
        if (dataId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/ide/impl/DataManagerImpl", "getData"));
        }
        for (Component c = focusedComponent; c != null; c = c.getParent()) {
            Object data;
            DataProvider dataProvider = DataManagerImpl.getDataProviderEx(c);
            if (dataProvider == null || (data = this.getDataFromProvider(dataProvider, dataId, null)) == null) continue;
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object getDataFromProvider(final @NotNull DataProvider provider, @NotNull String dataId, @Nullable Set<String> alreadyComputedIds) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ide/impl/DataManagerImpl", "getDataFromProvider"));
        }
        if (dataId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/ide/impl/DataManagerImpl", "getDataFromProvider"));
        }
        if (alreadyComputedIds != null && alreadyComputedIds.contains(dataId)) {
            return null;
        }
        try {
            Object data = provider.getData(dataId);
            if (data != null) {
                Object object = DataManagerImpl.validated(data, dataId, provider);
                return object;
            }
            GetDataRule dataRule = this.getDataRule(dataId);
            if (dataRule != null) {
                THashSet ids = alreadyComputedIds == null ? new THashSet() : alreadyComputedIds;
                ids.add(dataId);
                data = dataRule.getData(new DataProvider((Set)ids){
                    final /* synthetic */ Set val$ids;
                    {
                        this.val$ids = set2;
                    }

                    public Object getData(String dataId) {
                        return DataManagerImpl.this.getDataFromProvider(provider, dataId, this.val$ids);
                    }
                });
                if (data != null) {
                    Object object = DataManagerImpl.validated(data, dataId, provider);
                    return object;
                }
            }
            Object var6_7 = null;
            return var6_7;
        }
        finally {
            if (alreadyComputedIds != null) {
                alreadyComputedIds.remove(dataId);
            }
        }
    }

    @Nullable
    public static DataProvider getDataProviderEx(Object component) {
        DataProvider dataProvider = null;
        if (component instanceof DataProvider) {
            dataProvider = (DataProvider)component;
        } else if (component instanceof TypeSafeDataProvider) {
            dataProvider = new TypeSafeDataProviderAdapter((TypeSafeDataProvider)component);
        } else if (component instanceof JComponent) {
            dataProvider = DataManagerImpl.getDataProvider((JComponent)((JComponent)component));
        }
        return dataProvider;
    }

    @Nullable
    public GetDataRule getDataRule(@NotNull String dataId) {
        if (dataId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/ide/impl/DataManagerImpl", "getDataRule"));
        }
        GetDataRule rule = this.getRuleFromMap(dataId);
        if (rule != null) {
            return rule;
        }
        final GetDataRule plainRule = this.getRuleFromMap(AnActionEvent.uninjectedId((String)dataId));
        if (plainRule != null) {
            return new GetDataRule(){

                @Override
                public Object getData(final DataProvider dataProvider) {
                    return plainRule.getData(new DataProvider(){

                        @Nullable
                        public Object getData(@NonNls String dataId) {
                            return dataProvider.getData(AnActionEvent.injectedId((String)dataId));
                        }
                    });
                }
            };
        }
        return null;
    }

    @Nullable
    private GetDataRule getRuleFromMap(@NotNull String dataId) {
        if (dataId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/ide/impl/DataManagerImpl", "getRuleFromMap"));
        }
        GetDataRule rule = (GetDataRule)this.myDataConstantToRuleMap.get(dataId);
        if (rule == null && !this.myDataConstantToRuleMap.containsKey(dataId)) {
            KeyedLazyInstanceEP[] eps;
            for (KeyedLazyInstanceEP ruleEP : eps = (KeyedLazyInstanceEP[])Extensions.getExtensions(GetDataRule.EP_NAME)) {
                if (!ruleEP.key.equals(dataId)) continue;
                rule = (GetDataRule)ruleEP.getInstance();
            }
            if (rule != null) {
                this.myDataConstantToRuleMap.putIfAbsent(dataId, rule);
            }
        }
        return rule;
    }

    @Nullable
    private static Object validated(@NotNull Object data, @NotNull String dataId, @NotNull Object dataSource) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/ide/impl/DataManagerImpl", "validated"));
        }
        if (dataId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/ide/impl/DataManagerImpl", "validated"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/ide/impl/DataManagerImpl", "validated"));
        }
        Object invalidData = DataValidator.findInvalidData(dataId, data, dataSource);
        if (invalidData != null) {
            return null;
        }
        return data;
    }

    public DataContext getDataContext(Component component) {
        return new MyDataContext(component);
    }

    public DataContext getDataContext(@NotNull Component component, int x, int y) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ide/impl/DataManagerImpl", "getDataContext"));
        }
        if (x < 0 || x >= component.getWidth() || y < 0 || y >= component.getHeight()) {
            throw new IllegalArgumentException("wrong point: x=" + x + "; y=" + y);
        }
        if (component instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)component;
            int index = tabbedPane.getUI().tabForCoordinate(tabbedPane, x, y);
            return this.getDataContext(index != -1 ? tabbedPane.getComponentAt(index) : tabbedPane);
        }
        return this.getDataContext(component);
    }

    public void setWindowManager(WindowManagerEx windowManager) {
        this.myWindowManager = windowManager;
    }

    @NotNull
    public DataContext getDataContext() {
        DataContext dataContext = this.getDataContext(this.getFocusedComponent());
        if (dataContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/impl/DataManagerImpl", "getDataContext"));
        }
        return dataContext;
    }

    public AsyncResult<DataContext> getDataContextFromFocus() {
        AsyncResult context = new AsyncResult();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> context.setDone((Object)this.getDataContext()), ModalityState.defaultModalityState());
        return context;
    }

    public DataContext getDataContextTest(Component component) {
        DataContext dataContext = this.getDataContext(component);
        if (this.myWindowManager == null) {
            return dataContext;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Component focusedComponent = this.myWindowManager.getFocusedComponent(project2);
        if (focusedComponent != null) {
            dataContext = this.getDataContext(focusedComponent);
        }
        return dataContext;
    }

    @Nullable
    private Component getFocusedComponent() {
        IdeFocusManager fm;
        if (this.myWindowManager == null) {
            return null;
        }
        Window activeWindow = this.myWindowManager.getMostRecentFocusedWindow();
        if (activeWindow == null && (activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null && (activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) == null) {
            return null;
        }
        if (Registry.is((String)"actionSystem.noContextComponentWhileFocusTransfer") && (fm = IdeFocusManager.findInstanceByComponent((Component)activeWindow)).isFocusBeingTransferred()) {
            return null;
        }
        if (activeWindow instanceof FloatingDecorator) {
            boolean toolWindowIsNotFocused;
            IdeFocusManager ideFocusManager = IdeFocusManager.findInstanceByComponent((Component)activeWindow);
            IdeFrame lastFocusedFrame = ideFocusManager.getLastFocusedFrame();
            JComponent frameComponent = lastFocusedFrame != null ? lastFocusedFrame.getComponent() : null;
            Window lastFocusedWindow = frameComponent != null ? SwingUtilities.getWindowAncestor(frameComponent) : null;
            boolean bl = toolWindowIsNotFocused = this.myWindowManager.getFocusedComponent(activeWindow) == null;
            if (toolWindowIsNotFocused && lastFocusedWindow != null) {
                activeWindow = lastFocusedWindow;
            }
        }
        Component focusedComponent = null;
        for (Window window = activeWindow; window != null && (focusedComponent = this.myWindowManager.getFocusedComponent(window)) == null; window = window.getOwner()) {
        }
        if (focusedComponent == null) {
            focusedComponent = activeWindow;
        }
        return focusedComponent;
    }

    private void registerRules() {
        this.myDataConstantToRuleMap.put(PlatformDataKeys.COPY_PROVIDER.getName(), new CopyProviderRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.CUT_PROVIDER.getName(), new CutProviderRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.PASTE_PROVIDER.getName(), new PasteProviderRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.FILE_TEXT.getName(), new FileTextRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.FILE_EDITOR.getName(), new FileEditorRule());
        this.myDataConstantToRuleMap.put(CommonDataKeys.NAVIGATABLE_ARRAY.getName(), new NavigatableArrayRule());
        this.myDataConstantToRuleMap.put(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE.getName(), new InactiveEditorRule());
    }

    public <T> void saveInDataContext(DataContext dataContext, @NotNull Key<T> dataKey, @Nullable T data) {
        if (dataKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataKey", "com/intellij/ide/impl/DataManagerImpl", "saveInDataContext"));
        }
        if (dataContext instanceof UserDataHolder) {
            ((UserDataHolder)dataContext).putUserData(dataKey, data);
        }
    }

    @Nullable
    public <T> T loadFromDataContext(@NotNull DataContext dataContext, @NotNull Key<T> dataKey) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/impl/DataManagerImpl", "loadFromDataContext"));
        }
        if (dataKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataKey", "com/intellij/ide/impl/DataManagerImpl", "loadFromDataContext"));
        }
        return (T)(dataContext instanceof UserDataHolder ? ((UserDataHolder)dataContext).getUserData(dataKey) : null);
    }

    @Nullable
    public static Editor validateEditor(Editor editor) {
        JComponent jComponent;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner instanceof JComponent && (jComponent = (JComponent)focusOwner).getClientProperty("AuxEditorComponent") != null) {
            return null;
        }
        return editor;
    }

    public static class MyDataContext
    implements DataContext,
    UserDataHolder {
        private int myEventCount = -1;
        private final Reference<Component> myRef;
        private Map<Key, Object> myUserData;
        private final Map<String, Object> myCachedData = new WeakValueHashMap();

        public MyDataContext(Component component) {
            this.myRef = component == null ? null : new WeakReference<Component>(component);
        }

        public void setEventCount(int eventCount, Object caller) {
            assert (caller instanceof IdeKeyEventDispatcher) : "This method might be accessible from " + IdeKeyEventDispatcher.class.getName() + " only";
            this.myCachedData.clear();
            this.myEventCount = eventCount;
        }

        public Object getData(String dataId) {
            if (dataId == null) {
                return null;
            }
            int currentEventCount = IdeEventQueue.getInstance().getEventCount();
            if (this.myEventCount != -1 && this.myEventCount != currentEventCount) {
                LOG.error("cannot share data context between Swing events; initial event count = " + this.myEventCount + "; current event count = " + currentEventCount);
                return this.doGetData(dataId);
            }
            if (ourSafeKeys.contains(dataId)) {
                Object answer = this.myCachedData.get(dataId);
                if (answer == null) {
                    answer = this.doGetData(dataId);
                    this.myCachedData.put(dataId, answer == null ? NullResult.INSTANCE : answer);
                }
                return answer != NullResult.INSTANCE ? answer : null;
            }
            return this.doGetData(dataId);
        }

        @Nullable
        private Object doGetData(@NotNull String dataId) {
            if (dataId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/ide/impl/DataManagerImpl$MyDataContext", "doGetData"));
            }
            Component component = (Component)SoftReference.dereference(this.myRef);
            if (PlatformDataKeys.IS_MODAL_CONTEXT.is(dataId)) {
                if (component == null) {
                    return null;
                }
                return IdeKeyEventDispatcher.isModalContext(component);
            }
            if (PlatformDataKeys.CONTEXT_COMPONENT.is(dataId)) {
                return component;
            }
            if (PlatformDataKeys.MODALITY_STATE.is(dataId)) {
                return component != null ? ModalityState.stateForComponent((Component)component) : ModalityState.NON_MODAL;
            }
            if (CommonDataKeys.EDITOR.is(dataId) || CommonDataKeys.HOST_EDITOR.is(dataId)) {
                Editor editor = (Editor)((DataManagerImpl)DataManager.getInstance()).getData(dataId, component);
                return DataManagerImpl.validateEditor(editor);
            }
            return ((DataManagerImpl)DataManager.getInstance()).getData(dataId, component);
        }

        @NonNls
        public String toString() {
            return "component=" + SoftReference.dereference(this.myRef);
        }

        public <T> T getUserData(@NotNull Key<T> key2) {
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/ide/impl/DataManagerImpl$MyDataContext", "getUserData"));
            }
            return (T)this.getOrCreateMap().get(key2);
        }

        public <T> void putUserData(@NotNull Key<T> key2, @Nullable T value) {
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/ide/impl/DataManagerImpl$MyDataContext", "putUserData"));
            }
            this.getOrCreateMap().put(key2, value);
        }

        @NotNull
        private Map<Key, Object> getOrCreateMap() {
            WeakValueHashMap userData = this.myUserData;
            if (userData == null) {
                this.myUserData = userData = new WeakValueHashMap();
            }
            WeakValueHashMap weakValueHashMap = userData;
            if (weakValueHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/impl/DataManagerImpl$MyDataContext", "getOrCreateMap"));
            }
            return weakValueHashMap;
        }
    }

    private static class NullResult {
        public static final NullResult INSTANCE = new NullResult();

        private NullResult() {
        }
    }
}

