/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.type;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.type.TypeHierarchyNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class SupertypesHierarchyTreeStructure
extends HierarchyTreeStructure {
    public SupertypesHierarchyTreeStructure(Project project2, PsiClass aClass) {
        super(project2, new TypeHierarchyNodeDescriptor(project2, null, (PsiElement)aClass, true));
    }

    @Override
    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        PsiClass functionalInterfaceClass;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/hierarchy/type/SupertypesHierarchyTreeStructure", "buildChildren"));
        }
        PsiElement element = ((TypeHierarchyNodeDescriptor)descriptor).getPsiClass();
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            PsiClass[] supers = SupertypesHierarchyTreeStructure.getSupers(psiClass);
            ArrayList<TypeHierarchyNodeDescriptor> descriptors = new ArrayList<TypeHierarchyNodeDescriptor>();
            PsiClass objectClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass("java.lang.Object", psiClass.getResolveScope());
            for (PsiClass aSuper : supers) {
                if (psiClass.isInterface() && aSuper.equals(objectClass)) continue;
                descriptors.add(new TypeHierarchyNodeDescriptor(this.myProject, descriptor, (PsiElement)aSuper, false));
            }
            HierarchyNodeDescriptor[] hierarchyNodeDescriptorArray = descriptors.toArray(new HierarchyNodeDescriptor[descriptors.size()]);
            if (hierarchyNodeDescriptorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/type/SupertypesHierarchyTreeStructure", "buildChildren"));
            }
            return hierarchyNodeDescriptorArray;
        }
        if (element instanceof PsiFunctionalExpression && (functionalInterfaceClass = PsiUtil.resolveClassInType((PsiType)((PsiFunctionalExpression)element).getFunctionalInterfaceType())) != null) {
            HierarchyNodeDescriptor[] hierarchyNodeDescriptorArray = new HierarchyNodeDescriptor[]{new TypeHierarchyNodeDescriptor(this.myProject, descriptor, (PsiElement)functionalInterfaceClass, false)};
            if (hierarchyNodeDescriptorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/type/SupertypesHierarchyTreeStructure", "buildChildren"));
            }
            return hierarchyNodeDescriptorArray;
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/type/SupertypesHierarchyTreeStructure", "buildChildren"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    private static PsiClass[] getSupers(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/ide/hierarchy/type/SupertypesHierarchyTreeStructure", "getSupers"));
        }
        if (psiClass.isAnnotationType()) {
            PsiClass[] psiClassArray = SupertypesHierarchyTreeStructure.getMetaAnnotations(psiClass);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/type/SupertypesHierarchyTreeStructure", "getSupers"));
            }
            return psiClassArray;
        }
        PsiClass[] psiClassArray = psiClass.getSupers();
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/type/SupertypesHierarchyTreeStructure", "getSupers"));
        }
        return psiClassArray;
    }

    @NotNull
    private static PsiClass[] getMetaAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/ide/hierarchy/type/SupertypesHierarchyTreeStructure", "getMetaAnnotations"));
        }
        HashSet supers = ContainerUtil.newHashSet();
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList != null) {
            for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                PsiClass aClass;
                PsiAnnotation.TargetType target;
                PsiElement annotationType;
                PsiJavaCodeReferenceElement ref;
                if (SupertypesHierarchyTreeStructure.isJavaLangAnnotation(annotation) || (ref = annotation.getNameReferenceElement()) == null || !((annotationType = ref.resolve()) instanceof PsiClass) || (target = AnnotationTargetUtil.findAnnotationTarget((PsiClass)(aClass = (PsiClass)annotationType), (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.ANNOTATION_TYPE})) == null || target == PsiAnnotation.TargetType.UNKNOWN) continue;
                supers.add(aClass);
            }
        }
        PsiClass[] psiClassArray = supers.toArray(new PsiClass[supers.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/type/SupertypesHierarchyTreeStructure", "getMetaAnnotations"));
        }
        return psiClassArray;
    }

    private static boolean isJavaLangAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/ide/hierarchy/type/SupertypesHierarchyTreeStructure", "isJavaLangAnnotation"));
        }
        String qualifiedName = annotation.getQualifiedName();
        return qualifiedName != null && qualifiedName.startsWith("java.lang.annotation");
    }
}

