/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.actions;

import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.ui.CreateFromTemplateDialog;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public abstract class CreateFromTemplateActionBase
extends AnAction {
    public CreateFromTemplateActionBase(String title, String description, Icon icon) {
        super(title, description, icon);
    }

    public final void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        PsiDirectory dir = this.getTargetDirectory(dataContext, view);
        if (dir == null) {
            return;
        }
        Project project2 = dir.getProject();
        FileTemplate selectedTemplate = this.getTemplate(project2, dir);
        if (selectedTemplate != null) {
            AnAction action = this.getReplacedAction(selectedTemplate);
            if (action != null) {
                action.actionPerformed(e);
            } else {
                FileTemplateManager.getInstance(project2).addRecentName(selectedTemplate.getName());
                AttributesDefaults defaults = this.getAttributesDefaults(dataContext);
                CreateFromTemplateDialog dialog2 = new CreateFromTemplateDialog(project2, dir, selectedTemplate, defaults, defaults != null ? defaults.getDefaultProperties() : null);
                PsiElement createdElement = dialog2.create();
                if (createdElement != null) {
                    this.elementCreated(dialog2, createdElement);
                    view.selectElement(createdElement);
                    if (selectedTemplate.isLiveTemplateEnabled() && createdElement instanceof PsiFile) {
                        CreateFromTemplateActionBase.startLiveTemplate((PsiFile)createdElement);
                    }
                }
            }
        }
    }

    public static void startLiveTemplate(PsiFile file2) {
        Project project2 = file2.getProject();
        Editor editor = EditorHelper.openInEditor((PsiElement)file2);
        if (editor == null) {
            return;
        }
        TemplateImpl template = new TemplateImpl("", file2.getText(), "");
        template.setInline(true);
        int count = template.getSegmentsCount();
        if (count == 0) {
            return;
        }
        HashSet<String> variables = new HashSet<String>();
        for (int i2 = 0; i2 < count; ++i2) {
            variables.add(template.getSegmentName(i2));
        }
        variables.removeAll(TemplateImpl.INTERNAL_VARS_SET);
        for (String variable : variables) {
            template.addVariable(variable, null, "\"" + variable + "\"", true);
        }
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> editor.getDocument().setText((CharSequence)template.getTemplateText()));
        TemplateManager.getInstance(project2).startTemplate(editor, template);
    }

    @Nullable
    protected PsiDirectory getTargetDirectory(DataContext dataContext, IdeView view) {
        return DirectoryChooserUtil.getOrChooseDirectory(view);
    }

    @Nullable
    protected AnAction getReplacedAction(FileTemplate selectedTemplate) {
        return null;
    }

    protected abstract FileTemplate getTemplate(Project var1, PsiDirectory var2);

    @Nullable
    public AttributesDefaults getAttributesDefaults(DataContext dataContext) {
        return null;
    }

    protected void elementCreated(CreateFromTemplateDialog dialog2, PsiElement createdElement) {
    }
}

