/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class SystemHealthMonitor
extends ApplicationComponent.Adapter {
    private static final Logger LOG = Logger.getInstance(SystemHealthMonitor.class);
    private static final NotificationGroup GROUP = new NotificationGroup("System Health", NotificationDisplayType.STICKY_BALLOON, false);
    private static final NotificationGroup LOG_GROUP = NotificationGroup.logOnlyGroup((String)"System Health (minor)");
    private final PropertiesComponent myProperties;

    public SystemHealthMonitor(@NotNull PropertiesComponent properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/ide/SystemHealthMonitor", "<init>"));
        }
        this.myProperties = properties;
    }

    public void initComponent() {
        this.checkJvm();
        this.checkIBus();
        this.checkLauncherScript();
        SystemHealthMonitor.startDiskSpaceMonitoring();
    }

    private void checkJvm() {
        if (StringUtil.endsWithIgnoreCase((String)System.getProperty("java.version", ""), (String)"-ea")) {
            this.showNotification("unsupported.jvm.ea.message");
        }
    }

    private void checkIBus() {
        String fix;
        Matcher m;
        String version;
        String xim;
        if (SystemInfo.isXWindow && (xim = System.getenv("XMODIFIERS")) != null && xim.contains("im=ibus") && (version = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"ibus-daemon", "--version"}))) != null && (m = Pattern.compile("ibus-daemon - Version ([0-9.]+)").matcher(version)).find() && StringUtil.compareVersionNumbers((String)m.group(1), (String)"1.5.11") < 0 && ((fix = System.getenv("IBUS_ENABLE_SYNC_MODE")) == null || fix.isEmpty() || fix.equals("0") || fix.equalsIgnoreCase("false"))) {
            this.showNotification("ibus.blocking.warn.message");
        }
    }

    private void checkLauncherScript() {
        if (SystemInfo.isXWindow && System.getProperty("jb.restart.code") != null) {
            this.showNotification("ide.launcher.script.outdated");
        }
    }

    private void showNotification(@PropertyKey(resourceBundle="messages.IdeBundle") String key2) {
        final String ignoreKey = "ignore." + key2;
        boolean ignored = this.myProperties.isValueSet(ignoreKey);
        LOG.info("issue detected: " + key2 + (ignored ? " (ignored)" : ""));
        if (ignored) {
            return;
        }
        final String message = IdeBundle.message((String)key2, (Object[])new Object[0]) + IdeBundle.message((String)"sys.health.acknowledge.link", (Object[])new Object[0]);
        final Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

            @Override
            public void appFrameCreated(String[] commandLineArgs, @NotNull Ref<Boolean> willOpenProject) {
                if (willOpenProject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "willOpenProject", "com/intellij/ide/SystemHealthMonitor$1", "appFrameCreated"));
                }
                app.invokeLater(() -> {
                    JRootPane component = WindowManager.getInstance().findVisibleFrame().getRootPane();
                    if (component != null) {
                        Rectangle rect = component.getVisibleRect();
                        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.WARNING, (HyperlinkListener)new HyperlinkAdapter(){

                            protected void hyperlinkActivated(HyperlinkEvent e) {
                                String url = e.getDescription();
                                if ("ack".equals(url)) {
                                    SystemHealthMonitor.this.myProperties.setValue(ignoreKey, "true");
                                } else {
                                    BrowserUtil.browse((String)url);
                                }
                            }
                        }).setFadeoutTime(-1L).setHideOnFrameResize(false).setHideOnLinkClick(true).setDisposable((Disposable)app).createBalloon().show(new RelativePoint((Component)component, new Point(rect.x + 30, rect.y + rect.height - 10)), Balloon.Position.above);
                    }
                    Notification notification = LOG_GROUP.createNotification(message, NotificationType.WARNING);
                    notification.setImportant(true);
                    Notifications.Bus.notify((Notification)notification);
                });
            }
        });
    }

    private static void startDiskSpaceMonitoring() {
        if (SystemProperties.getBooleanProperty((String)"idea.no.system.path.space.monitoring", (boolean)false)) {
            return;
        }
        final File file2 = new File(PathManager.getSystemPath());
        final AtomicBoolean reported = new AtomicBoolean();
        final ThreadLocal ourFreeSpaceCalculation = new ThreadLocal();
        JobScheduler.getScheduler().schedule(new Runnable(){
            private static final long LOW_DISK_SPACE_THRESHOLD = 0x3200000L;
            private static final long MAX_WRITE_SPEED_IN_BPS = 524288000L;

            @Override
            public void run() {
                if (!reported.get()) {
                    Future future2 = (Future)ourFreeSpaceCalculation.get();
                    if (future2 == null) {
                        future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                            long fileUsableSpace = file2.getUsableSpace();
                            while (fileUsableSpace == 0L) {
                                TimeoutUtil.sleep((long)5000L);
                                fileUsableSpace = file2.getUsableSpace();
                            }
                            return fileUsableSpace;
                        });
                        ourFreeSpaceCalculation.set(future2);
                    }
                    if (!future2.isDone() || future2.isCancelled()) {
                        JobScheduler.getScheduler().schedule(this, 1L, TimeUnit.SECONDS);
                        return;
                    }
                    try {
                        long fileUsableSpace = (Long)future2.get();
                        long timeout = Math.max(5L, (fileUsableSpace - 0x3200000L) / 524288000L);
                        ourFreeSpaceCalculation.set(null);
                        if (fileUsableSpace < 0x3200000L) {
                            if (ReadAction.compute(() -> NotificationsConfiguration.getNotificationsConfiguration()) == null) {
                                ourFreeSpaceCalculation.set(future2);
                                JobScheduler.getScheduler().schedule(this, 1L, TimeUnit.SECONDS);
                                return;
                            }
                            reported.compareAndSet(false, true);
                            SwingUtilities.invokeLater(() -> {
                                String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                                String message = IdeBundle.message((String)"low.disk.space.message", (Object[])new Object[]{productName});
                                if (fileUsableSpace < 102400L) {
                                    LOG.warn(message + " (" + fileUsableSpace + ")");
                                    Messages.showErrorDialog((String)message, (String)"Fatal Configuration Problem");
                                    reported.compareAndSet(true, false);
                                    this.restart(timeout);
                                } else {
                                    GROUP.createNotification(message, file2.getPath(), NotificationType.ERROR, null).whenExpired(() -> {
                                        reported.compareAndSet(true, false);
                                        this.restart(timeout);
                                    }).notify(null);
                                }
                            });
                        } else {
                            this.restart(timeout);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Throwable)ex);
                    }
                }
            }

            private void restart(long timeout) {
                JobScheduler.getScheduler().schedule(this, timeout, TimeUnit.SECONDS);
            }
        }, 1L, TimeUnit.SECONDS);
    }
}

