/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.Patches;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.FutureResult;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.datatransfer.DataTransferer;

public class ClipboardSynchronizer
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.ClipboardSynchronizer");
    private final ClipboardHandler myClipboardHandler = ApplicationManager.getApplication().isHeadlessEnvironment() && ApplicationManager.getApplication().isUnitTestMode() ? new HeadlessClipboardHandler() : (Patches.SLOW_GETTING_CLIPBOARD_CONTENTS && SystemInfo.isMac ? new MacClipboardHandler() : (Patches.SLOW_GETTING_CLIPBOARD_CONTENTS && SystemInfo.isXWindow ? new XWinClipboardHandler() : new ClipboardHandler()));

    public static ClipboardSynchronizer getInstance() {
        return (ClipboardSynchronizer)ApplicationManager.getApplication().getComponent(ClipboardSynchronizer.class);
    }

    public void initComponent() {
        this.myClipboardHandler.init();
    }

    public void disposeComponent() {
        this.myClipboardHandler.dispose();
    }

    @NotNull
    public String getComponentName() {
        if ("ClipboardSynchronizer" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ClipboardSynchronizer", "getComponentName"));
        }
        return "ClipboardSynchronizer";
    }

    public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
        if (flavors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavors", "com/intellij/ide/ClipboardSynchronizer", "areDataFlavorsAvailable"));
        }
        try {
            return this.myClipboardHandler.areDataFlavorsAvailable(flavors);
        }
        catch (IllegalStateException e) {
            LOG.info((Throwable)e);
            return false;
        }
    }

    @Nullable
    public Transferable getContents() {
        try {
            return this.myClipboardHandler.getContents();
        }
        catch (IllegalStateException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    public void setContent(@NotNull Transferable content, @NotNull ClipboardOwner owner) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/ClipboardSynchronizer", "setContent"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/ide/ClipboardSynchronizer", "setContent"));
        }
        this.myClipboardHandler.setContent(content, owner);
    }

    public void resetContent() {
        this.myClipboardHandler.resetContent();
    }

    private static boolean areDataFlavorsAvailable(Transferable contents, DataFlavor ... flavors) {
        for (DataFlavor flavor : flavors) {
            if (!contents.isDataFlavorSupported(flavor)) continue;
            return true;
        }
        return false;
    }

    private static boolean areDataFlavorsAvailable(Collection<DataFlavor> contents, DataFlavor ... flavors) {
        for (DataFlavor flavor : flavors) {
            if (!contents.contains(flavor)) continue;
            return true;
        }
        return false;
    }

    private static class HeadlessClipboardHandler
    extends ClipboardHandler {
        private volatile Transferable myContent = null;

        private HeadlessClipboardHandler() {
        }

        @Override
        public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
            if (flavors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavors", "com/intellij/ide/ClipboardSynchronizer$HeadlessClipboardHandler", "areDataFlavorsAvailable"));
            }
            Transferable content = this.myContent;
            return content != null && ClipboardSynchronizer.areDataFlavorsAvailable(content, flavors);
        }

        @Override
        public Transferable getContents() throws IllegalStateException {
            return this.myContent;
        }

        @Override
        public void setContent(@NotNull Transferable content, @NotNull ClipboardOwner owner) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/ClipboardSynchronizer$HeadlessClipboardHandler", "setContent"));
            }
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/ide/ClipboardSynchronizer$HeadlessClipboardHandler", "setContent"));
            }
            this.myContent = content;
        }

        @Override
        public void resetContent() {
            this.myContent = null;
        }
    }

    private static class XWinClipboardHandler
    extends ClipboardHandler {
        private static final String DATA_TRANSFER_TIMEOUT_PROPERTY = "sun.awt.datatransfer.timeout";
        private static final String LONG_TIMEOUT = "2000";
        private static final String SHORT_TIMEOUT = "100";
        private static final FlavorTable FLAVOR_MAP = (FlavorTable)SystemFlavorMap.getDefaultFlavorMap();
        private volatile Transferable myCurrentContent = null;

        private XWinClipboardHandler() {
        }

        @Override
        public void init() {
            if (System.getProperty(DATA_TRANSFER_TIMEOUT_PROPERTY) == null) {
                System.setProperty(DATA_TRANSFER_TIMEOUT_PROPERTY, LONG_TIMEOUT);
            }
        }

        @Override
        public void dispose() {
            this.resetContent();
        }

        @Override
        public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
            if (flavors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavors", "com/intellij/ide/ClipboardSynchronizer$XWinClipboardHandler", "areDataFlavorsAvailable"));
            }
            Transferable currentContent = this.myCurrentContent;
            if (currentContent != null) {
                return ClipboardSynchronizer.areDataFlavorsAvailable(currentContent, flavors);
            }
            try {
                Collection<DataFlavor> contents = XWinClipboardHandler.checkContentsQuick();
                if (contents != null) {
                    return ClipboardSynchronizer.areDataFlavorsAvailable(contents, flavors);
                }
                return super.areDataFlavorsAvailable(flavors);
            }
            catch (NullPointerException e) {
                LOG.warn("Java bug #6322854", (Throwable)e);
                return false;
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Java bug #7173464", (Throwable)e);
                return false;
            }
        }

        @Override
        public Transferable getContents() throws IllegalStateException {
            Transferable currentContent = this.myCurrentContent;
            if (currentContent != null) {
                return currentContent;
            }
            try {
                Collection<DataFlavor> contents = XWinClipboardHandler.checkContentsQuick();
                if (contents != null && contents.isEmpty()) {
                    return null;
                }
                return super.getContents();
            }
            catch (NullPointerException e) {
                LOG.warn("Java bug #6322854", (Throwable)e);
                return null;
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Java bug #7173464", (Throwable)e);
                return null;
            }
        }

        @Override
        public void setContent(@NotNull Transferable content, @NotNull ClipboardOwner owner) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/ClipboardSynchronizer$XWinClipboardHandler", "setContent"));
            }
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/ide/ClipboardSynchronizer$XWinClipboardHandler", "setContent"));
            }
            this.myCurrentContent = content;
            super.setContent(content, owner);
        }

        @Override
        public void resetContent() {
            this.myCurrentContent = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private static Collection<DataFlavor> checkContentsQuick() {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Class<?> aClass = clipboard.getClass();
            if (!"sun.awt.X11.XClipboard".equals(aClass.getName())) {
                return null;
            }
            Method getClipboardFormats = ReflectionUtil.getDeclaredMethod(aClass, (String)"getClipboardFormats", (Class[])new Class[0]);
            if (getClipboardFormats == null) {
                return null;
            }
            String timeout = System.getProperty(DATA_TRANSFER_TIMEOUT_PROPERTY);
            System.setProperty(DATA_TRANSFER_TIMEOUT_PROPERTY, SHORT_TIMEOUT);
            try {
                Set<DataFlavor> set2;
                long[] formats = (long[])getClipboardFormats.invoke((Object)clipboard, new Object[0]);
                if (formats == null || formats.length == 0) {
                    Set<DataFlavor> set3 = Collections.emptySet();
                    return set3;
                }
                Set<DataFlavor> set4 = set2 = DataTransferer.getInstance().getFlavorsForFormats(formats, FLAVOR_MAP).keySet();
                return set4;
            }
            catch (IllegalAccessException formats) {
            }
            catch (IllegalArgumentException formats) {
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IllegalStateException) {
                    throw (IllegalStateException)cause;
                }
            }
            finally {
                System.setProperty(DATA_TRANSFER_TIMEOUT_PROPERTY, timeout);
            }
            return null;
        }
    }

    private static class MacClipboardHandler
    extends ClipboardHandler {
        private Pair<String, Transferable> myFullTransferable;

        private MacClipboardHandler() {
        }

        @Nullable
        private Transferable doGetContents() throws IllegalStateException {
            Transferable safe;
            if (Registry.is((String)"ide.mac.useNativeClipboard") && (safe = MacClipboardHandler.getContentsSafe()) != null) {
                return safe;
            }
            return super.getContents();
        }

        @Override
        public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
            if (flavors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavors", "com/intellij/ide/ClipboardSynchronizer$MacClipboardHandler", "areDataFlavorsAvailable"));
            }
            Transferable contents = this.getContents();
            return contents != null && ClipboardSynchronizer.areDataFlavorsAvailable(contents, flavors);
        }

        @Override
        public Transferable getContents() {
            Transferable transferable = this.doGetContents();
            if (transferable != null && this.myFullTransferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String stringData = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (stringData != null && stringData.equals(this.myFullTransferable.getFirst())) {
                        return (Transferable)this.myFullTransferable.getSecond();
                    }
                }
                catch (UnsupportedFlavorException e) {
                    LOG.info((Throwable)e);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
            this.myFullTransferable = null;
            return transferable;
        }

        @Override
        public void resetContent() {
            super.resetContent();
        }

        @Override
        public void setContent(@NotNull Transferable content, @NotNull ClipboardOwner owner) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/ClipboardSynchronizer$MacClipboardHandler", "setContent"));
            }
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/ide/ClipboardSynchronizer$MacClipboardHandler", "setContent"));
            }
            if (Registry.is((String)"ide.mac.useNativeClipboard") && content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String stringData = (String)content.getTransferData(DataFlavor.stringFlavor);
                    this.myFullTransferable = Pair.create((Object)stringData, (Object)content);
                    super.setContent(new StringSelection(stringData), owner);
                }
                catch (UnsupportedFlavorException e) {
                    LOG.info((Throwable)e);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            } else {
                this.myFullTransferable = null;
                super.setContent(content, owner);
            }
        }

        @Nullable
        private static Transferable getContentsSafe() {
            FutureResult result2 = new FutureResult();
            Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
                Transferable transferable = MacClipboardHandler.getClipboardContentNatively();
                if (transferable != null) {
                    result2.set((Object)transferable);
                }
            });
            try {
                return (Transferable)result2.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (Exception ignored) {
                return null;
            }
        }

        @Nullable
        private static Transferable getClipboardContentNatively() {
            String plainText = "public.utf8-plain-text";
            ID pasteboard = Foundation.invoke((String)"NSPasteboard", (String)"generalPasteboard", (Object[])new Object[0]);
            ID types = Foundation.invoke((ID)pasteboard, (String)"types", (Object[])new Object[0]);
            ID count = Foundation.invoke((ID)types, (String)"count", (Object[])new Object[0]);
            ID plainTextType = null;
            for (int i2 = 0; i2 < count.intValue(); ++i2) {
                ID each = Foundation.invoke((ID)types, (String)"objectAtIndex:", (Object[])new Object[]{i2});
                String eachType = Foundation.toStringViaUTF8((ID)each);
                if (!plainText.equals(eachType)) continue;
                plainTextType = each;
                break;
            }
            StringSelection result2 = null;
            if (plainTextType != null) {
                ID text = Foundation.invoke((ID)pasteboard, (String)"stringForType:", (Object[])new Object[]{plainTextType});
                String value = Foundation.toStringViaUTF8((ID)text);
                if (value == null) {
                    LOG.info(String.format("[Clipboard] Strange string value (null?) for type: %s", plainTextType));
                } else {
                    result2 = new StringSelection(value);
                }
            }
            return result2;
        }
    }

    private static class ClipboardHandler {
        private ClipboardHandler() {
        }

        public void init() {
        }

        public void dispose() {
        }

        public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
            if (flavors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavors", "com/intellij/ide/ClipboardSynchronizer$ClipboardHandler", "areDataFlavorsAvailable"));
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            for (DataFlavor flavor : flavors) {
                if (!clipboard.isDataFlavorAvailable(flavor)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public Transferable getContents() throws IllegalStateException {
            IllegalStateException last = null;
            for (int i2 = 0; i2 < 3; ++i2) {
                try {
                    return Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
                }
                catch (IllegalStateException e) {
                    TimeoutUtil.sleep((long)50L);
                    last = e;
                    continue;
                }
            }
            throw last;
        }

        public void setContent(@NotNull Transferable content, @NotNull ClipboardOwner owner) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/ClipboardSynchronizer$ClipboardHandler", "setContent"));
            }
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/ide/ClipboardSynchronizer$ClipboardHandler", "setContent"));
            }
            for (int i2 = 0; i2 < 3; ++i2) {
                try {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(content, owner);
                    break;
                }
                catch (IllegalStateException e) {
                    TimeoutUtil.sleep((long)50L);
                    continue;
                }
            }
        }

        public void resetContent() {
        }
    }
}

