/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.engine.ExpandableIndent;
import com.intellij.formatting.engine.IndentAdjuster;
import com.intellij.formatting.engine.State;
import com.intellij.formatting.engine.WrapBlocksState;
import com.intellij.openapi.editor.Document;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExpandChildrenIndentState
extends State {
    private final Document myDocument;
    private final WrapBlocksState myWrapState;
    private IndentAdjuster myIndentAdjuster;
    private MultiMap<ExpandableIndent, AbstractBlockWrapper> myExpandableIndents;
    private LeafBlockWrapper myCurrentBlock;
    private Iterator<ExpandableIndent> myIterator;
    private MultiMap<Alignment, LeafBlockWrapper> myBlocksToRealign = new MultiMap();

    public ExpandChildrenIndentState(Document document, WrapBlocksState state) {
        this.myDocument = document;
        this.myWrapState = state;
    }

    @Override
    public void prepare() {
        this.myExpandableIndents = this.myWrapState.getExpandableIndent();
        this.myIndentAdjuster = this.myWrapState.getIndentAdjuster();
        this.myIterator = this.myExpandableIndents.keySet().iterator();
    }

    @Override
    protected void doIteration() {
        if (!this.myIterator.hasNext()) {
            this.setDone(true);
            return;
        }
        ExpandableIndent indent = this.myIterator.next();
        Collection blocksToExpandIndent = this.myExpandableIndents.get((Object)indent);
        if (ExpandChildrenIndentState.shouldExpand(blocksToExpandIndent)) {
            for (AbstractBlockWrapper block : blocksToExpandIndent) {
                indent.setEnforceIndent(true);
                this.reindentNewLineChildren(block);
                indent.setEnforceIndent(false);
            }
        }
        this.restoreAlignments(this.myBlocksToRealign);
        this.myBlocksToRealign.clear();
    }

    private void restoreAlignments(MultiMap<Alignment, LeafBlockWrapper> blocks) {
        for (Alignment alignment : blocks.keySet()) {
            AlignmentImpl alignmentImpl = (AlignmentImpl)alignment;
            if (!alignmentImpl.isAllowBackwardShift()) continue;
            Set<LeafBlockWrapper> toRealign = alignmentImpl.getOffsetResponsibleBlocks();
            ExpandChildrenIndentState.arrangeSpaces(toRealign);
            LeafBlockWrapper rightMostBlock = ExpandChildrenIndentState.getRightMostBlock(toRealign);
            int maxSpacesBeforeBlock = rightMostBlock.getNumberOfSymbolsBeforeBlock().getTotalSpaces();
            int rightMostBlockLine = this.myDocument.getLineNumber(rightMostBlock.getStartOffset());
            for (LeafBlockWrapper block : toRealign) {
                int blockIndent;
                int delta;
                int currentBlockLine = this.myDocument.getLineNumber(block.getStartOffset());
                if (currentBlockLine == rightMostBlockLine || (delta = maxSpacesBeforeBlock - (blockIndent = block.getNumberOfSymbolsBeforeBlock().getTotalSpaces())) <= 0) continue;
                int newSpaces = block.getWhiteSpace().getTotalSpaces() + delta;
                ExpandChildrenIndentState.adjustSpacingToKeepAligned(block, newSpaces);
            }
        }
    }

    private static void adjustSpacingToKeepAligned(LeafBlockWrapper block, int newSpaces) {
        WhiteSpace space = block.getWhiteSpace();
        SpacingImpl property = block.getSpaceProperty();
        if (property == null) {
            return;
        }
        space.arrangeSpaces(new SpacingImpl(newSpaces, newSpaces, property.getMinLineFeeds(), property.isReadOnly(), property.isSafe(), property.shouldKeepLineFeeds(), property.getKeepBlankLines(), property.shouldKeepFirstColumn(), property.getPrefLineFeeds()));
    }

    private static LeafBlockWrapper getRightMostBlock(Collection<LeafBlockWrapper> toRealign) {
        int maxSpacesBeforeBlock = -1;
        LeafBlockWrapper rightMostBlock = null;
        for (LeafBlockWrapper block : toRealign) {
            int spaces = block.getNumberOfSymbolsBeforeBlock().getTotalSpaces();
            if (spaces <= maxSpacesBeforeBlock) continue;
            maxSpacesBeforeBlock = spaces;
            rightMostBlock = block;
        }
        return rightMostBlock;
    }

    private static void arrangeSpaces(Collection<LeafBlockWrapper> toRealign) {
        for (LeafBlockWrapper block : toRealign) {
            WhiteSpace whiteSpace = block.getWhiteSpace();
            SpacingImpl spacing = block.getSpaceProperty();
            whiteSpace.arrangeSpaces(spacing);
        }
    }

    private static boolean shouldExpand(Collection<AbstractBlockWrapper> blocksToExpandIndent) {
        int nextNewLineBlockIndent;
        AbstractBlockWrapper next;
        AbstractBlockWrapper last = null;
        for (AbstractBlockWrapper block : blocksToExpandIndent) {
            if (block.getWhiteSpace().containsLineFeeds()) {
                return true;
            }
            last = block;
        }
        return last != null && (next = ExpandChildrenIndentState.getNextBlock(last)) != null && next.getWhiteSpace().containsLineFeeds() && (nextNewLineBlockIndent = next.getNumberOfSymbolsBeforeBlock().getTotalSpaces()) >= ExpandChildrenIndentState.finMinNewLineIndent(blocksToExpandIndent);
    }

    private static int finMinNewLineIndent(@NotNull Collection<AbstractBlockWrapper> wrappers) {
        if (wrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappers", "com/intellij/formatting/engine/ExpandChildrenIndentState", "finMinNewLineIndent"));
        }
        int totalMinimum = Integer.MAX_VALUE;
        for (AbstractBlockWrapper wrapper : wrappers) {
            int minNewLineIndent = ExpandChildrenIndentState.findMinNewLineIndent(wrapper);
            if (minNewLineIndent >= totalMinimum) continue;
            totalMinimum = minNewLineIndent;
        }
        return totalMinimum;
    }

    private static int findMinNewLineIndent(@NotNull AbstractBlockWrapper block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/formatting/engine/ExpandChildrenIndentState", "findMinNewLineIndent"));
        }
        if (block instanceof LeafBlockWrapper && block.getWhiteSpace().containsLineFeeds()) {
            return block.getNumberOfSymbolsBeforeBlock().getTotalSpaces();
        }
        if (block instanceof CompositeBlockWrapper) {
            List<AbstractBlockWrapper> children2 = ((CompositeBlockWrapper)block).getChildren();
            int currentMin = Integer.MAX_VALUE;
            for (AbstractBlockWrapper child : children2) {
                int childIndent = ExpandChildrenIndentState.findMinNewLineIndent(child);
                if (childIndent >= currentMin) continue;
                currentMin = childIndent;
            }
            return currentMin;
        }
        return Integer.MAX_VALUE;
    }

    private static AbstractBlockWrapper getNextBlock(AbstractBlockWrapper block) {
        List<AbstractBlockWrapper> children2 = block.getParent().getChildren();
        int nextBlockIndex = children2.indexOf(block) + 1;
        if (nextBlockIndex < children2.size()) {
            return children2.get(nextBlockIndex);
        }
        return null;
    }

    private void reindentNewLineChildren(@NotNull AbstractBlockWrapper block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/formatting/engine/ExpandChildrenIndentState", "reindentNewLineChildren"));
        }
        if (block instanceof LeafBlockWrapper) {
            WhiteSpace space = block.getWhiteSpace();
            if (space.containsLineFeeds()) {
                this.myCurrentBlock = (LeafBlockWrapper)block;
                this.myIndentAdjuster.adjustIndent(this.myCurrentBlock);
                this.storeAlignmentsAfterCurrentBlock();
            }
        } else if (block instanceof CompositeBlockWrapper) {
            List<AbstractBlockWrapper> children2 = ((CompositeBlockWrapper)block).getChildren();
            for (AbstractBlockWrapper childBlock : children2) {
                this.reindentNewLineChildren(childBlock);
            }
        }
    }

    private void storeAlignmentsAfterCurrentBlock() {
        for (LeafBlockWrapper current = this.myCurrentBlock.getNextBlock(); current != null && !current.getWhiteSpace().containsLineFeeds(); current = current.getNextBlock()) {
            if (current.getAlignment() == null) continue;
            this.myBlocksToRealign.putValue((Object)current.getAlignment(), (Object)current);
        }
    }
}

