/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.BundleBase;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindProgressIndicator;
import com.intellij.find.FindResult;
import com.intellij.find.FindUtil;
import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.find.impl.FindDialog;
import com.intellij.find.impl.FindInProjectTask;
import com.intellij.find.impl.FindResultUsageInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewManager;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Function;
import com.intellij.util.PatternUtil;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindInProjectUtil {
    private static final int USAGES_PER_READ_ACTION = 100;

    private FindInProjectUtil() {
    }

    public static void setDirectoryName(@NotNull FindModel model, @NotNull DataContext dataContext) {
        Module module2;
        VirtualFile virtualFile;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindInProjectUtil", "setDirectoryName"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/find/impl/FindInProjectUtil", "setDirectoryName"));
        }
        PsiElement psiElement = null;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 != null && !DumbServiceImpl.getInstance(project2).isDumb()) {
            try {
                psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        String directoryName = null;
        if (psiElement instanceof PsiDirectory) {
            directoryName = ((PsiDirectory)psiElement).getVirtualFile().getPresentableUrl();
        }
        if (directoryName == null && psiElement instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories = ((PsiDirectoryContainer)psiElement).getDirectories();
            String string = directoryName = directories.length == 1 ? directories[0].getVirtualFile().getPresentableUrl() : null;
        }
        if (directoryName == null && (virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) != null && virtualFile.isDirectory()) {
            directoryName = virtualFile.getPresentableUrl();
        }
        if ((module2 = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext)) != null) {
            model.setModuleName(module2.getName());
        }
        if (module2 != null) {
            model.setModuleName(module2.getName());
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if ((model.getModuleName() == null || editor == null) && directoryName != null) {
            model.setDirectoryName(directoryName);
            model.setCustomScope(false);
        }
        model.setProjectScope(model.getDirectoryName() == null && model.getModuleName() == null && !model.isCustomScope());
    }

    @Nullable
    public static PsiDirectory getPsiDirectory(@NotNull FindModel findModel, @NotNull Project project2) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "getPsiDirectory"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil", "getPsiDirectory"));
        }
        VirtualFile directory = FindInProjectUtil.getDirectory(findModel);
        return directory == null ? null : PsiManager.getInstance((Project)project2).findDirectory(directory);
    }

    @Nullable
    public static VirtualFile getDirectory(@NotNull FindModel findModel) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "getDirectory"));
        }
        String directoryName = findModel.getDirectoryName();
        if (findModel.isProjectScope() || StringUtil.isEmpty((String)directoryName)) {
            return null;
        }
        String path = directoryName.replace(File.separatorChar, '/');
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (virtualFile == null || !virtualFile.isDirectory()) {
            virtualFile = null;
            for (LocalFileProvider provider : ((VirtualFileManagerEx)VirtualFileManager.getInstance()).getLocalFileProviders()) {
                VirtualFile file2 = provider.findLocalVirtualFileByPath(path);
                if (file2 == null || !file2.isDirectory()) continue;
                if (file2.getChildren().length > 0) {
                    virtualFile = file2;
                    break;
                }
                if (virtualFile != null) continue;
                virtualFile = file2;
            }
        }
        return virtualFile;
    }

    @NotNull
    public static Condition<String> createFileMaskCondition(@Nullable String filter) throws PatternSyntaxException {
        if (filter == null) {
            Condition condition = Conditions.alwaysTrue();
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil", "createFileMaskCondition"));
            }
            return condition;
        }
        String pattern = "";
        String negativePattern = "";
        List masks = StringUtil.split((String)filter, (String)",");
        for (String mask : masks) {
            if (StringUtil.startsWith((CharSequence)(mask = mask.trim()), (CharSequence)"!")) {
                negativePattern = negativePattern + (negativePattern.isEmpty() ? "" : "|") + "(" + PatternUtil.convertToRegex((String)mask.substring(1)) + ")";
                continue;
            }
            pattern = pattern + (pattern.isEmpty() ? "" : "|") + "(" + PatternUtil.convertToRegex((String)mask) + ")";
        }
        if (pattern.isEmpty()) {
            pattern = PatternUtil.convertToRegex((String)"*");
        }
        final String finalPattern = pattern;
        final String finalNegativePattern = negativePattern;
        Condition<String> condition = new Condition<String>(){
            final Pattern regExp;
            final Pattern negativeRegExp;
            {
                this.regExp = Pattern.compile(finalPattern, 2);
                this.negativeRegExp = StringUtil.isEmpty((String)finalNegativePattern) ? null : Pattern.compile(finalNegativePattern, 2);
            }

            public boolean value(String input) {
                return this.regExp.matcher(input).matches() && (this.negativeRegExp == null || !this.negativeRegExp.matcher(input).matches());
            }
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil", "createFileMaskCondition"));
        }
        return condition;
    }

    @Nullable
    public static Pattern createFileMaskRegExp(@Nullable String filter) {
        if (filter == null) {
            return null;
        }
        List strings = StringUtil.split((String)filter, (String)",");
        String pattern = strings.size() == 1 ? PatternUtil.convertToRegex((String)filter.trim()) : StringUtil.join((Collection)strings, s -> "(" + PatternUtil.convertToRegex((String)s.trim()) + ")", (String)"|");
        return Pattern.compile(pattern, 2);
    }

    public static void findUsages(@NotNull FindModel findModel, @Nullable PsiDirectory psiDirectory, @NotNull Project project2, @NotNull Processor<UsageInfo> consumer, @NotNull FindUsagesProcessPresentation processPresentation) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        if (processPresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processPresentation", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        FindInProjectUtil.findUsages(findModel, project2, consumer, processPresentation);
    }

    public static void findUsages(@NotNull FindModel findModel, @NotNull Project project2, @NotNull Processor<UsageInfo> consumer, @NotNull FindUsagesProcessPresentation processPresentation) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        if (processPresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processPresentation", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        FindInProjectUtil.findUsages(findModel, project2, consumer, processPresentation, Collections.emptySet());
    }

    public static void findUsages(@NotNull FindModel findModel, @NotNull Project project2, @NotNull Processor<UsageInfo> consumer, @NotNull FindUsagesProcessPresentation processPresentation, @NotNull Set<VirtualFile> filesToStart) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        if (processPresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processPresentation", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        if (filesToStart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToStart", "com/intellij/find/impl/FindInProjectUtil", "findUsages"));
        }
        new FindInProjectTask(findModel, project2, filesToStart).findUsages(consumer, processPresentation);
    }

    static int processUsagesInFile(@NotNull PsiFile psiFile, @NotNull FindModel findModel, @NotNull Processor<UsageInfo> consumer) {
        int found;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/find/impl/FindInProjectUtil", "processUsagesInFile"));
        }
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "processUsagesInFile"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/find/impl/FindInProjectUtil", "processUsagesInFile"));
        }
        if (findModel.getStringToFind().isEmpty()) {
            if (!((Boolean)ApplicationManager.getApplication().runReadAction(() -> {
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/find/impl/FindInProjectUtil", "lambda$processUsagesInFile$1"));
                }
                if (psiFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/find/impl/FindInProjectUtil", "lambda$processUsagesInFile$1"));
                }
                return consumer.process((Object)new UsageInfo(psiFile));
            })).booleanValue()) {
                throw new ProcessCanceledException();
            }
            return 1;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return 0;
        }
        if (virtualFile.getFileType().isBinary()) {
            return 0;
        }
        Document document = (Document)ApplicationManager.getApplication().runReadAction(() -> virtualFile.isValid() ? FileDocumentManager.getInstance().getDocument(virtualFile) : null);
        if (document == null) {
            return 0;
        }
        int[] offset = new int[]{0};
        int count = 0;
        ProgressIndicator indicator = ProgressWrapper.unwrap(ProgressManager.getInstance().getProgressIndicator());
        TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.getFrom(indicator);
        do {
            tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
            found = (Integer)ApplicationManager.getApplication().runReadAction(() -> {
                if (psiFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/find/impl/FindInProjectUtil", "lambda$processUsagesInFile$3"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/find/impl/FindInProjectUtil", "lambda$processUsagesInFile$3"));
                }
                if (findModel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "lambda$processUsagesInFile$3"));
                }
                if (!psiFile.isValid()) {
                    return 0;
                }
                return FindInProjectUtil.addToUsages(document, consumer, findModel, psiFile, offset, 100);
            });
            count += found;
        } while (found != 0);
        return count;
    }

    private static int addToUsages(@NotNull Document document, @NotNull Processor<UsageInfo> consumer, @NotNull FindModel findModel, @NotNull PsiFile psiFile, @NotNull int[] offsetRef, int maxUsages) {
        FindResult result2;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/find/impl/FindInProjectUtil", "addToUsages"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/find/impl/FindInProjectUtil", "addToUsages"));
        }
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "addToUsages"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/find/impl/FindInProjectUtil", "addToUsages"));
        }
        if (offsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offsetRef", "com/intellij/find/impl/FindInProjectUtil", "addToUsages"));
        }
        int count = 0;
        CharSequence text = document.getCharsSequence();
        int textLength = document.getTextLength();
        int offset = offsetRef[0];
        Project project2 = psiFile.getProject();
        FindManager findManager = FindManager.getInstance((Project)project2);
        while (offset < textLength && (result2 = findManager.findString(text, offset, findModel, psiFile.getVirtualFile())).isStringFound()) {
            TextRange range;
            SearchScope customScope;
            int prevOffset = offset;
            if (prevOffset == (offset = result2.getEndOffset())) {
                ++offset;
            }
            if ((customScope = findModel.getCustomScope()) instanceof LocalSearchScope && !((LocalSearchScope)customScope).containsRange(psiFile, range = new TextRange(result2.getStartOffset(), result2.getEndOffset()))) continue;
            FindResultUsageInfo info = new FindResultUsageInfo(findManager, psiFile, prevOffset, findModel, result2);
            if (!consumer.process((Object)info)) {
                throw new ProcessCanceledException();
            }
            if (maxUsages <= 0 || ++count < maxUsages) continue;
            break;
        }
        offsetRef[0] = offset;
        return count;
    }

    @NotNull
    private static String getTitleForScope(@NotNull FindModel findModel) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "getTitleForScope"));
        }
        String scopeName = findModel.isProjectScope() ? FindBundle.message("find.scope.project.title", new Object[0]) : (findModel.getModuleName() != null ? FindBundle.message("find.scope.module.title", findModel.getModuleName()) : (findModel.getCustomScopeName() != null ? findModel.getCustomScopeName() : FindBundle.message("find.scope.directory.title", findModel.getDirectoryName())));
        String result2 = scopeName;
        if (findModel.getFileFilter() != null) {
            result2 = result2 + " " + FindBundle.message("find.scope.files.with.mask", findModel.getFileFilter());
        }
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil", "getTitleForScope"));
        }
        return string;
    }

    @NotNull
    public static UsageViewPresentation setupViewPresentation(boolean toOpenInNewTab, @NotNull FindModel findModel) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "setupViewPresentation"));
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        String scope = FindInProjectUtil.getTitleForScope(findModel);
        String stringToFind = findModel.getStringToFind();
        presentation.setScopeText(scope);
        if (stringToFind.isEmpty()) {
            presentation.setTabText("Files");
            presentation.setToolwindowTitle(BundleBase.format((String)"Files in {0}", (Object[])new Object[]{scope}));
            presentation.setUsagesString("files");
        } else {
            FindModel.SearchContext searchContext = findModel.getSearchContext();
            String contextText = "";
            if (searchContext != FindModel.SearchContext.ANY) {
                contextText = FindBundle.message("find.context.presentation.scope.label", FindDialog.getPresentableName(searchContext));
            }
            presentation.setTabText(FindBundle.message("find.usage.view.tab.text", stringToFind, contextText));
            presentation.setToolwindowTitle(FindBundle.message("find.usage.view.toolwindow.title", stringToFind, scope, contextText));
            presentation.setUsagesString(FindBundle.message("find.usage.view.usages.text", stringToFind));
            presentation.setUsagesWord(FindBundle.message("occurrence", new Object[0]));
            presentation.setCodeUsagesString(FindBundle.message("found.occurrences", new Object[0]));
            presentation.setContextText(contextText);
        }
        presentation.setOpenInNewTab(toOpenInNewTab);
        presentation.setCodeUsages(false);
        presentation.setUsageTypeFilteringAvailable(true);
        UsageViewPresentation usageViewPresentation = presentation;
        if (usageViewPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil", "setupViewPresentation"));
        }
        return usageViewPresentation;
    }

    @NotNull
    public static FindUsagesProcessPresentation setupProcessPresentation(@NotNull Project project2, boolean showPanelIfOnlyOneUsage, @NotNull UsageViewPresentation presentation) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil", "setupProcessPresentation"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/find/impl/FindInProjectUtil", "setupProcessPresentation"));
        }
        FindUsagesProcessPresentation processPresentation = new FindUsagesProcessPresentation(presentation);
        processPresentation.setShowNotFoundMessage(true);
        processPresentation.setShowPanelIfOnlyOneUsage(showPanelIfOnlyOneUsage);
        processPresentation.setProgressIndicatorFactory(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil", "lambda$setupProcessPresentation$4"));
            }
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/find/impl/FindInProjectUtil", "lambda$setupProcessPresentation$4"));
            }
            return new FindProgressIndicator(project2, presentation.getScopeText());
        });
        FindUsagesProcessPresentation findUsagesProcessPresentation = processPresentation;
        if (findUsagesProcessPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil", "setupProcessPresentation"));
        }
        return findUsagesProcessPresentation;
    }

    private static List<PsiElement> getTopLevelRegExpChars(String regExpText, Project project2) {
        PsiElement[] children2;
        PsiFile file2 = PsiFileFactory.getInstance((Project)project2).createFileFromText("A.regexp", regExpText);
        List<PsiElement> result2 = null;
        for (PsiElement child : children2 = file2.getChildren()) {
            PsiElement[] grandChildren = child.getChildren();
            if (grandChildren.length != 1) {
                return Collections.emptyList();
            }
            for (PsiElement grandGrandChild : grandChildren[0].getChildren()) {
                if (result2 == null) {
                    result2 = new ArrayList<PsiElement>();
                }
                result2.add(grandGrandChild);
            }
        }
        return result2 != null ? result2 : Collections.emptyList();
    }

    @NotNull
    public static String buildStringToFindForIndicesFromRegExp(final @NotNull String stringToFind, final @NotNull Project project2) {
        if (stringToFind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringToFind", "com/intellij/find/impl/FindInProjectUtil", "buildStringToFindForIndicesFromRegExp"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil", "buildStringToFindForIndicesFromRegExp"));
        }
        if (!Registry.is((String)"idea.regexp.search.uses.indices")) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil", "buildStringToFindForIndicesFromRegExp"));
            }
            return "";
        }
        String string = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                final List topLevelRegExpChars = FindInProjectUtil.getTopLevelRegExpChars("a", project2);
                if (topLevelRegExpChars.size() != 1) {
                    return "";
                }
                return StringUtil.join((Collection)FindInProjectUtil.getTopLevelRegExpChars(stringToFind, project2), (Function)new Function<PsiElement, String>(){
                    final Class regExpCharPsiClass;
                    {
                        this.regExpCharPsiClass = ((PsiElement)topLevelRegExpChars.get(0)).getClass();
                    }

                    public String fun(PsiElement element) {
                        String text;
                        if (this.regExpCharPsiClass.isInstance(element) && !(text = element.getText()).startsWith("\\")) {
                            return text;
                        }
                        return " ";
                    }
                }, (String)"");
            }
        });
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil", "buildStringToFindForIndicesFromRegExp"));
        }
        return string;
    }

    public static void initStringToFindFromDataContext(FindModel findModel, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/find/impl/FindInProjectUtil", "initStringToFindFromDataContext"));
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        FindUtil.initStringToFindWithSelection(findModel, editor);
        if (editor == null || !editor.getSelectionModel().hasSelection()) {
            FindUtil.useFindStringFromFindInFileModel(findModel, (Editor)CommonDataKeys.EDITOR_EVEN_IF_INACTIVE.getData(dataContext));
        }
    }

    private static void addSourceDirectoriesFromLibraries(@NotNull Project project2, @NotNull VirtualFile directory, @NotNull Collection<VirtualFile> outSourceRoots) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil", "addSourceDirectoriesFromLibraries"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/find/impl/FindInProjectUtil", "addSourceDirectoriesFromLibraries"));
        }
        if (outSourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outSourceRoots", "com/intellij/find/impl/FindInProjectUtil", "addSourceDirectoriesFromLibraries"));
        }
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project2);
        if (!index.isInLibraryClasses(directory)) {
            return;
        }
        VirtualFile classRoot = index.getClassRootForFile(directory);
        if (classRoot == null) {
            return;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)directory, (VirtualFile)classRoot);
        if (relativePath == null) {
            return;
        }
        THashSet otherSourceRoots = new THashSet();
        block0: for (OrderEntry entry : index.getOrderEntriesForFile(directory)) {
            if (entry instanceof LibraryOrderEntry) {
                String[] sourceUrls;
                Library library = ((LibraryOrderEntry)entry).getLibrary();
                if (library == null) continue;
                for (String sourceUrl : sourceUrls = library.getUrls(OrderRootType.SOURCES)) {
                    if (!VfsUtilCore.isEqualOrAncestor((String)sourceUrl, (String)directory.getUrl())) continue;
                    otherSourceRoots.clear();
                    break block0;
                }
            }
            for (VirtualFile sourceRoot : entry.getFiles(OrderRootType.SOURCES)) {
                VirtualFile sourceFile = sourceRoot.findFileByRelativePath(relativePath);
                if (sourceFile == null) continue;
                otherSourceRoots.add(sourceFile);
            }
        }
        outSourceRoots.addAll((Collection<VirtualFile>)otherSourceRoots);
    }

    @NotNull
    static SearchScope getScopeFromModel(@NotNull Project project2, @NotNull FindModel findModel) {
        Module module2;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil", "getScopeFromModel"));
        }
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil", "getScopeFromModel"));
        }
        SearchScope customScope = findModel.getCustomScope();
        VirtualFile directory = FindInProjectUtil.getDirectory(findModel);
        Module module3 = module2 = findModel.getModuleName() == null ? null : ModuleManager.getInstance((Project)project2).findModuleByName(findModel.getModuleName());
        Object object = findModel.isCustomScope() && customScope != null ? customScope.intersectWith((SearchScope)GlobalSearchScope.allScope((Project)project2)) : (directory != null ? FindInProjectUtil.forDirectory(project2, findModel.isWithSubdirectories(), directory) : (module2 != null ? module2.getModuleContentScope() : (findModel.isProjectScope() ? ProjectScope.getContentScope((Project)project2) : GlobalSearchScope.allScope((Project)project2))));
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil", "getScopeFromModel"));
        }
        return object;
    }

    @NotNull
    private static GlobalSearchScope forDirectory(@NotNull Project project2, boolean withSubdirectories, @NotNull VirtualFile directory) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil", "forDirectory"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/find/impl/FindInProjectUtil", "forDirectory"));
        }
        LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
        result2.add(directory);
        FindInProjectUtil.addSourceDirectoriesFromLibraries(project2, directory, result2);
        VirtualFile[] array = result2.toArray(new VirtualFile[result2.size()]);
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoriesScope((Project)project2, (boolean)withSubdirectories, (VirtualFile[])array);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil", "forDirectory"));
        }
        return globalSearchScope;
    }

    public static class StringUsageTarget
    implements ConfigurableUsageTarget,
    ItemPresentation,
    TypeSafeDataProvider {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final FindModel myFindModel;

        public StringUsageTarget(@NotNull Project project2, @NotNull FindModel findModel) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget", "<init>"));
            }
            if (findModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget", "<init>"));
            }
            this.myProject = project2;
            this.myFindModel = findModel;
        }

        @NotNull
        public String getPresentableText() {
            UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(false, this.myFindModel);
            String string = presentation.getToolwindowTitle();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget", "getPresentableText"));
            }
            return string;
        }

        @NotNull
        public String getLongDescriptiveName() {
            String string = this.getPresentableText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget", "getLongDescriptiveName"));
            }
            return string;
        }

        public String getLocationString() {
            return this.myFindModel + "!!";
        }

        public Icon getIcon(boolean open2) {
            return AllIcons.Actions.Menu_find;
        }

        public void findUsages() {
            FindInProjectManager.getInstance(this.myProject).startFindInProject(this.myFindModel);
        }

        public void findUsagesInEditor(@NotNull FileEditor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget", "findUsagesInEditor"));
            }
        }

        public void highlightUsages(@NotNull PsiFile file2, @NotNull Editor editor, boolean clearHighlights) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget", "highlightUsages"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/impl/FindInProjectUtil$StringUsageTarget", "highlightUsages"));
            }
        }

        public boolean isValid() {
            return true;
        }

        public boolean isReadOnly() {
            return true;
        }

        @Nullable
        public VirtualFile[] getFiles() {
            return null;
        }

        public void update() {
        }

        public String getName() {
            return this.myFindModel.getStringToFind().isEmpty() ? this.myFindModel.getFileFilter() : this.myFindModel.getStringToFind();
        }

        public ItemPresentation getPresentation() {
            return this;
        }

        public void navigate(boolean requestFocus) {
            throw new UnsupportedOperationException();
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public void showSettings() {
            Content selectedContent = UsageViewManager.getInstance((Project)this.myProject).getSelectedContent(true);
            JComponent component = selectedContent == null ? null : selectedContent.getComponent();
            FindInProjectManager findInProjectManager = FindInProjectManager.getInstance(this.myProject);
            findInProjectManager.findInProject(DataManager.getInstance().getDataContext((Component)component));
        }

        public KeyboardShortcut getShortcut() {
            return ActionManager.getInstance().getKeyboardShortcut("FindInPath");
        }

        public void calcData(DataKey key2, DataSink sink) {
            if (UsageView.USAGE_SCOPE.equals(key2)) {
                SearchScope scope = FindInProjectUtil.getScopeFromModel(this.myProject, this.myFindModel);
                sink.put(UsageView.USAGE_SCOPE, (Object)scope);
            }
        }
    }
}

