/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.states;

import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.SMTestsRunnerBundle;
import com.intellij.execution.testframework.sm.runner.states.AbstractState;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import org.jetbrains.annotations.NonNls;

public abstract class SuiteFinishedState
extends AbstractState {
    @NonNls
    private static final String EMPTY_SUITE_TEXT = SMTestsRunnerBundle.message("sm.test.runner.states.suite.is.empty", new Object[0]);
    public static SuiteFinishedState PASSED_SUITE = new SuiteFinishedState(){

        public TestStateInfo.Magnitude getMagnitude() {
            return TestStateInfo.Magnitude.PASSED_INDEX;
        }

        public String toString() {
            return "SUITE PASSED";
        }
    };
    public static SuiteFinishedState FAILED_SUITE = new SuiteFinishedState(){

        @Override
        public boolean isDefect() {
            return true;
        }

        public TestStateInfo.Magnitude getMagnitude() {
            return TestStateInfo.Magnitude.FAILED_INDEX;
        }

        public String toString() {
            return "FAILED SUITE";
        }
    };
    public static SuiteFinishedState WITH_IGNORED_TESTS_SUITE = new SuiteFinishedState(){

        @Override
        public boolean isDefect() {
            return true;
        }

        public TestStateInfo.Magnitude getMagnitude() {
            return TestStateInfo.Magnitude.IGNORED_INDEX;
        }

        public String toString() {
            return "WITH IGNORED TESTS SUITE";
        }
    };
    public static SuiteFinishedState ERROR_SUITE = new SuiteFinishedState(){

        @Override
        public boolean isDefect() {
            return true;
        }

        public TestStateInfo.Magnitude getMagnitude() {
            return TestStateInfo.Magnitude.ERROR_INDEX;
        }

        public String toString() {
            return "ERROR SUITE";
        }
    };
    public static SuiteFinishedState EMPTY_LEAF_SUITE = new EmptySuite(){

        @Override
        public void printOn(Printer printer) {
            super.printOn(printer);
            String msg = EMPTY_SUITE_TEXT + "\n";
            printer.print(msg, ConsoleViewContentType.SYSTEM_OUTPUT);
        }
    };
    public static SuiteFinishedState EMPTY_SUITE = new EmptySuite();
    public static SuiteFinishedState TESTS_REPORTER_NOT_ATTACHED = new SuiteFinishedState(){

        @Override
        public boolean isDefect() {
            return false;
        }

        public TestStateInfo.Magnitude getMagnitude() {
            return TestStateInfo.Magnitude.COMPLETE_INDEX;
        }

        public String toString() {
            return "TESTS REPORTER NOT ATTACHED";
        }
    };

    private SuiteFinishedState() {
    }

    public boolean isInProgress() {
        return false;
    }

    public boolean isDefect() {
        return false;
    }

    public boolean wasLaunched() {
        return true;
    }

    public boolean isFinal() {
        return true;
    }

    public boolean wasTerminated() {
        return false;
    }

    private static class EmptySuite
    extends SuiteFinishedState {
        private EmptySuite() {
        }

        @Override
        public boolean isDefect() {
            return false;
        }

        public TestStateInfo.Magnitude getMagnitude() {
            return TestStateInfo.Magnitude.COMPLETE_INDEX;
        }

        public String toString() {
            return "EMPTY FINISHED SUITE";
        }
    }
}

