/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunTab;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContentBuilder
extends RunTab {
    private static final String JAVA_RUNNER = "JavaRunner";
    private final List<AnAction> myRunnerActions;
    private final ExecutionResult myExecutionResult;

    public RunContentBuilder(@NotNull ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        if (executionResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionResult", "com/intellij/execution/runners/RunContentBuilder", "<init>"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/RunContentBuilder", "<init>"));
        }
        super(environment, RunContentBuilder.getRunnerType(executionResult.getExecutionConsole()));
        this.myRunnerActions = new SmartList();
        this.myExecutionResult = executionResult;
        this.myUi.getOptions().setMoveToGridActionEnabled(false).setMinimizeActionEnabled(false);
    }

    @NotNull
    public static ExecutionEnvironment fix(@NotNull ExecutionEnvironment environment, @Nullable ProgramRunner runner) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/RunContentBuilder", "fix"));
        }
        if (runner == null || runner.equals(environment.getRunner())) {
            ExecutionEnvironment executionEnvironment = environment;
            if (executionEnvironment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/RunContentBuilder", "fix"));
            }
            return executionEnvironment;
        }
        ExecutionEnvironment executionEnvironment = new ExecutionEnvironmentBuilder(environment).runner(runner).build();
        if (executionEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/RunContentBuilder", "fix"));
        }
        return executionEnvironment;
    }

    public void addAction(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/execution/runners/RunContentBuilder", "addAction"));
        }
        this.myRunnerActions.add(action);
    }

    @NotNull
    private RunContentDescriptor createDescriptor() {
        RunProfile profile = this.myEnvironment.getRunProfile();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            RunContentDescriptor runContentDescriptor = new RunContentDescriptor(profile, this.myExecutionResult, this.myUi);
            if (runContentDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/RunContentBuilder", "createDescriptor"));
            }
            return runContentDescriptor;
        }
        ExecutionConsole console = this.myExecutionResult.getExecutionConsole();
        RunContentDescriptor contentDescriptor = new RunContentDescriptor(profile, this.myExecutionResult, this.myUi);
        if (console != null) {
            if (console instanceof ExecutionConsoleEx) {
                ((ExecutionConsoleEx)console).buildUi(this.myUi);
            } else {
                RunContentBuilder.buildConsoleUiDefault(this.myUi, console);
            }
            this.initLogConsoles(profile, contentDescriptor, console);
        }
        this.myUi.getOptions().setLeftToolbar(this.createActionToolbar(contentDescriptor), "RunnerToolbar");
        if (profile instanceof RunConfigurationBase && console instanceof ObservableConsoleView && !ApplicationManager.getApplication().isUnitTestMode()) {
            ((ObservableConsoleView)console).addChangeListener((ObservableConsoleView.ChangeListener)new ConsoleToFrontListener((RunConfigurationBase)profile, this.myProject, this.myEnvironment.getExecutor(), contentDescriptor, this.myUi), (Disposable)this);
        }
        RunContentDescriptor runContentDescriptor = contentDescriptor;
        if (runContentDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/RunContentBuilder", "createDescriptor"));
        }
        return runContentDescriptor;
    }

    @NotNull
    private static String getRunnerType(@Nullable ExecutionConsole console) {
        String id;
        String runnerType = JAVA_RUNNER;
        if (console instanceof ExecutionConsoleEx && (id = ((ExecutionConsoleEx)console).getExecutionConsoleId()) != null) {
            String string = "JavaRunner." + id;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/RunContentBuilder", "getRunnerType"));
            }
            return string;
        }
        String string = runnerType;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/RunContentBuilder", "getRunnerType"));
        }
        return string;
    }

    public static void buildConsoleUiDefault(RunnerLayoutUi ui, ExecutionConsole console) {
        Content consoleContent = ui.createContent("ConsoleContent", console.getComponent(), "Console", AllIcons.Debugger.Console, console.getPreferredFocusableComponent());
        consoleContent.setCloseable(false);
        RunContentBuilder.addAdditionalConsoleEditorActions(console, consoleContent);
        ui.addContent(consoleContent, 0, PlaceInGrid.bottom, false);
    }

    public static void addAdditionalConsoleEditorActions(ExecutionConsole console, Content consoleContent) {
        DefaultActionGroup consoleActions = new DefaultActionGroup();
        if (console instanceof ConsoleView) {
            for (AnAction action : ((ConsoleView)console).createConsoleActions()) {
                consoleActions.add(action);
            }
        }
        consoleContent.setActions((ActionGroup)consoleActions, "RunnerToolbar", console.getComponent());
    }

    @NotNull
    private ActionGroup createActionToolbar(@NotNull RunContentDescriptor contentDescriptor) {
        if (contentDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentDescriptor", "com/intellij/execution/runners/RunContentBuilder", "createActionToolbar"));
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(ActionManager.getInstance().getAction("Rerun"));
        AnAction[] actions = contentDescriptor.getRestartActions();
        actionGroup.addAll(actions);
        if (actions.length > 0) {
            actionGroup.addSeparator();
        }
        actionGroup.add(ActionManager.getInstance().getAction("Stop"));
        if (this.myExecutionResult instanceof DefaultExecutionResult) {
            actionGroup.addAll(((DefaultExecutionResult)this.myExecutionResult).getAdditionalStopActions());
        }
        actionGroup.addAll(this.myExecutionResult.getActions());
        for (AnAction anAction : this.myRunnerActions) {
            if (anAction != null) {
                actionGroup.add(anAction);
                continue;
            }
            actionGroup.addSeparator();
        }
        actionGroup.addSeparator();
        actionGroup.add(this.myUi.getOptions().getLayoutActions());
        actionGroup.addSeparator();
        actionGroup.add(PinToolwindowTabAction.getPinAction());
        actionGroup.add((AnAction)new CloseAction(this.myEnvironment.getExecutor(), contentDescriptor, this.myProject));
        String helpId = contentDescriptor.getHelpId();
        actionGroup.add((AnAction)new ContextHelpAction(helpId != null ? helpId : this.myEnvironment.getExecutor().getHelpId()));
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/RunContentBuilder", "createActionToolbar"));
        }
        return defaultActionGroup;
    }

    public RunContentDescriptor showRunContent(@Nullable RunContentDescriptor reuseContent) {
        RunContentDescriptor descriptor = this.createDescriptor();
        Disposer.register((Disposable)descriptor, (Disposable)this);
        Disposer.register((Disposable)this.myProject, (Disposable)descriptor);
        RunContentManagerImpl.copyContentAndBehavior(descriptor, reuseContent);
        this.myRunContentDescriptor = descriptor;
        return descriptor;
    }

    public static class ConsoleToFrontListener
    implements ObservableConsoleView.ChangeListener {
        @NotNull
        private final RunConfigurationBase myRunConfigurationBase;
        @NotNull
        private final Project myProject;
        @NotNull
        private final Executor myExecutor;
        @NotNull
        private final RunContentDescriptor myRunContentDescriptor;
        @NotNull
        private final RunnerLayoutUi myUi;

        public ConsoleToFrontListener(@NotNull RunConfigurationBase runConfigurationBase, @NotNull Project project2, @NotNull Executor executor, @NotNull RunContentDescriptor runContentDescriptor, @NotNull RunnerLayoutUi ui) {
            if (runConfigurationBase == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfigurationBase", "com/intellij/execution/runners/RunContentBuilder$ConsoleToFrontListener", "<init>"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/runners/RunContentBuilder$ConsoleToFrontListener", "<init>"));
            }
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/runners/RunContentBuilder$ConsoleToFrontListener", "<init>"));
            }
            if (runContentDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runContentDescriptor", "com/intellij/execution/runners/RunContentBuilder$ConsoleToFrontListener", "<init>"));
            }
            if (ui == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/execution/runners/RunContentBuilder$ConsoleToFrontListener", "<init>"));
            }
            this.myRunConfigurationBase = runConfigurationBase;
            this.myProject = project2;
            this.myExecutor = executor;
            this.myRunContentDescriptor = runContentDescriptor;
            this.myUi = ui;
        }

        public void contentAdded(Collection<ConsoleViewContentType> types) {
            if (this.myProject.isDisposed() || this.myUi.isDisposed()) {
                return;
            }
            for (ConsoleViewContentType type : types) {
                if ((type != ConsoleViewContentType.NORMAL_OUTPUT || !this.myRunConfigurationBase.isShowConsoleOnStdOut()) && (type != ConsoleViewContentType.ERROR_OUTPUT || !this.myRunConfigurationBase.isShowConsoleOnStdErr())) continue;
                ExecutionManager.getInstance((Project)this.myProject).getContentManager().toFrontRunContent(this.myExecutor, this.myRunContentDescriptor);
                this.myUi.selectAndFocus(this.myUi.findContent("ConsoleContent"), false, false);
                return;
            }
        }
    }
}

