/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class MyDiffContainer
extends JBLayeredPane
implements Disposable {
    private final AnimatedIcon myIcon;
    private final JComponent myContent;
    private final JComponent myLoadingPanel;
    private final JLabel myJLabel;

    MyDiffContainer(@NotNull JComponent content, @NotNull String text) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/impl/MyDiffContainer", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/impl/MyDiffContainer", "<init>"));
        }
        this.myIcon = new AsyncProcessIcon(((Object)((Object)this)).getClass().getName());
        this.setLayout((LayoutManager)((Object)new MyOverlayLayout()));
        this.myContent = content;
        this.myLoadingPanel = new JPanel((LayoutManager)((Object)new MyPanelLayout()));
        this.myLoadingPanel.setOpaque(false);
        this.myLoadingPanel.add((Component)this.myIcon);
        Disposer.register((Disposable)this, (Disposable)this.myIcon);
        this.myJLabel = new JLabel(text);
        this.myJLabel.setForeground(UIUtil.getInactiveTextColor());
        this.myLoadingPanel.add(this.myJLabel);
        this.add(this.myContent);
        this.add(this.myLoadingPanel, JLayeredPane.POPUP_LAYER);
        this.finishUpdating();
    }

    public void dispose() {
    }

    void startUpdating() {
        this.myLoadingPanel.setVisible(true);
        this.myIcon.resume();
    }

    void finishUpdating() {
        this.myIcon.suspend();
        this.myLoadingPanel.setVisible(false);
    }

    private class MyPanelLayout
    extends AbstractLayoutManager {
        private MyPanelLayout() {
        }

        public void layoutContainer(Container parent) {
            Dimension size = MyDiffContainer.this.myIcon.getPreferredSize();
            Dimension preferredSize = MyDiffContainer.this.myJLabel.getPreferredSize();
            int width = MyDiffContainer.this.getWidth();
            int offset = width - size.width - 15 - preferredSize.width;
            MyDiffContainer.this.myIcon.setBounds(offset, 0, size.width, size.height);
            MyDiffContainer.this.myJLabel.setBounds(offset + size.width + 3, 0, preferredSize.width, size.height);
        }

        public Dimension preferredLayoutSize(Container parent) {
            return MyDiffContainer.this.myContent.getPreferredSize();
        }
    }

    private class MyOverlayLayout
    extends AbstractLayoutManager {
        private MyOverlayLayout() {
        }

        public void layoutContainer(Container parent) {
            for (int i2 = 0; i2 < MyDiffContainer.this.getComponentCount(); ++i2) {
                MyDiffContainer.this.getComponent(i2).setBounds(0, 0, MyDiffContainer.this.getWidth(), MyDiffContainer.this.getHeight());
            }
        }

        public Dimension preferredLayoutSize(Container parent) {
            return MyDiffContainer.this.myContent.getPreferredSize();
        }
    }
}

