/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.RunIdeConsoleAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeConsoleRootType
extends ConsoleRootType {
    IdeConsoleRootType() {
        super("ide", "IDE Scripting");
    }

    @NotNull
    public static IdeConsoleRootType getInstance() {
        IdeConsoleRootType ideConsoleRootType = IdeConsoleRootType.findByClass(IdeConsoleRootType.class);
        if (ideConsoleRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/IdeConsoleRootType", "getInstance"));
        }
        return ideConsoleRootType;
    }

    @Override
    @Nullable
    public Icon substituteIcon(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/IdeConsoleRootType", "substituteIcon"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/IdeConsoleRootType", "substituteIcon"));
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file2.getName());
        if (fileType == UnknownFileType.INSTANCE || fileType == PlainTextFileType.INSTANCE) {
            return AllIcons.Debugger.ToolConsole;
        }
        Icon icon = fileType.getIcon();
        Icon subscript = ((ScalableIcon)AllIcons.Debugger.ToolConsole).scale(0.5f);
        LayeredIcon icons = new LayeredIcon(2);
        icons.setIcon(icon, 0);
        icons.setIcon(subscript, 1, 8, 8);
        return icons;
    }

    @Override
    public void fileOpened(@NotNull VirtualFile file2, @NotNull FileEditorManager source) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/IdeConsoleRootType", "fileOpened"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/execution/console/IdeConsoleRootType", "fileOpened"));
        }
        RunIdeConsoleAction.configureConsole(file2, source);
    }
}

