/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsMultiRootBranchConfig;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsBranchPopup<Repo extends Repository> {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final AbstractRepositoryManager<Repo> myRepositoryManager;
    @NotNull
    protected final DvcsSyncSettings myVcsSettings;
    @NotNull
    protected final AbstractVcs myVcs;
    @NotNull
    protected final DvcsMultiRootBranchConfig<Repo> myMultiRootBranchConfig;
    @NotNull
    protected final Repo myCurrentRepository;
    @NotNull
    protected final ListPopupImpl myPopup;

    protected DvcsBranchPopup(@NotNull Repo currentRepository, @NotNull AbstractRepositoryManager<Repo> repositoryManager, @NotNull DvcsMultiRootBranchConfig<Repo> multiRootBranchConfig, @NotNull DvcsSyncSettings vcsSettings, @NotNull Condition<AnAction> preselectActionCondition) {
        if (currentRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRepository", "com/intellij/dvcs/branch/DvcsBranchPopup", "<init>"));
        }
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "com/intellij/dvcs/branch/DvcsBranchPopup", "<init>"));
        }
        if (multiRootBranchConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiRootBranchConfig", "com/intellij/dvcs/branch/DvcsBranchPopup", "<init>"));
        }
        if (vcsSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsSettings", "com/intellij/dvcs/branch/DvcsBranchPopup", "<init>"));
        }
        if (preselectActionCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectActionCondition", "com/intellij/dvcs/branch/DvcsBranchPopup", "<init>"));
        }
        this.myProject = currentRepository.getProject();
        this.myCurrentRepository = currentRepository;
        this.myRepositoryManager = repositoryManager;
        this.myVcs = currentRepository.getVcs();
        this.myVcsSettings = vcsSettings;
        this.myMultiRootBranchConfig = multiRootBranchConfig;
        String title = this.createPopupTitle(currentRepository);
        this.myPopup = new BranchActionGroupPopup(title, this.myProject, preselectActionCondition, this.createActions());
        this.initBranchSyncPolicyIfNotInitialized();
        this.setCurrentBranchInfo();
        this.warnThatBranchesDivergedIfNeeded();
    }

    @NotNull
    public ListPopup asListPopup() {
        ListPopupImpl listPopupImpl = this.myPopup;
        if (listPopupImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/branch/DvcsBranchPopup", "asListPopup"));
        }
        return listPopupImpl;
    }

    private void initBranchSyncPolicyIfNotInitialized() {
        if (this.myRepositoryManager.moreThanOneRoot() && this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.NOT_DECIDED) {
            if (!this.myMultiRootBranchConfig.diverged()) {
                this.notifyAboutSyncedBranches();
                this.myVcsSettings.setSyncSetting(DvcsSyncSettings.Value.SYNC);
            } else {
                this.myVcsSettings.setSyncSetting(DvcsSyncSettings.Value.DONT_SYNC);
            }
        }
    }

    @NotNull
    private String createPopupTitle(@NotNull Repo currentRepository) {
        if (currentRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRepository", "com/intellij/dvcs/branch/DvcsBranchPopup", "createPopupTitle"));
        }
        String title = this.myVcs.getDisplayName() + " Branches";
        if (this.myRepositoryManager.moreThanOneRoot() && this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.DONT_SYNC) {
            title = title + " in " + DvcsUtil.getShortRepositoryName(currentRepository);
        }
        String string = title;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/branch/DvcsBranchPopup", "createPopupTitle"));
        }
        return string;
    }

    protected void setCurrentBranchInfo() {
        String branchText = "Current branch : ";
        this.myPopup.setAdText(branchText + this.myCurrentRepository.getCurrentBranchName(), 0);
    }

    private void notifyAboutSyncedBranches() {
        String description = "You have several " + this.myVcs.getDisplayName() + " roots in the project and they all are checked out at the same branch. We've enabled synchronous branch control for the project. <br/>If you wish to control branches in different roots separately, you may <a href='settings'>disable</a> the setting.";
        NotificationListener listener2 = new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/dvcs/branch/DvcsBranchPopup$1", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/dvcs/branch/DvcsBranchPopup$1", "hyperlinkUpdate"));
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(DvcsBranchPopup.this.myProject, DvcsBranchPopup.this.myVcs.getConfigurable().getDisplayName());
                    if (DvcsBranchPopup.this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.DONT_SYNC) {
                        notification.expire();
                    }
                }
            }
        };
        VcsNotifier.getInstance(this.myProject).notifyImportantInfo("Synchronous branch control enabled", description, listener2);
    }

    @NotNull
    private ActionGroup createActions() {
        DefaultActionGroup popupGroup = new DefaultActionGroup(null, false);
        AbstractRepositoryManager<Repo> repositoryManager = this.myRepositoryManager;
        if (repositoryManager.moreThanOneRoot()) {
            if (this.userWantsSyncControl()) {
                this.fillWithCommonRepositoryActions(popupGroup, repositoryManager);
            } else {
                this.fillPopupWithCurrentRepositoryActions(popupGroup, this.createRepositoriesActions());
            }
        } else {
            this.fillPopupWithCurrentRepositoryActions(popupGroup, null);
        }
        popupGroup.addSeparator();
        DefaultActionGroup defaultActionGroup = popupGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/branch/DvcsBranchPopup", "createActions"));
        }
        return defaultActionGroup;
    }

    private boolean userWantsSyncControl() {
        return this.myVcsSettings.getSyncSetting() != DvcsSyncSettings.Value.DONT_SYNC;
    }

    protected abstract void fillWithCommonRepositoryActions(@NotNull DefaultActionGroup var1, @NotNull AbstractRepositoryManager<Repo> var2);

    @NotNull
    protected List<Repo> filterRepositoriesNotOnThisBranch(@NotNull String branch, @NotNull List<Repo> allRepositories) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "com/intellij/dvcs/branch/DvcsBranchPopup", "filterRepositoriesNotOnThisBranch"));
        }
        if (allRepositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allRepositories", "com/intellij/dvcs/branch/DvcsBranchPopup", "filterRepositoriesNotOnThisBranch"));
        }
        List list = ContainerUtil.filter(allRepositories, repository -> {
            if (branch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "com/intellij/dvcs/branch/DvcsBranchPopup", "lambda$filterRepositoriesNotOnThisBranch$0"));
            }
            return !branch.equals(repository.getCurrentBranchName());
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/branch/DvcsBranchPopup", "filterRepositoriesNotOnThisBranch"));
        }
        return list;
    }

    private void warnThatBranchesDivergedIfNeeded() {
        if (this.myRepositoryManager.moreThanOneRoot() && this.myMultiRootBranchConfig.diverged() && this.userWantsSyncControl()) {
            this.myPopup.setWarning("Branches have diverged");
        }
    }

    @NotNull
    protected abstract DefaultActionGroup createRepositoriesActions();

    protected boolean highlightCurrentRepo() {
        return !this.userWantsSyncControl() || this.myMultiRootBranchConfig.diverged();
    }

    protected abstract void fillPopupWithCurrentRepositoryActions(@NotNull DefaultActionGroup var1, @Nullable DefaultActionGroup var2);
}

