/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.GroupedLogMessage;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.MessagePoolListener;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessagePool {
    private static final int MAX_POOL_SIZE_FOR_FATALS = 100;
    private final List<AbstractMessage> myIdeFatals = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<MessagePoolListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final MessageGrouper myFatalsGrouper;

    MessagePool(int maxGroupSize, int timeout) {
        this.myFatalsGrouper = new MessageGrouper(timeout, maxGroupSize);
    }

    public static MessagePool getInstance() {
        return MessagePoolHolder.ourInstance;
    }

    @Nullable
    public LogMessage addIdeFatalMessage(IdeaLoggingEvent aEvent) {
        LogMessage message;
        Object data = aEvent.getData();
        LogMessage logMessage = message = data instanceof LogMessage ? (LogMessage)data : new LogMessage(aEvent);
        if (this.myIdeFatals.size() < 100) {
            if (this.myFatalsGrouper.addToGroup(message)) {
                return message;
            }
        } else if (this.myIdeFatals.size() == 100) {
            String msg = DiagnosticBundle.message("error.monitor.too.many.errors", new Object[0]);
            LogMessage tooMany = new LogMessage(new LoggingEvent(msg, Category.getRoot(), Priority.ERROR, null, (Throwable)new TooManyErrorsException()));
            this.myFatalsGrouper.addToGroup(tooMany);
            return tooMany;
        }
        return null;
    }

    public List<AbstractMessage> getFatalErrors(boolean aIncludeReadMessages, boolean aIncludeSubmittedMessages) {
        ArrayList<AbstractMessage> result2 = new ArrayList<AbstractMessage>();
        for (AbstractMessage each : this.myIdeFatals) {
            if (!each.isRead() && !each.isSubmitted()) {
                result2.add(each);
                continue;
            }
            if ((!each.isRead() || !aIncludeReadMessages) && (!each.isSubmitted() || !aIncludeSubmittedMessages)) continue;
            result2.add(each);
        }
        return result2;
    }

    public void clearFatals() {
        for (AbstractMessage fatal : this.myIdeFatals) {
            fatal.setRead(true);
        }
        this.myIdeFatals.clear();
        this.notifyListenersClear();
    }

    public void addListener(MessagePoolListener aListener) {
        this.myListeners.add(aListener);
    }

    public void removeListener(MessagePoolListener aListener) {
        this.myListeners.remove(aListener);
    }

    private void notifyListenersAdd() {
        for (MessagePoolListener messagePoolListener : this.myListeners) {
            messagePoolListener.newEntryAdded();
        }
    }

    private void notifyListenersClear() {
        for (MessagePoolListener messagePoolListener : this.myListeners) {
            messagePoolListener.poolCleared();
        }
    }

    void notifyListenersRead() {
        for (MessagePoolListener messagePoolListener : this.myListeners) {
            messagePoolListener.entryWasRead();
        }
    }

    public static class TooManyErrorsException
    extends Exception {
        TooManyErrorsException() {
            super(DiagnosticBundle.message("error.monitor.too.many.errors", new Object[0]));
        }
    }

    private class MessageGrouper
    implements Runnable {
        private final int myTimeOut;
        private final int myMaxGroupSize;
        private final List<AbstractMessage> myMessages = new ArrayList<AbstractMessage>();
        private Future<?> myAlarm = CompletableFuture.completedFuture(null);

        public MessageGrouper(int timeout, int maxGroupSize) {
            this.myTimeOut = timeout;
            this.myMaxGroupSize = maxGroupSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List<AbstractMessage> list = this.myMessages;
            synchronized (list) {
                if (this.myMessages.size() > 0) {
                    this.post();
                }
            }
        }

        private void post() {
            AbstractMessage message = this.myMessages.size() == 1 ? this.myMessages.get(0) : new GroupedLogMessage(new ArrayList<AbstractMessage>(this.myMessages));
            this.myMessages.clear();
            MessagePool.this.myIdeFatals.add(message);
            MessagePool.this.notifyListenersAdd();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addToGroup(@NotNull AbstractMessage message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/diagnostic/MessagePool$MessageGrouper", "addToGroup"));
            }
            boolean result2 = this.myMessages.isEmpty();
            List<AbstractMessage> list = this.myMessages;
            synchronized (list) {
                this.myMessages.add(message);
                if (this.myMessages.size() >= this.myMaxGroupSize) {
                    this.post();
                } else {
                    this.myAlarm.cancel(false);
                    this.myAlarm = AppExecutorUtil.getAppScheduledExecutorService().schedule(this, (long)this.myTimeOut, TimeUnit.MILLISECONDS);
                }
            }
            return result2;
        }
    }

    private static class MessagePoolHolder {
        private static final MessagePool ourInstance = new MessagePool(20, 1000);

        private MessagePoolHolder() {
        }
    }
}

