/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.ui.JavaDebuggerSupport;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundTypeRenderer;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.TypeRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiTypeCodeFragmentImpl;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Function;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;

class CompoundRendererConfigurable
extends JPanel {
    private CompoundTypeRenderer myRenderer;
    private CompoundTypeRenderer myOriginalRenderer;
    private Project myProject;
    private final ClassNameEditorWithBrowseButton myClassNameField;
    private final JRadioButton myRbDefaultLabel;
    private final JRadioButton myRbExpressionLabel;
    private final JBCheckBox myShowTypeCheckBox;
    private final JRadioButton myRbDefaultChildrenRenderer;
    private final JRadioButton myRbExpressionChildrenRenderer;
    private final JRadioButton myRbListChildrenRenderer;
    private final XDebuggerExpressionEditor myLabelEditor;
    private final XDebuggerExpressionEditor myChildrenEditor;
    private final XDebuggerExpressionEditor myChildrenExpandedEditor;
    private XDebuggerExpressionEditor myListChildrenEditor;
    private final JLabel myExpandedLabel;
    private JBTable myTable;
    private final JBCheckBox myAppendDefaultChildren;
    @NonNls
    private static final String EMPTY_PANEL_ID = "EMPTY";
    @NonNls
    private static final String DATA_PANEL_ID = "DATA";
    private static final int NAME_TABLE_COLUMN = 0;
    private static final int EXPRESSION_TABLE_COLUMN = 1;

    public CompoundRendererConfigurable(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/debugger/settings/CompoundRendererConfigurable", "<init>"));
        }
        super(new CardLayout());
        if (this.myProject == null) {
            this.myProject = JavaDebuggerSupport.getContextProjectForEditorFieldsInDebuggerConfigurables();
        }
        this.myRbDefaultLabel = new JRadioButton(DebuggerBundle.message((String)"label.compound.renderer.configurable.use.default.renderer", (Object[])new Object[0]));
        this.myRbExpressionLabel = new JRadioButton(DebuggerBundle.message((String)"label.compound.renderer.configurable.use.expression", (Object[])new Object[0]));
        ButtonGroup labelButtonsGroup = new ButtonGroup();
        labelButtonsGroup.add(this.myRbDefaultLabel);
        labelButtonsGroup.add(this.myRbExpressionLabel);
        this.myShowTypeCheckBox = new JBCheckBox(DebuggerBundle.message((String)"label.compound.renderer.configurable.show.type", (Object[])new Object[0]));
        this.myRbDefaultChildrenRenderer = new JRadioButton(DebuggerBundle.message((String)"label.compound.renderer.configurable.use.default.renderer", (Object[])new Object[0]));
        this.myRbExpressionChildrenRenderer = new JRadioButton(DebuggerBundle.message((String)"label.compound.renderer.configurable.use.expression", (Object[])new Object[0]));
        this.myRbListChildrenRenderer = new JRadioButton(DebuggerBundle.message((String)"label.compound.renderer.configurable.use.expression.list", (Object[])new Object[0]));
        ButtonGroup childrenButtonGroup = new ButtonGroup();
        childrenButtonGroup.add(this.myRbDefaultChildrenRenderer);
        childrenButtonGroup.add(this.myRbExpressionChildrenRenderer);
        childrenButtonGroup.add(this.myRbListChildrenRenderer);
        JavaDebuggerEditorsProvider editorsProvider = new JavaDebuggerEditorsProvider();
        this.myLabelEditor = new XDebuggerExpressionEditor(this.myProject, (XDebuggerEditorsProvider)editorsProvider, "ClassLabelExpression", null, XExpressionImpl.EMPTY_EXPRESSION, false, false, true);
        this.myChildrenEditor = new XDebuggerExpressionEditor(this.myProject, (XDebuggerEditorsProvider)editorsProvider, "ClassChildrenExpression", null, XExpressionImpl.EMPTY_EXPRESSION, false, false, true);
        this.myChildrenExpandedEditor = new XDebuggerExpressionEditor(this.myProject, (XDebuggerEditorsProvider)editorsProvider, "ClassChildrenExpression", null, XExpressionImpl.EMPTY_EXPRESSION, false, false, true);
        JComponent myChildrenListEditor = this.createChildrenListEditor(editorsProvider);
        ItemListener updateListener = new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CompoundRendererConfigurable$1", "itemStateChanged"));
                }
                CompoundRendererConfigurable.this.updateEnabledState();
            }
        };
        this.myRbExpressionLabel.addItemListener(updateListener);
        this.myRbListChildrenRenderer.addItemListener(updateListener);
        this.myRbExpressionChildrenRenderer.addItemListener(updateListener);
        this.myClassNameField = new ClassNameEditorWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CompoundRendererConfigurable$2", "actionPerformed"));
                }
                PsiClass psiClass = DebuggerUtils.getInstance().chooseClassDialog(DebuggerBundle.message((String)"title.compound.renderer.configurable.choose.renderer.reference.type", (Object[])new Object[0]), CompoundRendererConfigurable.this.myProject);
                if (psiClass != null) {
                    String qName = JVMNameUtil.getNonAnonymousClassName(psiClass);
                    CompoundRendererConfigurable.this.myClassNameField.setText(qName);
                    CompoundRendererConfigurable.this.updateContext(qName);
                }
            }
        }, this.myProject);
        this.myClassNameField.getEditorTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/settings/CompoundRendererConfigurable$3", "focusLost"));
                }
                CompoundRendererConfigurable.this.updateContext(CompoundRendererConfigurable.this.myClassNameField.getText());
            }
        });
        this.myAppendDefaultChildren = new JBCheckBox(DebuggerBundle.message((String)"label.compound.renderer.configurable.append.default.children", (Object[])new Object[0]));
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)new JLabel(DebuggerBundle.message((String)"label.compound.renderer.configurable.apply.to", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        panel2.add((Component)((Object)this.myClassNameField), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsTop((int)4), 0, 0));
        panel2.add((Component)new JLabel(DebuggerBundle.message((String)"label.compound.renderer.configurable.when.rendering", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsTop((int)20), 0, 0));
        panel2.add((Component)this.myShowTypeCheckBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsLeft((int)7), 0, 0));
        panel2.add((Component)this.myRbDefaultLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        panel2.add((Component)this.myRbExpressionLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        panel2.add((Component)this.myLabelEditor.getComponent(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsLeft((int)30), 0, 0));
        panel2.add((Component)new JLabel(DebuggerBundle.message((String)"label.compound.renderer.configurable.when.expanding", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsTop((int)20), 0, 0));
        panel2.add((Component)this.myRbDefaultChildrenRenderer, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        panel2.add((Component)this.myRbExpressionChildrenRenderer, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        panel2.add((Component)this.myChildrenEditor.getComponent(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsLeft((int)30), 0, 0));
        this.myExpandedLabel = new JLabel(DebuggerBundle.message((String)"label.compound.renderer.configurable.test.can.expand", (Object[])new Object[0]));
        panel2.add((Component)this.myExpandedLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)4, (int)30, (int)0, (int)0), 0, 0));
        panel2.add((Component)this.myChildrenExpandedEditor.getComponent(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsLeft((int)30), 0, 0));
        panel2.add((Component)this.myRbListChildrenRenderer, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        panel2.add((Component)myChildrenListEditor, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.insets((int)4, (int)30, (int)0, (int)0), 0, 0));
        panel2.add((Component)this.myAppendDefaultChildren, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insetsLeft((int)25), 0, 0));
        this.add((Component)new JPanel(), EMPTY_PANEL_ID);
        this.add((Component)panel2, DATA_PANEL_ID);
    }

    public void setRenderer(NodeRenderer renderer) {
        if (renderer instanceof CompoundTypeRenderer) {
            this.myRenderer = (CompoundTypeRenderer)renderer;
            this.myOriginalRenderer = (CompoundTypeRenderer)renderer.clone();
        } else {
            this.myOriginalRenderer = null;
            this.myRenderer = null;
        }
        this.reset();
    }

    public CompoundTypeRenderer getRenderer() {
        return this.myRenderer;
    }

    private void updateContext(String qName) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Project project2 = this.myProject;
            if (project2 != null) {
                Pair<PsiElement, PsiType> pair = DebuggerUtilsImpl.getPsiClassAndType(qName, project2);
                PsiElement context = (PsiElement)pair.first;
                if (context != null) {
                    this.myLabelEditor.setContext(context);
                    this.myChildrenEditor.setContext(context);
                    this.myChildrenExpandedEditor.setContext(context);
                    this.myListChildrenEditor.setContext(context);
                }
            }
        });
    }

    private void updateEnabledState() {
        this.myLabelEditor.setEnabled(this.myRbExpressionLabel.isSelected());
        boolean isChildrenExpression = this.myRbExpressionChildrenRenderer.isSelected();
        this.myChildrenExpandedEditor.setEnabled(isChildrenExpression);
        this.myExpandedLabel.setEnabled(isChildrenExpression);
        this.myChildrenEditor.setEnabled(isChildrenExpression);
        boolean isListChildren = this.myRbListChildrenRenderer.isSelected();
        this.myTable.setEnabled(isListChildren);
        this.myAppendDefaultChildren.setEnabled(isListChildren);
    }

    private JComponent createChildrenListEditor(JavaDebuggerEditorsProvider editorsProvider) {
        final MyTableModel tableModel = new MyTableModel();
        this.myTable = new JBTable((TableModel)tableModel);
        this.myListChildrenEditor = new XDebuggerExpressionEditor(this.myProject, (XDebuggerEditorsProvider)editorsProvider, "NamedChildrenConfigurable", null, XExpressionImpl.EMPTY_EXPRESSION, false, false, false);
        final JComponent editorComponent = this.myListChildrenEditor.getComponent();
        AbstractTableCellEditor editor = new AbstractTableCellEditor(){

            public Object getCellEditorValue() {
                return TextWithImportsImpl.fromXExpression(CompoundRendererConfigurable.this.myListChildrenEditor.getExpression());
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                CompoundRendererConfigurable.this.myListChildrenEditor.setExpression(TextWithImportsImpl.toXExpression((TextWithImports)value));
                return editorComponent;
            }
        };
        editorComponent.registerKeyboardAction(e -> editor.stopCellEditing(), KeyStroke.getKeyStroke(10, 0), 1);
        editorComponent.registerKeyboardAction(e -> editor.cancelCellEditing(), KeyStroke.getKeyStroke(27, 0), 1);
        TableColumn exprColumn = this.myTable.getColumnModel().getColumn(1);
        exprColumn.setCellEditor((TableCellEditor)editor);
        exprColumn.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            @NotNull
            public Component getTableCellRendererComponent(@NotNull JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (table == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/debugger/settings/CompoundRendererConfigurable$5", "getTableCellRendererComponent"));
                }
                TextWithImports textWithImports = (TextWithImports)value;
                String text = textWithImports != null ? textWithImports.getText() : "";
                Component component = super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
                if (component == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/settings/CompoundRendererConfigurable$5", "getTableCellRendererComponent"));
                }
                return component;
            }
        });
        return ToolbarDecorator.createDecorator((JTable)this.myTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                tableModel.addRow("", DebuggerUtils.getInstance().createExpressionWithImports(""));
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int selectedRow = CompoundRendererConfigurable.this.myTable.getSelectedRow();
                if (selectedRow >= 0 && selectedRow < CompoundRendererConfigurable.this.myTable.getRowCount()) {
                    CompoundRendererConfigurable.this.getTableModel().removeRow(selectedRow);
                }
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.moveSelectedItemsUp((JTable)CompoundRendererConfigurable.this.myTable);
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.moveSelectedItemsDown((JTable)CompoundRendererConfigurable.this.myTable);
            }
        }).createPanel();
    }

    public boolean isModified() {
        if (this.myRenderer == null) {
            return false;
        }
        CompoundTypeRenderer cloned = (CompoundTypeRenderer)this.myRenderer.clone();
        this.flushDataTo(cloned);
        return !DebuggerUtilsEx.externalizableEqual(cloned, this.myOriginalRenderer);
    }

    public void apply() {
        if (this.myRenderer == null) {
            return;
        }
        this.flushDataTo(this.myRenderer);
        this.myOriginalRenderer = (CompoundTypeRenderer)this.myRenderer.clone();
    }

    private void flushDataTo(CompoundTypeRenderer renderer) {
        LabelRenderer labelRenderer = null;
        renderer.setShowType(this.myShowTypeCheckBox.isSelected());
        if (this.myRbExpressionLabel.isSelected()) {
            labelRenderer = new LabelRenderer();
            labelRenderer.setLabelExpression(TextWithImportsImpl.fromXExpression(this.myLabelEditor.getExpression()));
        }
        renderer.setLabelRenderer(labelRenderer);
        TypeRenderer childrenRenderer = null;
        if (this.myRbExpressionChildrenRenderer.isSelected()) {
            childrenRenderer = new ExpressionChildrenRenderer();
            childrenRenderer.setChildrenExpression(TextWithImportsImpl.fromXExpression(this.myChildrenEditor.getExpression()));
            childrenRenderer.setChildrenExpandable(TextWithImportsImpl.fromXExpression(this.myChildrenExpandedEditor.getExpression()));
        } else if (this.myRbListChildrenRenderer.isSelected()) {
            EnumerationChildrenRenderer enumerationChildrenRenderer = new EnumerationChildrenRenderer(this.getTableModel().getExpressions());
            enumerationChildrenRenderer.setAppendDefaultChildren(this.myAppendDefaultChildren.isSelected());
            childrenRenderer = enumerationChildrenRenderer;
        }
        renderer.setChildrenRenderer((ChildrenRenderer)((Object)childrenRenderer));
        renderer.setClassName(this.myClassNameField.getText());
    }

    public void reset() {
        TextWithImportsImpl emptyExpressionFragment = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "");
        ((CardLayout)this.getLayout()).show(this, this.myRenderer == null ? EMPTY_PANEL_ID : DATA_PANEL_ID);
        if (this.myRenderer == null) {
            return;
        }
        String className = this.myRenderer.getClassName();
        this.myClassNameField.setText(className);
        this.updateContext(className);
        ValueLabelRenderer labelRenderer = this.myRenderer.getLabelRenderer();
        ChildrenRenderer childrenRenderer = this.myRenderer.getChildrenRenderer();
        this.myShowTypeCheckBox.setSelected(this.myRenderer.isShowType());
        if (this.myRenderer.isBaseRenderer(labelRenderer)) {
            this.myLabelEditor.setExpression(TextWithImportsImpl.toXExpression(emptyExpressionFragment));
            this.myRbDefaultLabel.setSelected(true);
        } else {
            this.myRbExpressionLabel.setSelected(true);
            this.myLabelEditor.setExpression(TextWithImportsImpl.toXExpression(((LabelRenderer)labelRenderer).getLabelExpression()));
        }
        this.getTableModel().clear();
        this.myAppendDefaultChildren.setSelected(false);
        if (this.myRenderer.isBaseRenderer(childrenRenderer)) {
            this.myRbDefaultChildrenRenderer.setSelected(true);
            this.myChildrenEditor.setExpression(TextWithImportsImpl.toXExpression(emptyExpressionFragment));
            this.myChildrenExpandedEditor.setExpression(TextWithImportsImpl.toXExpression(emptyExpressionFragment));
        } else if (childrenRenderer instanceof ExpressionChildrenRenderer) {
            this.myRbExpressionChildrenRenderer.setSelected(true);
            ExpressionChildrenRenderer exprRenderer = (ExpressionChildrenRenderer)childrenRenderer;
            this.myChildrenEditor.setExpression(TextWithImportsImpl.toXExpression(exprRenderer.getChildrenExpression()));
            this.myChildrenExpandedEditor.setExpression(TextWithImportsImpl.toXExpression(exprRenderer.getChildrenExpandable()));
        } else {
            this.myRbListChildrenRenderer.setSelected(true);
            this.myChildrenEditor.setExpression(TextWithImportsImpl.toXExpression(emptyExpressionFragment));
            this.myChildrenExpandedEditor.setExpression(TextWithImportsImpl.toXExpression(emptyExpressionFragment));
            if (childrenRenderer instanceof EnumerationChildrenRenderer) {
                EnumerationChildrenRenderer enumerationRenderer = (EnumerationChildrenRenderer)childrenRenderer;
                this.getTableModel().init(enumerationRenderer.getChildren());
                this.myAppendDefaultChildren.setSelected(enumerationRenderer.isAppendDefaultChildren());
            }
        }
        this.updateEnabledState();
    }

    private MyTableModel getTableModel() {
        return (MyTableModel)this.myTable.getModel();
    }

    private static class ClassNameEditorWithBrowseButton
    extends ReferenceEditorWithBrowseButton {
        private ClassNameEditorWithBrowseButton(ActionListener browseActionListener, Project project2) {
            super(browseActionListener, project2, (Function<String, Document>)((Function)s -> {
                PsiTypeCodeFragmentImpl fragment = new PsiTypeCodeFragmentImpl(project2, true, "fragment.java", (CharSequence)s, 0, null){

                    @Override
                    public boolean importClass(PsiClass aClass) {
                        return false;
                    }
                };
                fragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
                return PsiDocumentManager.getInstance((Project)project2).getDocument((PsiFile)fragment);
            }), "");
        }
    }

    private static final class MyTableModel
    extends AbstractTableModel {
        private final List<Row> myData = new ArrayList<Row>();

        public void init(List<Pair<String, TextWithImports>> data) {
            this.myData.clear();
            for (Pair<String, TextWithImports> pair : data) {
                this.myData.add(new Row((String)pair.getFirst(), (TextWithImports)pair.getSecond()));
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.myData.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @NotNull
        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (String.class == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/settings/CompoundRendererConfigurable$MyTableModel", "getColumnClass"));
                    }
                    return String.class;
                }
                case 1: {
                    if (TextWithImports.class == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/settings/CompoundRendererConfigurable$MyTableModel", "getColumnClass"));
                    }
                    return TextWithImports.class;
                }
            }
            Class<?> clazz = super.getColumnClass(columnIndex);
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/settings/CompoundRendererConfigurable$MyTableModel", "getColumnClass"));
            }
            return clazz;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this.getRowCount()) {
                return null;
            }
            Row row = this.myData.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return row.name;
                }
                case 1: {
                    return row.value;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (rowIndex >= this.getRowCount()) {
                return;
            }
            Row row = this.myData.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    row.name = (String)aValue;
                    break;
                }
                case 1: {
                    row.value = (TextWithImports)aValue;
                }
            }
        }

        @Override
        @NotNull
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    String string = DebuggerBundle.message((String)"label.compound.renderer.configurable.table.header.name", (Object[])new Object[0]);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/settings/CompoundRendererConfigurable$MyTableModel", "getColumnName"));
                    }
                    return string;
                }
                case 1: {
                    String string = DebuggerBundle.message((String)"label.compound.renderer.configurable.table.header.expression", (Object[])new Object[0]);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/settings/CompoundRendererConfigurable$MyTableModel", "getColumnName"));
                    }
                    return string;
                }
            }
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/settings/CompoundRendererConfigurable$MyTableModel", "getColumnName"));
            }
            return "";
        }

        public void addRow(String name, TextWithImports expressionWithImports) {
            this.myData.add(new Row(name, expressionWithImports));
            int lastRow = this.myData.size() - 1;
            this.fireTableRowsInserted(lastRow, lastRow);
        }

        public void removeRow(int row) {
            if (row >= 0 && row < this.myData.size()) {
                this.myData.remove(row);
                this.fireTableRowsDeleted(row, row);
            }
        }

        public void clear() {
            this.myData.clear();
            this.fireTableDataChanged();
        }

        public List<Pair<String, TextWithImports>> getExpressions() {
            ArrayList<Pair<String, TextWithImports>> pairs = new ArrayList<Pair<String, TextWithImports>>(this.myData.size());
            for (Row row : this.myData) {
                pairs.add((Pair<String, TextWithImports>)Pair.create((Object)row.name, (Object)row.value));
            }
            return pairs;
        }

        private static final class Row {
            public String name;
            public TextWithImports value;

            public Row(String name, TextWithImports value) {
                this.name = name;
                this.value = value;
            }
        }
    }
}

