/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiType;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Collections;

class InstanceofEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.InstanceofEvaluator");
    private final Evaluator myOperandEvaluator;
    private final TypeEvaluator myTypeEvaluator;

    public InstanceofEvaluator(Evaluator operandEvaluator, TypeEvaluator typeEvaluator) {
        this.myOperandEvaluator = operandEvaluator;
        this.myTypeEvaluator = typeEvaluator;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Value value = (Value)this.myOperandEvaluator.evaluate(context);
        if (value == null) {
            return DebuggerUtilsEx.createValue(context.getDebugProcess().getVirtualMachineProxy(), PsiType.BOOLEAN.getPresentableText(), false);
        }
        if (!(value instanceof ObjectReference)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.object.reference.expected", (Object[])new Object[0]));
        }
        try {
            ReferenceType refType = (ReferenceType)this.myTypeEvaluator.evaluate(context);
            ClassObjectReference classObject = refType.classObject();
            ClassType classRefType = (ClassType)classObject.referenceType();
            Method method2 = classRefType.concreteMethodByName("isAssignableFrom", "(Ljava/lang/Class;)Z");
            return context.getDebugProcess().invokeMethod((EvaluationContext)context, classObject, method2, Collections.singletonList(((ObjectReference)value).referenceType().classObject()));
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }
}

