/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.managerThread.DebuggerCommand;
import com.intellij.debugger.engine.managerThread.DebuggerManagerThread;
import com.intellij.debugger.engine.managerThread.SuspendContextCommand;
import com.intellij.debugger.impl.InvokeAndWaitThread;
import com.intellij.debugger.impl.InvokeThread;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorListenerAdapter;
import com.intellij.openapi.progress.util.ProgressWindowWithNotification;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.sun.jdi.VMDisconnectedException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class DebuggerManagerThreadImpl
extends InvokeAndWaitThread<DebuggerCommandImpl>
implements DebuggerManagerThread,
Disposable {
    private static final Logger LOG = Logger.getInstance(DebuggerManagerThreadImpl.class);
    public static final int COMMAND_TIMEOUT = 3000;
    private volatile boolean myDisposed;

    DebuggerManagerThreadImpl(@NotNull Disposable parent, Project project2) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/debugger/engine/DebuggerManagerThreadImpl", "<init>"));
        }
        super(project2);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public void dispose() {
        this.myDisposed = true;
    }

    public static DebuggerManagerThreadImpl createTestInstance(@NotNull Disposable parent, Project project2) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/debugger/engine/DebuggerManagerThreadImpl", "createTestInstance"));
        }
        return new DebuggerManagerThreadImpl(parent, project2);
    }

    public static boolean isManagerThread() {
        return DebuggerManagerThreadImpl.currentThread() instanceof DebuggerManagerThreadImpl;
    }

    public static void assertIsManagerThread() {
        LOG.assertTrue(DebuggerManagerThreadImpl.isManagerThread(), (Object)"Should be invoked in manager thread, use DebuggerManagerThreadImpl.getInstance(..).invoke...");
    }

    @Override
    public void invokeAndWait(DebuggerCommandImpl managerCommand) {
        LOG.assertTrue(!DebuggerManagerThreadImpl.isManagerThread(), (Object)"Should be invoked outside manager thread, use DebuggerManagerThreadImpl.getInstance(..).invoke...");
        super.invokeAndWait(managerCommand);
    }

    public void invoke(DebuggerCommandImpl managerCommand) {
        if (DebuggerManagerThreadImpl.currentThread() == this) {
            this.processEvent(managerCommand);
        } else {
            this.schedule(managerCommand);
        }
    }

    @Override
    public boolean pushBack(DebuggerCommandImpl managerCommand) {
        boolean pushed = super.pushBack(managerCommand);
        if (!pushed) {
            managerCommand.notifyCancelled();
        }
        return pushed;
    }

    @Override
    public boolean schedule(DebuggerCommandImpl managerCommand) {
        boolean scheduled = super.schedule(managerCommand);
        if (!scheduled) {
            managerCommand.notifyCancelled();
        }
        return scheduled;
    }

    public void terminateAndInvoke(DebuggerCommandImpl command, int terminateTimeout) {
        DebuggerCommandImpl currentCommand = (DebuggerCommandImpl)this.myEvents.getCurrentEvent();
        this.invoke(command);
        if (currentCommand != null) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
                if (currentCommand == this.myEvents.getCurrentEvent()) {
                    this.getCurrentRequest().requestStop();
                    try {
                        this.getCurrentRequest().join();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        if (!this.myDisposed) {
                            this.startNewWorkerThread();
                        }
                    }
                }
            }, (long)terminateTimeout, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void processEvent(@NotNull DebuggerCommandImpl managerCommand) {
        if (managerCommand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "managerCommand", "com/intellij/debugger/engine/DebuggerManagerThreadImpl", "processEvent"));
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            if (this.myEvents.isClosed()) {
                managerCommand.notifyCancelled();
            } else {
                managerCommand.run();
            }
        }
        catch (VMDisconnectedException e) {
            LOG.debug((Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public void startProgress(final DebuggerCommandImpl command, ProgressWindowWithNotification progressWindow) {
        progressWindow.addListener(new ProgressIndicatorListenerAdapter(){

            @Override
            public void cancelled() {
                command.release();
            }
        });
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().runProcess(() -> this.invokeAndWait(command), (ProgressIndicator)progressWindow));
    }

    public void startLongProcessAndFork(Runnable process2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.startNewWorkerThread();
        try {
            process2.run();
        }
        catch (Throwable throwable) {
            InvokeThread.WorkerThreadRequest request = DebuggerManagerThreadImpl.getCurrentThreadRequest();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Switching back to " + request);
            }
            super.invokeAndWait(new DebuggerCommandImpl(request){
                final /* synthetic */ InvokeThread.WorkerThreadRequest val$request;
                {
                    this.val$request = workerThreadRequest;
                }

                @Override
                protected void action() throws Exception {
                    DebuggerManagerThreadImpl.this.switchToRequest(this.val$request);
                }

                @Override
                protected void commandCancelled() {
                    LOG.debug("Event queue was closed, killing request");
                    this.val$request.requestStop();
                }
            });
            throw throwable;
        }
        InvokeThread.WorkerThreadRequest request = DebuggerManagerThreadImpl.getCurrentThreadRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Switching back to " + request);
        }
        super.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
    }

    public void invokeCommand(final DebuggerCommand command) {
        if (command instanceof SuspendContextCommand) {
            SuspendContextCommand suspendContextCommand = (SuspendContextCommand)command;
            this.schedule(new SuspendContextCommandImpl((SuspendContextImpl)suspendContextCommand.getSuspendContext()){

                @Override
                public void contextAction() throws Exception {
                    command.action();
                }

                @Override
                protected void commandCancelled() {
                    command.commandCancelled();
                }
            });
        } else {
            this.schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    command.action();
                }

                @Override
                protected void commandCancelled() {
                    command.commandCancelled();
                }
            });
        }
    }

    public void restartIfNeeded() {
        if (this.myEvents.isClosed()) {
            this.myEvents.reopen();
            this.startNewWorkerThread();
        }
    }
}

