/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.components.RoamingType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011JL\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u00152\u001e\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u0018H\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011R/\u0010\u0005\u001a#\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b0\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/configurationStore/SchemeManagerIprProvider;", "Lcom/intellij/configurationStore/StreamProvider;", "subStateTagName", "", "(Ljava/lang/String;)V", "nameToData", "Ljava/util/concurrent/ConcurrentMap;", "kotlin.jvm.PlatformType", "", "Lorg/jetbrains/annotations/NotNull;", "delete", "", "fileSpec", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "load", "state", "Lorg/jdom/Element;", "processChildren", "path", "filter", "Lkotlin/Function1;", "", "processor", "Lkotlin/Function3;", "Ljava/io/InputStream;", "read", "write", "content", "size", "", "writeState", "projectModel-impl"})
public final class SchemeManagerIprProvider
implements StreamProvider {
    private final ConcurrentMap<String, byte[]> nameToData;
    private final String subStateTagName;

    @Nullable
    public InputStream read(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        ByteArrayInputStream byteArrayInputStream;
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        String name = PathUtilRt.getFileName((String)fileSpec);
        byte[] byArray = (byte[])this.nameToData.get(name);
        if (byArray != null) {
            byte[] p1;
            byte[] byArray2 = byArray;
            byte[] byArray3 = p1 = byArray2;
            byteArrayInputStream = new ByteArrayInputStream(byArray3);
        } else {
            byteArrayInputStream = null;
        }
        return byteArrayInputStream;
    }

    public void delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        this.nameToData.remove(PathUtilRt.getFileName((String)fileSpec));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChildren(@NotNull String path, @NotNull RoamingType roamingType, @NotNull Function1<? super String, Boolean> filter, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, Boolean> processor2) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Map map = this.nameToData;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            String name = (String)entry2.getKey();
            Object object = entry;
            byte[] data = (byte[])object.getValue();
            String string = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            if (!((Boolean)filter.invoke((Object)string)).booleanValue()) continue;
            object = data;
            object = new ByteArrayInputStream((byte[])object);
            boolean bl2 = false;
            try {
                ByteArrayInputStream it = (ByteArrayInputStream)object;
                String string2 = name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
                bl = (Boolean)processor2.invoke((Object)string2, (Object)it, (Object)false);
            }
            catch (Exception exception) {
                bl2 = true;
                try {
                    object.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl2) {
                    object.close();
                }
            }
            if (bl) continue;
            break;
        }
    }

    public void write(@NotNull String fileSpec, @NotNull byte[] content, int size, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        String name = PathUtilRt.getFileName((String)fileSpec);
        this.nameToData.put(name, ArrayUtil.realloc((byte[])content, (int)size));
    }

    public final void load(@Nullable Element state) {
        this.nameToData.clear();
        if (state == null) {
            return;
        }
        for (Element profileElement : state.getChildren(this.subStateTagName)) {
            String name = null;
            for (Element optionElement : profileElement.getChildren("option")) {
                if (!Intrinsics.areEqual((Object)optionElement.getAttributeValue("name"), (Object)"myName")) continue;
                name = optionElement.getAttributeValue("value");
            }
            CharSequence charSequence = name;
            if (charSequence == null || charSequence.length() == 0) continue;
            this.nameToData.put(name + ".xml", JdomKt.toByteArray(profileElement));
        }
    }

    public final void writeState(@NotNull Element state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Collection $receiver$iv = this.nameToData.keySet();
        Collection collection = $receiver$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] names = (String[])((Object[])stringArray);
        ArraysKt.sort((Object[])names);
        for (int j = 0; j < names.length; ++j) {
            byte[] byArray;
            byte[] it;
            String name = names[j];
            if ((byte[])this.nameToData.get(name) == null) continue;
            byte[] byArray2 = it = byArray;
            Element element = state;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            element.addContent(JdomKt.loadElement(byteArrayInputStream));
        }
    }

    public SchemeManagerIprProvider(@NotNull String subStateTagName) {
        Intrinsics.checkParameterIsNotNull((Object)subStateTagName, (String)"subStateTagName");
        this.subStateTagName = subStateTagName;
        this.nameToData = ContainerUtil.newConcurrentMap();
    }

    public boolean getEnabled() {
        return StreamProvider.DefaultImpls.getEnabled((StreamProvider)this);
    }

    public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        return StreamProvider.DefaultImpls.isApplicable((StreamProvider)this, (String)fileSpec, (RoamingType)roamingType);
    }
}

