/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.compiler.actions.CompileActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.task.ProjectTaskManager;

public class MakeModuleAction
extends CompileActionBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.actions.MakeModuleAction");

    @Override
    protected void doAction(DataContext dataContext, Project project2) {
        Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        if (modules == null) {
            Module module2 = (Module)LangDataKeys.MODULE.getData(dataContext);
            if (module2 == null) {
                return;
            }
            modules = new Module[]{module2};
        }
        try {
            ProjectTaskManager.getInstance((Project)project2).build(modules);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void update(AnActionEvent event) {
        String presentationText;
        super.update(event);
        Presentation presentation = event.getPresentation();
        if (!presentation.isEnabled()) {
            return;
        }
        DataContext dataContext = event.getDataContext();
        Module module2 = (Module)LangDataKeys.MODULE.getData(dataContext);
        Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        boolean isEnabled = module2 != null || modules != null;
        presentation.setEnabled(isEnabled);
        String actionName = this.getTemplatePresentation().getTextWithMnemonic();
        if (modules != null) {
            String text = actionName;
            for (int i2 = 0; i2 < modules.length; ++i2) {
                if (text.length() > 30) {
                    text = CompilerBundle.message((String)"action.make.selected.modules.text", (Object[])new Object[0]);
                    break;
                }
                Module toMake = modules[i2];
                if (i2 != 0) {
                    text = text + ",";
                }
                text = text + " '" + toMake.getName() + "'";
            }
            presentationText = text;
        } else {
            presentationText = module2 != null ? actionName + " '" + module2.getName() + "'" : actionName;
        }
        presentation.setText(presentationText);
        presentation.setVisible(isEnabled || !"ProjectViewPopup".equals(event.getPlace()));
    }
}

