/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.CachedInspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

class InspectionViewPsiTreeChangeAdapter
extends PsiTreeChangeAdapter {
    private static final int MAX_UPDATES_FOR_CANCELLABLE_ACTION = 100;
    private final InspectionResultsView myView;
    private final MergingUpdateQueue myUpdater;
    private final Alarm myAlarm;

    public InspectionViewPsiTreeChangeAdapter(final @NotNull InspectionResultsView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/InspectionViewPsiTreeChangeAdapter", "<init>"));
        }
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myView = view;
        this.myUpdater = new MergingUpdateQueue("inspection.view.psi.update.listener", 300, true, this.myView, this.myView, this.myView, Alarm.ThreadToUse.POOLED_THREAD){

            protected void execute(final @NotNull Update[] updates) {
                if (updates == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updates", "com/intellij/codeInspection/ui/InspectionViewPsiTreeChangeAdapter$1", "execute"));
                }
                ReadTask task = new ReadTask(){

                    @Override
                    public void computeInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/ui/InspectionViewPsiTreeChangeAdapter$1$1", "computeInReadAction"));
                        }
                        indicator.setText("Updating inspection view tree...");
                        HashSet files = new HashSet();
                        for (Update update : updates) {
                            VirtualFile file2 = (VirtualFile)update.getEqualityObjects()[0];
                            VfsUtilCore.iterateChildrenRecursively((VirtualFile)file2, (VirtualFileFilter)VirtualFileFilter.ALL, ((Set)files)::add);
                        }
                        Project project2 = view.getProject();
                        Runnable runnable2 = () -> this.lambda$computeInReadAction$2((Set)files, project2);
                        if (updates.length > 100) {
                            ProgressManager.getInstance().executeNonCancelableSection(runnable2);
                        } else {
                            runnable2.run();
                        }
                    }

                    @Override
                    public void onCanceled(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/ui/InspectionViewPsiTreeChangeAdapter$1$1", "onCanceled"));
                        }
                        if (!InspectionViewPsiTreeChangeAdapter.this.myView.isDisposed()) {
                            for (Update update : updates) {
                                InspectionViewPsiTreeChangeAdapter.this.myUpdater.queue(update);
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private /* synthetic */ void lambda$computeInReadAction$2(Set files, Project project2) {
                        Object object = InspectionViewPsiTreeChangeAdapter.this.myView.getTreeStructureUpdateLock();
                        synchronized (object) {
                            InspectionTreeNode root = InspectionViewPsiTreeChangeAdapter.this.myView.getTree().getRoot();
                            boolean[] needUpdateUI = new boolean[]{false};
                            InspectionViewPsiTreeChangeAdapter.processNodesIfNeed(root, (Processor<InspectionTreeNode>)node -> {
                                if (node instanceof CachedInspectionTreeNode) {
                                    RefEntity element = ((CachedInspectionTreeNode)node).getElement();
                                    if (element instanceof RefElement) {
                                        PsiFile file2;
                                        SmartPsiElementPointer pointer = ((RefElement)element).getPointer();
                                        VirtualFile strictVirtualFile = pointer.getVirtualFile();
                                        if ((strictVirtualFile == null || !strictVirtualFile.isValid()) && (file2 = pointer.getContainingFile()) != null && file2.isValid()) {
                                            strictVirtualFile = file2.getVirtualFile();
                                        }
                                        if (strictVirtualFile == null || files.contains(strictVirtualFile)) {
                                            ((CachedInspectionTreeNode)node).dropCache(project2);
                                            if (!needUpdateUI[0]) {
                                                needUpdateUI[0] = true;
                                            }
                                        }
                                        return false;
                                    }
                                    ((CachedInspectionTreeNode)node).dropCache(project2);
                                    if (!needUpdateUI[0]) {
                                        needUpdateUI[0] = true;
                                    }
                                    return false;
                                }
                                return true;
                            });
                            if (needUpdateUI[0]) {
                                InspectionViewPsiTreeChangeAdapter.this.myAlarm.cancelAllRequests();
                                InspectionViewPsiTreeChangeAdapter.this.myAlarm.addRequest(() -> InspectionViewPsiTreeChangeAdapter.resetTree(InspectionViewPsiTreeChangeAdapter.this.myView), 100, ModalityState.NON_MODAL);
                            }
                        }
                    }
                };
                ProgressIndicatorUtils.scheduleWithWriteActionPriority(InspectionViewPsiTreeChangeAdapter.this.myView.getTreeUpdater(), task);
            }
        };
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/ui/InspectionViewPsiTreeChangeAdapter", "childAdded"));
        }
        this.processEventFileOrDir(event, false);
    }

    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/ui/InspectionViewPsiTreeChangeAdapter", "beforeChildRemoval"));
        }
        this.processEventFileOrDir(event, true);
    }

    public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/ui/InspectionViewPsiTreeChangeAdapter", "beforeChildReplacement"));
        }
        this.processEventFileOrDir(event, true);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/ui/InspectionViewPsiTreeChangeAdapter", "childMoved"));
        }
        this.processEventFileOrDir(event, false);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/ui/InspectionViewPsiTreeChangeAdapter", "childrenChanged"));
        }
        this.processEventFileOrDir(event, false);
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/ui/InspectionViewPsiTreeChangeAdapter", "propertyChanged"));
        }
        this.processEventFileOrDir(event, false);
    }

    public static void resetTree(@NotNull InspectionResultsView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/InspectionViewPsiTreeChangeAdapter", "resetTree"));
        }
        InspectionTree tree = view.getTree();
        TreePath[] selectionPath = tree.getSelectionPaths();
        List expandedPaths = TreeUtil.collectExpandedPaths((JTree)((Object)tree));
        ((DefaultTreeModel)tree.getModel()).reload();
        TreeUtil.restoreExpandedPaths((JTree)((Object)tree), (List)expandedPaths);
        tree.setSelectionPaths(selectionPath);
    }

    private void processEventFileOrDir(@NotNull PsiTreeChangeEvent event, boolean eagerEvaluateFiles) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/ui/InspectionViewPsiTreeChangeAdapter", "processEventFileOrDir"));
        }
        PsiFile file2 = event.getFile();
        if (file2 != null) {
            VirtualFile vFile = file2.getVirtualFile();
            if (vFile == null) {
                return;
            }
            this.invalidateFiles(vFile);
        } else {
            VirtualFile childFile;
            PsiElement child = event.getChild();
            if (child instanceof PsiFileSystemItem && (childFile = ((PsiFileSystemItem)child).getVirtualFile()) != null) {
                if (eagerEvaluateFiles) {
                    HashSet files = new HashSet();
                    VfsUtilCore.iterateChildrenRecursively((VirtualFile)childFile, (VirtualFileFilter)VirtualFileFilter.ALL, ((Set)files)::add);
                    this.invalidateFiles(files.toArray(new VirtualFile[files.size()]));
                } else {
                    this.invalidateFiles(childFile);
                }
            }
        }
    }

    private static void processNodesIfNeed(InspectionTreeNode node, Processor<InspectionTreeNode> processor2) {
        if (processor2.process((Object)node)) {
            int count = node.getChildCount();
            for (int i2 = 0; i2 < count; ++i2) {
                InspectionViewPsiTreeChangeAdapter.processNodesIfNeed((InspectionTreeNode)node.getChildAt(i2), processor2);
            }
        }
    }

    private void invalidateFiles(VirtualFile ... files) {
        for (VirtualFile file2 : files) {
            this.myUpdater.queue(new Update(file2){

                public void run() {
                }

                public boolean canEat(Update update) {
                    return false;
                }
            });
        }
    }
}

