/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.NullableNotNullDialog;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.nullable.NullableStuffInspectionBase;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.search.JavaNullMethodArgumentUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NullableStuffInspection
extends NullableStuffInspectionBase {
    @Override
    protected LocalQuickFix createNavigateToNullParameterUsagesFix(PsiParameter parameter) {
        return new NavigateToNullLiteralArguments(parameter);
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    public static class NavigateToNullLiteralArguments
    extends LocalQuickFixOnPsiElement {
        public NavigateToNullLiteralArguments(@NotNull PsiParameter element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/nullable/NullableStuffInspection$NavigateToNullLiteralArguments", "<init>"));
            }
            super((PsiElement)element);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspection$NavigateToNullLiteralArguments", "getText"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"nullable.stuff.inspection.navigate.null.argument.usages.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspection$NavigateToNullLiteralArguments", "getFamilyName"));
            }
            return string;
        }

        public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/nullable/NullableStuffInspection$NavigateToNullLiteralArguments", "invoke"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/nullable/NullableStuffInspection$NavigateToNullLiteralArguments", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInspection/nullable/NullableStuffInspection$NavigateToNullLiteralArguments", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInspection/nullable/NullableStuffInspection$NavigateToNullLiteralArguments", "invoke"));
            }
            PsiParameter p = (PsiParameter)startElement;
            final PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)p, PsiMethod.class);
            if (method2 == null) {
                return;
            }
            final int parameterIdx = ArrayUtil.find((Object[])method2.getParameterList().getParameters(), (Object)p);
            if (parameterIdx < 0) {
                return;
            }
            UsageViewPresentation presentation = new UsageViewPresentation();
            String title = InspectionsBundle.message((String)"nullable.stuff.inspection.navigate.null.argument.usages.view.name", (Object[])new Object[]{p.getName()});
            presentation.setUsagesString(title);
            presentation.setTabName(title);
            presentation.setTabText(title);
            UsageViewManager.getInstance((Project)project2).searchAndShowUsages(new UsageTarget[]{new PsiElement2UsageTargetAdapter((PsiElement)method2.getParameterList().getParameters()[parameterIdx])}, () -> new UsageSearcher(){

                public void generate(@NotNull Processor<Usage> processor2) {
                    if (processor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/nullable/NullableStuffInspection$NavigateToNullLiteralArguments$1", "generate"));
                    }
                    ReadAction.run(() -> {
                        if (processor2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/nullable/NullableStuffInspection$NavigateToNullLiteralArguments$1", "lambda$generate$1"));
                        }
                        JavaNullMethodArgumentUtil.searchNullArgument(method2, parameterIdx, (Processor<PsiExpression>)((Processor)arg -> {
                            if (processor2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/nullable/NullableStuffInspection$NavigateToNullLiteralArguments$1", "lambda$null$0"));
                            }
                            return processor2.process((Object)new UsageInfo2UsageAdapter(new UsageInfo((PsiElement)arg)));
                        }));
                    });
                }
            }, false, false, presentation, null);
        }
    }

    private class OptionsPanel
    extends JPanel {
        private JCheckBox myBreakingOverriding;
        private JCheckBox myNAMethodOverridesNN;
        private JPanel myPanel;
        private JCheckBox myReportNotAnnotatedGetter;
        private JButton myConfigureAnnotationsButton;
        private JCheckBox myIgnoreExternalSuperNotNull;
        private JCheckBox myNNParameterOverridesNA;
        private JCheckBox myRequireNNFieldsInitialized;
        private JBCheckBox myReportNullLiteralsPassedNotNullParameter;

        private OptionsPanel() {
            super(new BorderLayout());
            this.$$$setupUI$$$();
            this.add((Component)this.myPanel, "Center");
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsPanel.this.apply();
                }
            };
            this.myNAMethodOverridesNN.addActionListener(actionListener);
            this.myBreakingOverriding.addActionListener(actionListener);
            this.myNNParameterOverridesNA.addActionListener(actionListener);
            this.myReportNotAnnotatedGetter.addActionListener(actionListener);
            this.myIgnoreExternalSuperNotNull.addActionListener(actionListener);
            this.myRequireNNFieldsInitialized.addActionListener(actionListener);
            this.myReportNullLiteralsPassedNotNullParameter.addActionListener(actionListener);
            this.myConfigureAnnotationsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)OptionsPanel.this));
                    if (project2 == null) {
                        project2 = ProjectManager.getInstance().getDefaultProject();
                    }
                    NullableNotNullDialog dialog2 = new NullableNotNullDialog(project2);
                    dialog2.show();
                }
            });
            this.reset();
        }

        private void reset() {
            this.myBreakingOverriding.setSelected(NullableStuffInspection.this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE);
            this.myNAMethodOverridesNN.setSelected(NullableStuffInspection.this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL);
            this.myReportNotAnnotatedGetter.setSelected(NullableStuffInspection.this.REPORT_NOT_ANNOTATED_GETTER);
            this.myIgnoreExternalSuperNotNull.setSelected(NullableStuffInspection.this.IGNORE_EXTERNAL_SUPER_NOTNULL);
            this.myNNParameterOverridesNA.setSelected(NullableStuffInspection.this.REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED);
            this.myRequireNNFieldsInitialized.setSelected(NullableStuffInspection.this.REQUIRE_NOTNULL_FIELDS_INITIALIZED);
            this.myReportNullLiteralsPassedNotNullParameter.setSelected(NullableStuffInspection.this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER);
            this.myIgnoreExternalSuperNotNull.setEnabled(this.myNAMethodOverridesNN.isSelected());
        }

        private void apply() {
            NullableStuffInspection.this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL = this.myNAMethodOverridesNN.isSelected();
            NullableStuffInspection.this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE = this.myBreakingOverriding.isSelected();
            NullableStuffInspection.this.REPORT_NOT_ANNOTATED_GETTER = this.myReportNotAnnotatedGetter.isSelected();
            NullableStuffInspection.this.IGNORE_EXTERNAL_SUPER_NOTNULL = this.myIgnoreExternalSuperNotNull.isSelected();
            NullableStuffInspection.this.REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED = this.myNNParameterOverridesNA.isSelected();
            NullableStuffInspection.this.REQUIRE_NOTNULL_FIELDS_INITIALIZED = this.myRequireNNFieldsInitialized.isSelected();
            NullableStuffInspection.this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER = this.myReportNullLiteralsPassedNotNullParameter.isSelected();
            NullableStuffInspection.this.REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS = NullableStuffInspection.this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL;
            this.myIgnoreExternalSuperNotNull.setEnabled(this.myNAMethodOverridesNN.isSelected());
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBCheckBox jBCheckBox;
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JButton jButton;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JCheckBox jCheckBox6;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myReportNotAnnotatedGetter = jCheckBox6 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.nullable.problems.not.annotated.getters.for.annotated.fields"));
            jPanel.add((Component)jCheckBox6, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myBreakingOverriding = jCheckBox5 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.nullable.problems.method.overrides.notnull.option"));
            jPanel.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myNAMethodOverridesNN = jCheckBox4 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.nullable.problems.method.overrides.option"));
            jPanel.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myConfigureAnnotationsButton = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/InspectionsBundle").getString("configure.annotations.option"));
            jPanel.add((Component)jButton, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myIgnoreExternalSuperNotNull = jCheckBox3 = new JCheckBox();
            jCheckBox3.setText("Ignore external @NotNull");
            jCheckBox3.setMnemonic('I');
            jCheckBox3.setDisplayedMnemonicIndex(0);
            jPanel.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
            this.myNNParameterOverridesNA = jCheckBox2 = new JCheckBox();
            jCheckBox2.setText("Report @NotNull parameters overriding non-annotated");
            jCheckBox2.setMnemonic('P');
            jCheckBox2.setDisplayedMnemonicIndex(16);
            jPanel.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myRequireNNFieldsInitialized = jCheckBox = new JCheckBox();
            jCheckBox.setText("Require @NotNull fields to be initialized explicitly");
            jPanel.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myReportNullLiteralsPassedNotNullParameter = jBCheckBox = new JBCheckBox();
            jBCheckBox.setText("Report @NotNull parameters with null-literal argument usages");
            jPanel.add((Component)jBCheckBox, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) == '&') {
                    if (++j == string.length()) break;
                    if (!bl && string.charAt(j) != '&') {
                        bl = true;
                        c = string.charAt(j);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(j));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

