/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReplaceConditionalMapPutFix
implements LocalQuickFix {
    private static final String COMPUTE_IF_ABSENT_METHOD = "computeIfAbsent";
    private static final String PUT_IF_ABSENT_METHOD = "putIfAbsent";
    private final SmartPsiElementPointer<PsiMethodCallExpression> myPutExpressionPointer;
    private final String myMethodName;

    public ReplaceConditionalMapPutFix(PsiMethodCallExpression putExpression, boolean useComputeIfAbsent) {
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)putExpression.getProject());
        this.myPutExpressionPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)putExpression);
        this.myMethodName = useComputeIfAbsent ? COMPUTE_IF_ABSENT_METHOD : PUT_IF_ABSENT_METHOD;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/java18api/ReplaceConditionalMapPutFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/java18api/ReplaceConditionalMapPutFix", "applyFix"));
        }
        PsiElement conditionalOperator = descriptor.getPsiElement();
        if (conditionalOperator == null) {
            return;
        }
        ConditionalOperatorHelper operatorHelper = ReplaceConditionalMapPutFix.getHelper(conditionalOperator);
        PsiMethodCallExpression putExpression = (PsiMethodCallExpression)this.myPutExpressionPointer.getElement();
        if (putExpression == null) {
            return;
        }
        PsiElement putContainingBranch = null;
        for (PsiElement branch : operatorHelper.getBranches(conditionalOperator)) {
            if (branch == null || !PsiTreeUtil.isAncestor((PsiElement)branch, (PsiElement)putExpression, (boolean)false)) continue;
            putContainingBranch = branch;
            break;
        }
        if (putContainingBranch == null) {
            return;
        }
        PsiExpression[] arguments = putExpression.getArgumentList().getExpressions();
        PsiElement qualifier = putExpression.getMethodExpression().getQualifier();
        if (qualifier == null) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(conditionalOperator)) {
            return;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiElement putContainingElement = operatorHelper.getPutContainingElement((PsiElement)putExpression);
        Couple<String> boundText = ReplaceConditionalMapPutFix.getBoundText(putContainingElement, (PsiElement)putExpression);
        String valueArgument = putExpression.getArgumentList().getExpressions()[1].getText();
        if (this.myMethodName.equals(COMPUTE_IF_ABSENT_METHOD)) {
            String varName = JavaCodeStyleManager.getInstance((Project)project2).suggestUniqueVariableName("k", (PsiElement)putExpression, true);
            valueArgument = varName + " -> " + valueArgument;
        }
        PsiStatement newStatement = elementFactory.createStatementFromText((String)boundText.getFirst() + qualifier.getText() + "." + this.myMethodName + "(" + arguments[0].getText() + "," + valueArgument + ")" + (String)boundText.getSecond(), conditionalOperator);
        conditionalOperator.replace((PsiElement)newStatement);
    }

    private static Couple<String> getBoundText(@NotNull PsiElement parent, @NotNull PsiElement child) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/codeInspection/java18api/ReplaceConditionalMapPutFix", "getBoundText"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/codeInspection/java18api/ReplaceConditionalMapPutFix", "getBoundText"));
        }
        TextRange childRange = child.getTextRange();
        int parentStartOffset = parent.getTextRange().getStartOffset();
        String parentText = parent.getText();
        return Couple.of((Object)parentText.substring(0, childRange.getStartOffset() - parentStartOffset), (Object)parentText.substring(childRange.getEndOffset() - parentStartOffset));
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("java.8.collections.api.inspection.fix.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/ReplaceConditionalMapPutFix", "getFamilyName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = QuickFixBundle.message("java.8.collections.api.inspection.fix.text", this.myMethodName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/ReplaceConditionalMapPutFix", "getName"));
        }
        return string;
    }

    private static ConditionalOperatorHelper getHelper(PsiElement element) {
        return element instanceof PsiConditionalExpression ? new ConditionalExpressionHelper() : new IfStatementHelper();
    }

    private static class IfStatementHelper
    implements ConditionalOperatorHelper {
        private IfStatementHelper() {
        }

        @Override
        @NotNull
        public PsiElement[] getBranches(PsiElement element) {
            PsiIfStatement ifStatement = (PsiIfStatement)element;
            PsiElement[] psiElementArray = new PsiElement[]{ifStatement.getThenBranch(), ifStatement.getElseBranch()};
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/ReplaceConditionalMapPutFix$IfStatementHelper", "getBranches"));
            }
            return psiElementArray;
        }

        @Override
        @NotNull
        public PsiElement getPutContainingElement(PsiElement putElement) {
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)putElement, PsiStatement.class);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/ReplaceConditionalMapPutFix$IfStatementHelper", "getPutContainingElement"));
            }
            return psiElement;
        }
    }

    private static class ConditionalExpressionHelper
    implements ConditionalOperatorHelper {
        private ConditionalExpressionHelper() {
        }

        @Override
        @NotNull
        public PsiElement[] getBranches(PsiElement element) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
            PsiElement[] psiElementArray = new PsiElement[]{conditionalExpression.getThenExpression(), conditionalExpression.getElseExpression()};
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/ReplaceConditionalMapPutFix$ConditionalExpressionHelper", "getBranches"));
            }
            return psiElementArray;
        }

        @Override
        @NotNull
        public PsiElement getPutContainingElement(PsiElement putElement) {
            for (PsiElement element : this.getBranches(PsiTreeUtil.getParentOfType((PsiElement)putElement, PsiConditionalExpression.class))) {
                if (!PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)putElement, (boolean)false)) continue;
                PsiElement psiElement = element;
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/ReplaceConditionalMapPutFix$ConditionalExpressionHelper", "getPutContainingElement"));
                }
                return psiElement;
            }
            throw new AssertionError();
        }
    }

    static interface ConditionalOperatorHelper {
        @NotNull
        public PsiElement[] getBranches(PsiElement var1);

        @NotNull
        public PsiElement getPutContainingElement(PsiElement var1);
    }
}

