/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java15api;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.FileCheckingInspection;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import gnu.trove.THashSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java15APIUsageInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    public static final String SHORT_NAME = "Since15";
    public static final ExtensionPointName<FileCheckingInspection> EP_NAME = ExtensionPointName.create((String)"com.intellij.java15InspectionTool");
    private static final String EFFECTIVE_LL = "effectiveLL";
    private static final Map<LanguageLevel, Reference<Set<String>>> ourForbiddenAPI = ContainerUtil.newEnumMap(LanguageLevel.class);
    private static final Set<String> ourIgnored16ClassesAPI = new THashSet(10);
    private static final Map<LanguageLevel, String> ourPresentableShortMessage = ContainerUtil.newEnumMap(LanguageLevel.class);
    private static final LanguageLevel ourHighestKnownLanguage = LanguageLevel.JDK_1_9;
    private static final Set<String> ourGenerifiedClasses;
    private static final Set<String> ourDefaultMethods;
    protected LanguageLevel myEffectiveLanguageLevel;

    @Nullable
    private static Set<String> getForbiddenApi(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInspection/java15api/Java15APIUsageInspectionBase", "getForbiddenApi"));
        }
        if (!ourPresentableShortMessage.containsKey(languageLevel)) {
            return null;
        }
        Reference<Set<String>> ref = ourForbiddenAPI.get(languageLevel);
        Set result2 = (Set)SoftReference.dereference(ref);
        if (result2 == null) {
            result2 = new THashSet(1000);
            Java15APIUsageInspectionBase.loadForbiddenApi("api" + Java15APIUsageInspectionBase.getShortName(languageLevel) + ".txt", result2);
            ourForbiddenAPI.put(languageLevel, (Reference<Set<String>>)new SoftReference((Object)result2));
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadForbiddenApi(String fileName, Set<String> set2) {
        URL resource = Java15APIUsageInspectionBase.class.getResource(fileName);
        if (resource == null) {
            Logger.getInstance(Java15APIUsageInspectionBase.class).warn("not found: " + fileName);
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), CharsetToolkit.UTF8_CHARSET));){
            set2.addAll(FileUtil.loadLines((BufferedReader)reader));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java15api/Java15APIUsageInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.1.5.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java15api/Java15APIUsageInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java15api/Java15APIUsageInspectionBase", "getShortName"));
        }
        return SHORT_NAME;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java15api/Java15APIUsageInspectionBase", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/java15api/Java15APIUsageInspectionBase", "readSettings"));
        }
        Element element = node.getChild(EFFECTIVE_LL);
        if (element != null) {
            this.myEffectiveLanguageLevel = LanguageLevel.valueOf((String)element.getAttributeValue("value"));
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/java15api/Java15APIUsageInspectionBase", "writeSettings"));
        }
        if (this.myEffectiveLanguageLevel != null) {
            Element llElement = new Element(EFFECTIVE_LL);
            llElement.setAttribute("value", this.myEffectiveLanguageLevel.toString());
            node.addContent(llElement);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java15api/Java15APIUsageInspectionBase", "buildVisitor"));
        }
        MyVisitor myVisitor = new MyVisitor(holder, isOnTheFly);
        if (myVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java15api/Java15APIUsageInspectionBase", "buildVisitor"));
        }
        return myVisitor;
    }

    private static boolean isInProject(PsiElement elt) {
        return elt.getManager().isInProject(elt);
    }

    public static String getShortName(LanguageLevel languageLevel) {
        return ourPresentableShortMessage.get(languageLevel);
    }

    private static String getJdkName(LanguageLevel languageLevel) {
        String presentableText = languageLevel.getPresentableText();
        return presentableText.substring(0, presentableText.indexOf(" "));
    }

    public static boolean isForbiddenApiUsage(@NotNull PsiMember member, @NotNull LanguageLevel languageLevel) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInspection/java15api/Java15APIUsageInspectionBase", "isForbiddenApiUsage"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInspection/java15api/Java15APIUsageInspectionBase", "isForbiddenApiUsage"));
        }
        if (member instanceof PsiAnonymousClass) {
            return false;
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass instanceof PsiAnonymousClass) {
            return false;
        }
        if (member instanceof PsiClass && !(member.getParent() instanceof PsiClass) && !(member.getParent() instanceof PsiFile)) {
            return false;
        }
        return Java15APIUsageInspectionBase.isForbiddenSignature(member, languageLevel) || containingClass != null && Java15APIUsageInspectionBase.isForbiddenApiUsage((PsiMember)containingClass, languageLevel);
    }

    private static boolean isForbiddenSignature(@NotNull PsiMember member, @NotNull LanguageLevel languageLevel) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInspection/java15api/Java15APIUsageInspectionBase", "isForbiddenSignature"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInspection/java15api/Java15APIUsageInspectionBase", "isForbiddenSignature"));
        }
        Set<String> forbiddenApi = Java15APIUsageInspectionBase.getForbiddenApi(languageLevel);
        String signature = Java15APIUsageInspectionBase.getSignature(member);
        return forbiddenApi != null && signature != null && Java15APIUsageInspectionBase.isForbiddenSignature(signature, languageLevel, forbiddenApi);
    }

    private static boolean isForbiddenSignature(@NotNull String signature, @NotNull LanguageLevel languageLevel, @NotNull Set<String> forbiddenApi) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/codeInspection/java15api/Java15APIUsageInspectionBase", "isForbiddenSignature"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInspection/java15api/Java15APIUsageInspectionBase", "isForbiddenSignature"));
        }
        if (forbiddenApi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forbiddenApi", "com/intellij/codeInspection/java15api/Java15APIUsageInspectionBase", "isForbiddenSignature"));
        }
        if (forbiddenApi.contains(signature)) {
            return true;
        }
        if (languageLevel.compareTo((Enum)ourHighestKnownLanguage) == 0) {
            return false;
        }
        LanguageLevel nextLanguageLevel = LanguageLevel.values()[languageLevel.ordinal() + 1];
        Set<String> nextForbiddenApi = Java15APIUsageInspectionBase.getForbiddenApi(nextLanguageLevel);
        return nextForbiddenApi != null && Java15APIUsageInspectionBase.isForbiddenSignature(signature, nextLanguageLevel, nextForbiddenApi);
    }

    @Nullable
    public static String getSignature(@Nullable PsiMember member) {
        if (member instanceof PsiClass) {
            return ((PsiClass)member).getQualifiedName();
        }
        if (member instanceof PsiField) {
            String containingClass = Java15APIUsageInspectionBase.getSignature((PsiMember)member.getContainingClass());
            return containingClass == null ? null : containingClass + "#" + member.getName();
        }
        if (member instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)member;
            String containingClass = Java15APIUsageInspectionBase.getSignature((PsiMember)member.getContainingClass());
            if (containingClass == null) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(containingClass);
            buf.append('#');
            buf.append(method2.getName());
            buf.append('(');
            for (PsiType type : method2.getSignature(PsiSubstitutor.EMPTY).getParameterTypes()) {
                buf.append(type.getCanonicalText());
                buf.append(";");
            }
            buf.append(')');
            return buf.toString();
        }
        return null;
    }

    static {
        ourPresentableShortMessage.put(LanguageLevel.JDK_1_3, "1.4");
        ourPresentableShortMessage.put(LanguageLevel.JDK_1_4, "1.5");
        ourPresentableShortMessage.put(LanguageLevel.JDK_1_5, "1.6");
        ourPresentableShortMessage.put(LanguageLevel.JDK_1_6, "1.7");
        ourPresentableShortMessage.put(LanguageLevel.JDK_1_7, "1.8");
        ourPresentableShortMessage.put(LanguageLevel.JDK_1_8, "1.9");
        Java15APIUsageInspectionBase.loadForbiddenApi("ignore16List.txt", ourIgnored16ClassesAPI);
        ourGenerifiedClasses = new HashSet();
        ourGenerifiedClasses.add("javax.swing.JComboBox");
        ourGenerifiedClasses.add("javax.swing.ListModel");
        ourGenerifiedClasses.add("javax.swing.JList");
        ourDefaultMethods = new HashSet();
        ourDefaultMethods.add("java.util.Iterator#remove()");
    }

    private class MyVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myOnTheFly;
        private final ExtensionPoint<FileCheckingInspection> point = Extensions.getRootArea().getExtensionPoint(EP_NAME);

        public MyVisitor(ProblemsHolder holder, boolean onTheFly) {
            this.myHolder = holder;
            this.myOnTheFly = onTheFly;
        }

        public void visitDocComment(PsiDocComment comment) {
        }

        public void visitClass(PsiClass aClass) {
            if (!aClass.hasModifierProperty("abstract") && !(aClass instanceof PsiTypeParameter)) {
                JavaSdkVersion version;
                LanguageLevel effectiveLanguageLevel;
                Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
                LanguageLevel languageLevel = effectiveLanguageLevel = module2 != null ? this.getEffectiveLanguageLevel(module2) : null;
                if (effectiveLanguageLevel != null && !effectiveLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (version = JavaVersionService.getInstance().getJavaSdkVersion((PsiElement)aClass)) != null && version.isAtLeast(JavaSdkVersion.JDK_1_8)) {
                    ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
                    for (HierarchicalMethodSignature methodSignature : aClass.getVisibleSignatures()) {
                        PsiMethod method2 = methodSignature.getMethod();
                        if (!ourDefaultMethods.contains(Java15APIUsageInspectionBase.getSignature((PsiMember)method2))) continue;
                        methods.add(method2);
                    }
                    if (!methods.isEmpty()) {
                        PsiIdentifier element2Highlight = aClass.getNameIdentifier();
                        if (element2Highlight == null) {
                            element2Highlight = aClass;
                        }
                        this.myHolder.registerProblem((PsiElement)element2Highlight, methods.size() == 1 ? InspectionsBundle.message((String)"inspection.1.8.problem.single.descriptor", (Object[])new Object[]{((PsiMethod)methods.get(0)).getName(), Java15APIUsageInspectionBase.getJdkName(effectiveLanguageLevel)}) : InspectionsBundle.message((String)"inspection.1.8.problem.descriptor", (Object[])new Object[]{methods.size(), Java15APIUsageInspectionBase.getJdkName(effectiveLanguageLevel)}), new LocalQuickFix[]{QuickFixFactory.getInstance().createImplementMethodsFix(aClass)});
                    }
                }
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            Module module2;
            super.visitReferenceElement(reference);
            PsiElement resolved = reference.resolve();
            if (resolved instanceof PsiCompiledElement && resolved instanceof PsiMember && (module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)reference.getElement())) != null) {
                PsiReferenceParameterList parameterList;
                LanguageLevel languageLevel = this.getEffectiveLanguageLevel(module2);
                if (Java15APIUsageInspectionBase.isForbiddenApiUsage((PsiMember)resolved, languageLevel)) {
                    PsiClass psiClass = null;
                    PsiElement qualifier = reference.getQualifier();
                    if (qualifier != null) {
                        if (qualifier instanceof PsiExpression) {
                            psiClass = PsiUtil.resolveClassInType((PsiType)((PsiExpression)qualifier).getType());
                        }
                    } else {
                        psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiClass.class);
                    }
                    if (psiClass != null) {
                        if (this.isIgnored(psiClass)) {
                            return;
                        }
                        for (PsiClass superClass : psiClass.getSupers()) {
                            if (!this.isIgnored(superClass)) continue;
                            return;
                        }
                    }
                    this.registerError(reference, languageLevel);
                } else if (resolved instanceof PsiClass && Java15APIUsageInspectionBase.isInProject((PsiElement)reference) && !languageLevel.isAtLeast(LanguageLevel.JDK_1_7) && (parameterList = reference.getParameterList()) != null && parameterList.getTypeParameterElements().length > 0) {
                    for (String generifiedClass : ourGenerifiedClasses) {
                        if (!InheritanceUtil.isInheritor((PsiClass)((PsiClass)resolved), (String)generifiedClass) || this.isRawInheritance(generifiedClass, (PsiClass)resolved, (Set<PsiClass>)new HashSet())) continue;
                        String message = InspectionsBundle.message((String)"inspection.1.7.problem.descriptor", (Object[])new Object[]{Java15APIUsageInspectionBase.getJdkName(languageLevel)});
                        this.myHolder.registerProblem((PsiElement)reference, message, new LocalQuickFix[0]);
                        break;
                    }
                }
            }
        }

        private boolean isRawInheritance(String generifiedClassQName, PsiClass currentClass, Set<PsiClass> visited) {
            for (PsiClassType classType : currentClass.getSuperTypes()) {
                if (classType.isRaw()) {
                    return true;
                }
                PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
                PsiClass superClass = resolveResult.getElement();
                if (!visited.add(superClass) || !InheritanceUtil.isInheritor((PsiClass)superClass, (String)generifiedClassQName) || !this.isRawInheritance(generifiedClassQName, superClass, visited)) continue;
                return true;
            }
            return false;
        }

        private boolean isIgnored(PsiClass psiClass) {
            String qualifiedName = psiClass.getQualifiedName();
            return qualifiedName != null && ourIgnored16ClassesAPI.contains(qualifiedName);
        }

        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            PsiMethod constructor = expression.resolveConstructor();
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)expression);
            if (module2 != null) {
                LanguageLevel languageLevel = this.getEffectiveLanguageLevel(module2);
                if (constructor instanceof PsiCompiledElement && Java15APIUsageInspectionBase.isForbiddenApiUsage((PsiMember)constructor, languageLevel)) {
                    this.registerError(expression.getClassReference(), languageLevel);
                }
            }
        }

        public void visitMethod(PsiMethod method2) {
            Module module2;
            super.visitMethod(method2);
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method2, (String[])new String[]{"java.lang.Override"});
            if (annotation != null && (module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)annotation)) != null) {
                PsiMethod[] methods;
                LanguageLevel languageLevel = this.getEffectiveLanguageLevel(module2);
                for (PsiMethod superMethod : methods = method2.findSuperMethods()) {
                    if (superMethod instanceof PsiCompiledElement) {
                        if (Java15APIUsageInspectionBase.isForbiddenApiUsage((PsiMember)superMethod, languageLevel)) continue;
                        return;
                    }
                    return;
                }
                if (methods.length > 0) {
                    this.registerError(annotation.getNameReferenceElement(), languageLevel);
                }
            }
        }

        private LanguageLevel getEffectiveLanguageLevel(Module module2) {
            if (Java15APIUsageInspectionBase.this.myEffectiveLanguageLevel != null) {
                return Java15APIUsageInspectionBase.this.myEffectiveLanguageLevel;
            }
            return EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module2);
        }

        private void registerError(PsiJavaCodeReferenceElement reference, LanguageLevel api) {
            if (reference != null && Java15APIUsageInspectionBase.isInProject((PsiElement)reference)) {
                this.myHolder.registerProblem((PsiElement)reference, InspectionsBundle.message((String)"inspection.1.5.problem.descriptor", (Object[])new Object[]{Java15APIUsageInspectionBase.getShortName(api)}), new LocalQuickFix[0]);
            }
        }

        public void visitFile(PsiFile file2) {
            for (FileCheckingInspection inspection : (FileCheckingInspection[])this.point.getExtensions()) {
                ProblemDescriptor[] descriptors = inspection.checkFile(file2, InspectionManager.getInstance((Project)file2.getProject()), this.myOnTheFly);
                if (descriptors == null) continue;
                for (ProblemDescriptor descriptor : descriptors) {
                    this.myHolder.registerProblem(descriptor);
                }
            }
        }
    }
}

