/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.codeInspection.ex.InspectionElementsMergerBase;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.NewInspectionProfile;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionProfileImpl
extends NewInspectionProfile {
    @NonNls
    static final String INSPECTION_TOOL_TAG = "inspection_tool";
    @NonNls
    static final String CLASS_TAG = "class";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionProfileImpl");
    @NonNls
    private static final String VALID_VERSION = "1.0";
    @NonNls
    private static final String VERSION_TAG = "version";
    @NonNls
    private static final String USED_LEVELS = "used_levels";
    public static final String DEFAULT_PROFILE_NAME = "Default";
    public static boolean INIT_INSPECTIONS = false;
    private final InspectionToolRegistrar myRegistrar;
    @NotNull
    private final Map<String, Element> myUninitializedSettings;
    protected InspectionProfileImpl mySource;
    private Map<String, ToolsImpl> myTools;
    private volatile Set<String> myChangedToolNames;
    @Attribute(value="is_locked")
    private boolean myLockedProfile;
    private final InspectionProfileImpl myBaseProfile;
    private volatile String myToolShortName;
    private String[] myScopesOrder;
    private String myDescription;
    private boolean myModified;
    private volatile boolean myInitialized;
    private final Object myLock;
    private SchemeDataHolder<? super InspectionProfileImpl> myDataHolder;

    InspectionProfileImpl(@NotNull InspectionProfileImpl inspectionProfile) {
        if (inspectionProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProfile", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        this(inspectionProfile.getName(), inspectionProfile.myRegistrar, inspectionProfile.getProfileManager(), inspectionProfile.myBaseProfile, null);
        this.myUninitializedSettings.putAll(inspectionProfile.myUninitializedSettings);
        this.setProjectLevel(inspectionProfile.isProjectLevel());
        this.myLockedProfile = inspectionProfile.myLockedProfile;
        this.mySource = inspectionProfile;
        this.copyFrom(inspectionProfile);
    }

    public InspectionProfileImpl(@NotNull String profileName, @NotNull InspectionToolRegistrar registrar, @NotNull BaseInspectionProfileManager profileManager) {
        if (profileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        if (profileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileManager", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        this(profileName, registrar, profileManager, InspectionProfileImpl.getBaseProfile(), null);
    }

    public InspectionProfileImpl(@NotNull @NonNls String profileName) {
        if (profileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        this(profileName, InspectionToolRegistrar.getInstance());
    }

    public InspectionProfileImpl(@NotNull String profileName, @NotNull InspectionToolRegistrar registrar) {
        if (profileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        this(profileName, registrar, (BaseInspectionProfileManager)InspectionProfileManager.getInstance(), null, null);
    }

    public InspectionProfileImpl(@NotNull String profileName, @NotNull InspectionToolRegistrar registrar, @Nullable InspectionProfileImpl baseProfile) {
        if (profileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        this(profileName, registrar, (BaseInspectionProfileManager)InspectionProfileManager.getInstance(), baseProfile, null);
    }

    public InspectionProfileImpl(@NotNull String profileName, @NotNull InspectionToolRegistrar registrar, @NotNull BaseInspectionProfileManager profileManager, @Nullable InspectionProfileImpl baseProfile, @Nullable SchemeDataHolder<? super InspectionProfileImpl> dataHolder) {
        if (profileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        if (profileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileManager", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        super(profileName, profileManager);
        this.myUninitializedSettings = new TreeMap<String, Element>();
        this.myTools = new THashMap();
        this.myToolShortName = null;
        this.myLock = new Object();
        this.myRegistrar = registrar;
        this.myBaseProfile = baseProfile;
        this.myDataHolder = dataHolder;
    }

    public InspectionProfileImpl(@NotNull String profileName, @NotNull InspectionToolRegistrar registrar, @NotNull BaseInspectionProfileManager profileManager, @Nullable SchemeDataHolder<? super InspectionProfileImpl> dataHolder) {
        if (profileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        if (profileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileManager", "com/intellij/codeInspection/ex/InspectionProfileImpl", "<init>"));
        }
        this(profileName, registrar, profileManager, InspectionProfileImpl.getBaseProfile(), dataHolder);
    }

    @NotNull
    public static InspectionProfileImpl createSimple(@NotNull String name, @NotNull Project project2, final @NotNull List<InspectionToolWrapper> toolWrappers) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/ex/InspectionProfileImpl", "createSimple"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionProfileImpl", "createSimple"));
        }
        if (toolWrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrappers", "com/intellij/codeInspection/ex/InspectionProfileImpl", "createSimple"));
        }
        InspectionProfileImpl profile = new InspectionProfileImpl(name, new InspectionToolRegistrar(){

            @Override
            @NotNull
            public List<InspectionToolWrapper> createTools() {
                List list = toolWrappers;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl$1", "createTools"));
                }
                return list;
            }
        }, (BaseInspectionProfileManager)InspectionProfileManager.getInstance());
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            profile.enableTool(toolWrapper.getShortName(), project2);
        }
        InspectionProfileImpl inspectionProfileImpl = profile;
        if (inspectionProfileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "createSimple"));
        }
        return inspectionProfileImpl;
    }

    private static boolean toolSettingsAreEqual(@NotNull String toolName, @NotNull InspectionProfileImpl profile1, @NotNull InspectionProfileImpl profile2) {
        if (toolName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "toolSettingsAreEqual"));
        }
        if (profile1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile1", "com/intellij/codeInspection/ex/InspectionProfileImpl", "toolSettingsAreEqual"));
        }
        if (profile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile2", "com/intellij/codeInspection/ex/InspectionProfileImpl", "toolSettingsAreEqual"));
        }
        Tools toolList1 = profile1.myTools.get(toolName);
        Tools toolList2 = profile2.myTools.get(toolName);
        return Comparing.equal((Object)toolList1, (Object)toolList2);
    }

    @NotNull
    private static InspectionToolWrapper copyToolSettings(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionProfileImpl", "copyToolSettings"));
        }
        InspectionToolWrapper inspectionTool = toolWrapper.createCopy();
        if (toolWrapper.isInitialized()) {
            Element config = new Element("config");
            toolWrapper.getTool().writeSettings(config);
            inspectionTool.getTool().readSettings(config);
        }
        InspectionToolWrapper inspectionToolWrapper = inspectionTool;
        if (inspectionToolWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "copyToolSettings"));
        }
        return inspectionToolWrapper;
    }

    @NotNull
    public static InspectionProfileImpl getBaseProfile() {
        InspectionProfileImpl inspectionProfileImpl = InspectionProfileImplHolder.DEFAULT_PROFILE;
        if (inspectionProfileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getBaseProfile"));
        }
        return inspectionProfileImpl;
    }

    public void setModified(boolean modified) {
        this.myModified = modified;
    }

    public InspectionProfileImpl getParentProfile() {
        return this.mySource;
    }

    public boolean isChanged() {
        if (this.mySource != null && this.mySource.myLockedProfile != this.myLockedProfile) {
            return true;
        }
        return this.myModified;
    }

    public boolean isProperSetting(@NotNull String toolId) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/ex/InspectionProfileImpl", "isProperSetting"));
        }
        if (this.myBaseProfile != null) {
            Tools currentTools;
            ToolsImpl tools = this.myBaseProfile.getTools(toolId, null);
            return !Comparing.equal((Object)tools, (Object)(currentTools = (Tools)this.myTools.get(toolId)));
        }
        return false;
    }

    public void resetToBase(@Nullable Project project2) {
        this.initInspectionTools(project2);
        this.copyToolsConfigurations(this.myBaseProfile, project2);
        this.myChangedToolNames = null;
    }

    public void resetToEmpty(Project project2) {
        InspectionToolWrapper[] profileEntries;
        this.initInspectionTools(project2);
        for (InspectionToolWrapper toolWrapper : profileEntries = this.getInspectionTools(null)) {
            this.disableTool(toolWrapper.getShortName(), project2);
        }
    }

    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey inspectionToolKey, PsiElement element) {
        HighlightDisplayLevel level;
        if (inspectionToolKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionToolKey", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getErrorLevel"));
        }
        Project project2 = element == null ? null : element.getProject();
        ToolsImpl tools = this.getTools(inspectionToolKey.toString(), project2);
        HighlightDisplayLevel highlightDisplayLevel = level = tools != null ? tools.getLevel(element) : HighlightDisplayLevel.WARNING;
        if (!this.getProfileManager().getOwnSeverityRegistrar().isSeverityValid(level.getSeverity().getName())) {
            level = HighlightDisplayLevel.WARNING;
            this.setErrorLevel(inspectionToolKey, level, project2);
        }
        return level;
    }

    @Override
    public void readExternal(@NotNull Element element) {
        String version;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "readExternal"));
        }
        super.readExternal(element);
        Element highlightElement = element.getChild(USED_LEVELS);
        if (highlightElement != null) {
            this.getProfileManager().getOwnSeverityRegistrar().readExternal(highlightElement);
        }
        if ((version = element.getAttributeValue(VERSION_TAG)) == null || !version.equals(VALID_VERSION)) {
            InspectionToolWrapper[] tools = this.getInspectionTools(null);
            for (Element toolElement : element.getChildren(INSPECTION_TOOL_TAG)) {
                String toolClassName = toolElement.getAttributeValue(CLASS_TAG);
                String shortName = InspectionProfileImpl.convertToShortName(toolClassName, tools);
                if (shortName == null) continue;
                toolElement.setAttribute(CLASS_TAG, shortName);
                this.myUninitializedSettings.put(shortName, toolElement.clone());
            }
        } else {
            for (Element toolElement : element.getChildren(INSPECTION_TOOL_TAG)) {
                this.myUninitializedSettings.put(toolElement.getAttributeValue(CLASS_TAG), toolElement.clone());
            }
        }
    }

    @Nullable
    private static String convertToShortName(@Nullable String displayName, InspectionToolWrapper[] tools) {
        if (displayName == null) {
            return null;
        }
        for (InspectionToolWrapper tool : tools) {
            if (!displayName.equals(tool.getDisplayName())) continue;
            return tool.getShortName();
        }
        return null;
    }

    @NotNull
    public Set<HighlightSeverity> getUsedSeverities() {
        LOG.assertTrue(this.myInitialized);
        THashSet result2 = new THashSet();
        for (Tools tools : this.myTools.values()) {
            for (ScopeToolState state : tools.getTools()) {
                result2.add(state.getLevel().getSeverity());
            }
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getUsedSeverities"));
        }
        return tHashSet;
    }

    @Override
    @NotNull
    public Element writeScheme() {
        if (this.myDataHolder != null) {
            Element element = this.myDataHolder.read();
            if (element == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "writeScheme"));
            }
            return element;
        }
        Element element = super.writeScheme();
        if (this.isProjectLevel()) {
            element.setAttribute(VERSION_TAG, VALID_VERSION);
        }
        if (this.isProjectLevel() && ProjectKt.isDirectoryBased(((ProjectInspectionProfileManager)this.getProfileManager()).getProject())) {
            Element element2 = new Element("component").setAttribute("name", "InspectionProjectProfileManager").addContent(element);
            if (element2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "writeScheme"));
            }
            return element2;
        }
        Element element3 = element;
        if (element3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "writeScheme"));
        }
        return element3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "writeExternal"));
        }
        element.setAttribute(VERSION_TAG, VALID_VERSION);
        super.writeExternal(element);
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myInitialized) {
                for (Element el : this.myUninitializedSettings.values()) {
                    element.addContent(el.clone());
                }
                return;
            }
        }
        Set<String> changedToolNames = this.getChangedToolNames();
        if (changedToolNames == null) {
            return;
        }
        ArrayList<String> allToolNames = new ArrayList<String>(this.myTools.keySet());
        allToolNames.addAll(this.myUninitializedSettings.keySet());
        allToolNames.sort(null);
        for (String toolName : allToolNames) {
            Element toolElement = this.myUninitializedSettings.get(toolName);
            if (toolElement != null) {
                element.addContent(toolElement.clone());
                continue;
            }
            if (!this.myLockedProfile && !changedToolNames.contains(toolName)) {
                this.markSettingsMerged(toolName, element);
                continue;
            }
            ToolsImpl toolList = this.myTools.get(toolName);
            LOG.assertTrue(toolList != null);
            Element inspectionElement = new Element(INSPECTION_TOOL_TAG);
            inspectionElement.setAttribute(CLASS_TAG, toolName);
            try {
                toolList.writeExternal(inspectionElement);
                this.getPathMacroManager().collapsePaths(inspectionElement);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
                continue;
            }
            if (this.areSettingsMerged(toolName, inspectionElement)) continue;
            element.addContent(inspectionElement);
        }
    }

    private void markSettingsMerged(@NotNull String toolName, @NotNull Element element) {
        InspectionElementsMergerBase merger;
        if (toolName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "markSettingsMerged"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "markSettingsMerged"));
        }
        String mergedName = InspectionElementsMergerBase.getMergedMarkerName(toolName);
        if (!this.myUninitializedSettings.containsKey(mergedName) && (merger = InspectionProfileImpl.getMerger(toolName)) != null && merger.markSettingsMerged(this.myUninitializedSettings)) {
            element.addContent(new Element(INSPECTION_TOOL_TAG).setAttribute(CLASS_TAG, mergedName));
        }
    }

    private boolean areSettingsMerged(String toolName, Element inspectionElement) {
        InspectionElementsMergerBase merger = InspectionProfileImpl.getMerger(toolName);
        return merger != null && merger.areSettingsMerged(this.myUninitializedSettings, inspectionElement);
    }

    public void collectDependentInspections(@NotNull InspectionToolWrapper toolWrapper, @NotNull Set<InspectionToolWrapper> dependentEntries, Project project2) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionProfileImpl", "collectDependentInspections"));
        }
        if (dependentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependentEntries", "com/intellij/codeInspection/ex/InspectionProfileImpl", "collectDependentInspections"));
        }
        String mainToolId = toolWrapper.getMainToolId();
        if (mainToolId != null) {
            InspectionToolWrapper dependentEntryWrapper = this.getInspectionTool(mainToolId, project2);
            if (dependentEntryWrapper == null) {
                LOG.error("Can't find main tool: '" + mainToolId + "' which was specified in " + toolWrapper);
                return;
            }
            if (!dependentEntries.add(dependentEntryWrapper)) {
                this.collectDependentInspections(dependentEntryWrapper, dependentEntries, project2);
            }
        }
    }

    @Nullable
    public InspectionToolWrapper getInspectionTool(@NotNull String shortName, @Nullable PsiElement element) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getInspectionTool"));
        }
        ToolsImpl toolList = this.getTools(shortName, element == null ? null : element.getProject());
        return toolList == null ? null : toolList.getInspectionTool(element);
    }

    @Nullable
    public InspectionProfileEntry getUnwrappedTool(@NotNull String shortName, @NotNull PsiElement element) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getUnwrappedTool"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getUnwrappedTool"));
        }
        InspectionToolWrapper tool = this.getInspectionTool(shortName, element);
        return tool == null ? null : tool.getTool();
    }

    public <T extends InspectionProfileEntry> T getUnwrappedTool(@NotNull Key<T> shortNameKey, @NotNull PsiElement element) {
        if (shortNameKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortNameKey", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getUnwrappedTool"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getUnwrappedTool"));
        }
        return (T)this.getUnwrappedTool(shortNameKey.toString(), element);
    }

    public void modifyProfile(@NotNull Consumer<ModifiableModel> modelConsumer) {
        if (modelConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelConsumer", "com/intellij/codeInspection/ex/InspectionProfileImpl", "modifyProfile"));
        }
        InspectionProfileImpl model = this.getModifiableModel();
        modelConsumer.consume((Object)model);
        model.commit();
    }

    public <T extends InspectionProfileEntry> void modifyToolSettings(@NotNull Key<T> shortNameKey, @NotNull PsiElement psiElement, @NotNull Consumer<T> toolConsumer) {
        if (shortNameKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortNameKey", "com/intellij/codeInspection/ex/InspectionProfileImpl", "modifyToolSettings"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/ex/InspectionProfileImpl", "modifyToolSettings"));
        }
        if (toolConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolConsumer", "com/intellij/codeInspection/ex/InspectionProfileImpl", "modifyToolSettings"));
        }
        this.modifyProfile((Consumer<ModifiableModel>)((Consumer)model -> {
            if (shortNameKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortNameKey", "com/intellij/codeInspection/ex/InspectionProfileImpl", "lambda$modifyToolSettings$0"));
            }
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInspection/ex/InspectionProfileImpl", "lambda$modifyToolSettings$0"));
            }
            if (toolConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolConsumer", "com/intellij/codeInspection/ex/InspectionProfileImpl", "lambda$modifyToolSettings$0"));
            }
            InspectionProfileEntry tool = model.getUnwrappedTool(shortNameKey.toString(), psiElement);
            toolConsumer.consume((Object)tool);
        }));
    }

    @Nullable
    public InspectionToolWrapper getInspectionTool(@NotNull String shortName, Project project2) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getInspectionTool"));
        }
        ToolsImpl tools = this.getTools(shortName, project2);
        return tools != null ? tools.getTool() : null;
    }

    public InspectionToolWrapper getToolById(@NotNull String id, @NotNull PsiElement element) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getToolById"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getToolById"));
        }
        this.initInspectionTools(element.getProject());
        for (Tools tools : this.myTools.values()) {
            InspectionToolWrapper tool = tools.getInspectionTool(element);
            if (!id.equals(tool.getID())) continue;
            return tool;
        }
        return null;
    }

    @Nullable
    public List<InspectionToolWrapper> findToolsById(@NotNull String id, @NotNull PsiElement element) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInspection/ex/InspectionProfileImpl", "findToolsById"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "findToolsById"));
        }
        ArrayList<InspectionToolWrapper> result2 = null;
        this.initInspectionTools(element.getProject());
        for (Tools tools : this.myTools.values()) {
            InspectionToolWrapper tool = tools.getInspectionTool(element);
            if (!id.equals(tool.getID())) continue;
            if (result2 == null) {
                result2 = new ArrayList<InspectionToolWrapper>();
            }
            result2.add(tool);
        }
        return result2;
    }

    public void save() {
        InspectionProfileManager.getInstance().fireProfileChanged((InspectionProfile)this);
    }

    @Nullable
    public String getSingleTool() {
        return this.myToolShortName;
    }

    public void setSingleTool(@NotNull String toolShortName) {
        if (toolShortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolShortName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setSingleTool"));
        }
        this.myToolShortName = toolShortName;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getDisplayName"));
        }
        return string;
    }

    public void scopesChanged() {
        for (ScopeToolState toolState : this.getAllTools(null)) {
            toolState.scopesChanged();
        }
        InspectionProfileManager.getInstance().fireProfileChanged((InspectionProfile)this);
    }

    @Transient
    public boolean isProfileLocked() {
        return this.myLockedProfile;
    }

    public void lockProfile(boolean isLocked) {
        this.myLockedProfile = isLocked;
    }

    @NotNull
    public InspectionToolWrapper[] getInspectionTools(@Nullable PsiElement element) {
        this.initInspectionTools(element == null ? null : element.getProject());
        ArrayList<InspectionToolWrapper> result2 = new ArrayList<InspectionToolWrapper>();
        for (Tools tools : this.myTools.values()) {
            result2.add(tools.getInspectionTool(element));
        }
        InspectionToolWrapper[] inspectionToolWrapperArray = result2.toArray(new InspectionToolWrapper[result2.size()]);
        if (inspectionToolWrapperArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getInspectionTools"));
        }
        return inspectionToolWrapperArray;
    }

    @NotNull
    public List<Tools> getAllEnabledInspectionTools(Project project2) {
        this.initInspectionTools(project2);
        ArrayList<Tools> result2 = new ArrayList<Tools>();
        for (ToolsImpl toolList : this.myTools.values()) {
            if (!toolList.isEnabled()) continue;
            result2.add(toolList);
        }
        ArrayList<Tools> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getAllEnabledInspectionTools"));
        }
        return arrayList;
    }

    public void disableTool(@NotNull String toolId, @NotNull PsiElement element) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableTool"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableTool"));
        }
        this.getTools(toolId, element.getProject()).disableTool(element);
    }

    public void disableToolByDefault(@NotNull Collection<String> toolIds, @Nullable Project project2) {
        if (toolIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolIds", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableToolByDefault"));
        }
        for (String toolId : toolIds) {
            this.getTools(toolId, project2).setDefaultEnabled(false);
        }
    }

    @NotNull
    public ScopeToolState getToolDefaultState(@NotNull String toolId, @Nullable Project project2) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getToolDefaultState"));
        }
        ScopeToolState scopeToolState = this.getTools(toolId, project2).getDefaultState();
        if (scopeToolState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getToolDefaultState"));
        }
        return scopeToolState;
    }

    public void enableToolsByDefault(@NotNull List<String> toolIds, Project project2) {
        if (toolIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolIds", "com/intellij/codeInspection/ex/InspectionProfileImpl", "enableToolsByDefault"));
        }
        for (String toolId : toolIds) {
            this.getTools(toolId, project2).setDefaultEnabled(true);
        }
    }

    public boolean wasInitialized() {
        return this.myInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initInspectionTools(@Nullable Project project2) {
        if (this.myInitialized || ApplicationManager.getApplication().isUnitTestMode() && !INIT_INSPECTIONS) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myInitialized) {
                this.initialize(project2);
            }
        }
    }

    private void initialize(@Nullable Project project2) {
        List tools;
        SchemeDataHolder<? super InspectionProfileImpl> dataHolder = this.myDataHolder;
        if (dataHolder != null) {
            this.myDataHolder = null;
            Element element = dataHolder.read();
            if (element.getName().equals("component")) {
                element = element.getChild("profile");
            }
            assert (element != null);
            this.readExternal(element);
        }
        if (this.myBaseProfile != null) {
            this.myBaseProfile.initInspectionTools(project2);
        }
        try {
            tools = this.mySource == null ? this.myRegistrar.createTools() : ContainerUtil.map(this.mySource.getDefaultStates(project2), ScopeToolState::getTool);
        }
        catch (ProcessCanceledException ignored) {
            return;
        }
        THashMap dependencies = new THashMap();
        for (InspectionToolWrapper toolWrapper : tools) {
            this.addTool(project2, toolWrapper, (Map<String, List<String>>)dependencies);
        }
        DFSTBuilder builder = new DFSTBuilder((Graph)GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<String>((Map)dependencies){
            final /* synthetic */ Map val$dependencies;
            {
                this.val$dependencies = map;
            }

            public Collection<String> getNodes() {
                return this.val$dependencies.keySet();
            }

            public Iterator<String> getIn(String n) {
                return ((List)this.val$dependencies.get(n)).iterator();
            }
        })));
        if (builder.isAcyclic()) {
            this.myScopesOrder = ArrayUtil.toStringArray((Collection)builder.getSortedNodes());
        }
        if (this.mySource != null) {
            this.copyToolsConfigurations(this.mySource, project2);
        }
        this.myInitialized = true;
        if (dataHolder != null) {
            dataHolder.updateDigest(this);
        }
    }

    public void addTool(@Nullable Project project2, @NotNull InspectionToolWrapper toolWrapper, @NotNull Map<String, List<String>> dependencies) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionProfileImpl", "addTool"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/intellij/codeInspection/ex/InspectionProfileImpl", "addTool"));
        }
        String shortName = toolWrapper.getShortName();
        HighlightDisplayKey key2 = HighlightDisplayKey.find((String)shortName);
        if (key2 == null) {
            InspectionEP extension = toolWrapper.getExtension();
            Computable.PredefinedValueComputable computable = extension == null ? new Computable.PredefinedValueComputable((Object)toolWrapper.getDisplayName()) : () -> ((InspectionEP)extension).getDisplayName();
            key2 = toolWrapper instanceof LocalInspectionToolWrapper ? HighlightDisplayKey.register((String)shortName, (Computable)computable, (String)toolWrapper.getID(), (String)((LocalInspectionToolWrapper)toolWrapper).getAlternativeID()) : HighlightDisplayKey.register((String)shortName, (Computable)computable);
        }
        if (key2 == null) {
            LOG.error(shortName + " ; number of initialized tools: " + this.myTools.size());
            return;
        }
        HighlightDisplayLevel baseLevel = this.myBaseProfile != null && this.myBaseProfile.getTools(shortName, project2) != null ? this.myBaseProfile.getErrorLevel(key2, project2) : HighlightDisplayLevel.DO_NOT_SHOW;
        HighlightDisplayLevel defaultLevel = toolWrapper.getDefaultLevel();
        HighlightDisplayLevel level = baseLevel.getSeverity().compareTo(defaultLevel.getSeverity()) > 0 ? baseLevel : defaultLevel;
        boolean enabled = this.myBaseProfile != null ? this.myBaseProfile.isToolEnabled(key2) : toolWrapper.isEnabledByDefault();
        ToolsImpl toolsList = new ToolsImpl(toolWrapper, level, !this.myLockedProfile && enabled, enabled);
        Element element = this.myUninitializedSettings.remove(shortName);
        try {
            if (element != null) {
                this.getPathMacroManager().expandPaths(element);
                toolsList.readExternal(element, this.getProfileManager(), dependencies);
            } else if (!this.myUninitializedSettings.containsKey(InspectionElementsMergerBase.getMergedMarkerName(shortName))) {
                Element merged;
                InspectionElementsMergerBase merger = InspectionProfileImpl.getMerger(shortName);
                Element element2 = merged = merger == null ? null : merger.merge(this.myUninitializedSettings);
                if (merged != null) {
                    this.getPathMacroManager().expandPaths(merged);
                    toolsList.readExternal(merged, this.getProfileManager(), dependencies);
                } else if (this.isProfileLocked()) {
                    toolsList.setEnabled(false);
                    if (toolsList.getNonDefaultTools() == null) {
                        toolsList.getDefaultState().setEnabled(false);
                    }
                }
            }
        }
        catch (InvalidDataException e) {
            LOG.error("Can't read settings for " + toolWrapper, (Throwable)e);
        }
        this.myTools.put(shortName, toolsList);
    }

    @Nullable
    private static InspectionElementsMergerBase getMerger(String shortName) {
        final InspectionElementsMerger merger = InspectionElementsMerger.getMerger((String)shortName);
        if (merger instanceof InspectionElementsMergerBase) {
            return (InspectionElementsMergerBase)merger;
        }
        return merger != null ? new InspectionElementsMergerBase(){

            public String getMergedToolName() {
                return merger.getMergedToolName();
            }

            public String[] getSourceToolNames() {
                return merger.getSourceToolNames();
            }
        } : null;
    }

    @Transient
    @Nullable
    public String[] getScopesOrder() {
        return this.myScopesOrder;
    }

    public void setScopesOrder(String[] scopesOrder) {
        this.myScopesOrder = scopesOrder;
    }

    private HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key2, @Nullable Project project2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getErrorLevel"));
        }
        ToolsImpl tools = this.getTools(key2.toString(), project2);
        LOG.assertTrue(tools != null, (Object)("profile name: " + this.myName + " base profile: " + (this.myBaseProfile != null ? this.myBaseProfile.getName() : "-") + " key: " + key2));
        return tools.getLevel();
    }

    @NotNull
    public InspectionProfileImpl getModifiableModel() {
        InspectionProfileImpl inspectionProfileImpl = new InspectionProfileImpl(this);
        if (inspectionProfileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getModifiableModel"));
        }
        return inspectionProfileImpl;
    }

    private void copyToolsConfigurations(@NotNull InspectionProfileImpl profile, @Nullable Project project2) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInspection/ex/InspectionProfileImpl", "copyToolsConfigurations"));
        }
        try {
            for (ToolsImpl toolList : profile.myTools.values()) {
                ToolsImpl tools = this.myTools.get(toolList.getShortName());
                ScopeToolState defaultState = toolList.getDefaultState();
                tools.setDefaultState(InspectionProfileImpl.copyToolSettings(defaultState.getTool()), defaultState.isEnabled(), defaultState.getLevel());
                tools.removeAllScopes();
                List<ScopeToolState> nonDefaultToolStates = toolList.getNonDefaultTools();
                if (nonDefaultToolStates != null) {
                    for (ScopeToolState state : nonDefaultToolStates) {
                        InspectionToolWrapper toolWrapper = InspectionProfileImpl.copyToolSettings(state.getTool());
                        NamedScope scope = state.getScope(project2);
                        if (scope != null) {
                            tools.addTool(scope, toolWrapper, state.isEnabled(), state.getLevel());
                            continue;
                        }
                        tools.addTool(state.getScopeName(), toolWrapper, state.isEnabled(), state.getLevel());
                    }
                }
                tools.setEnabled(toolList.isEnabled());
            }
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void cleanup(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionProfileImpl", "cleanup"));
        }
        if (!this.myInitialized) {
            return;
        }
        for (ToolsImpl toolList : this.myTools.values()) {
            if (!toolList.isEnabled()) continue;
            toolList.cleanupTools(project2);
        }
    }

    public void enableTool(@NotNull String toolId, Project project2) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/ex/InspectionProfileImpl", "enableTool"));
        }
        ToolsImpl tools = this.getTools(toolId, project2);
        tools.setEnabled(true);
        if (tools.getNonDefaultTools() == null) {
            tools.getDefaultState().setEnabled(true);
        }
    }

    public void enableTool(@NotNull String inspectionTool, NamedScope namedScope, Project project2) {
        if (inspectionTool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionTool", "com/intellij/codeInspection/ex/InspectionProfileImpl", "enableTool"));
        }
        this.getTools(inspectionTool, project2).enableTool(namedScope, project2);
    }

    public void enableTools(@NotNull List<String> inspectionTools, NamedScope namedScope, Project project2) {
        if (inspectionTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionTools", "com/intellij/codeInspection/ex/InspectionProfileImpl", "enableTools"));
        }
        for (String inspectionTool : inspectionTools) {
            this.enableTool(inspectionTool, namedScope, project2);
        }
    }

    public void disableTools(@NotNull List<String> inspectionTools, NamedScope namedScope, @NotNull Project project2) {
        if (inspectionTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionTools", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableTools"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableTools"));
        }
        for (String inspectionTool : inspectionTools) {
            this.getTools(inspectionTool, project2).disableTool(namedScope, project2);
        }
    }

    public void disableTool(@NotNull String inspectionTool, @Nullable Project project2) {
        if (inspectionTool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionTool", "com/intellij/codeInspection/ex/InspectionProfileImpl", "disableTool"));
        }
        ToolsImpl tools = this.getTools(inspectionTool, project2);
        tools.setEnabled(false);
        if (tools.getNonDefaultTools() == null) {
            tools.getDefaultState().setEnabled(false);
        }
    }

    public void setErrorLevel(@NotNull HighlightDisplayKey key2, @NotNull HighlightDisplayLevel level, Project project2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setErrorLevel"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setErrorLevel"));
        }
        this.getTools(key2.toString(), project2).setLevel(level);
    }

    public boolean isToolEnabled(@Nullable HighlightDisplayKey key2, PsiElement element) {
        if (key2 == null) {
            return false;
        }
        ToolsImpl toolState = this.getTools(key2.toString(), element == null ? null : element.getProject());
        return toolState != null && toolState.isEnabled(element);
    }

    public boolean isToolEnabled(@Nullable HighlightDisplayKey key2) {
        return this.isToolEnabled(key2, null);
    }

    public boolean isExecutable(Project project2) {
        this.initInspectionTools(project2);
        for (Tools tools : this.myTools.values()) {
            if (!tools.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public void commit() {
        LOG.assertTrue(this.mySource != null);
        this.mySource.commit(this);
        this.getProfileManager().updateProfile(this.mySource);
        this.mySource = null;
    }

    private void commit(@NotNull InspectionProfileImpl model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/codeInspection/ex/InspectionProfileImpl", "commit"));
        }
        this.setName(model.getName());
        this.setDescription(model.getDescription());
        this.setProjectLevel(model.isProjectLevel());
        this.myLockedProfile = model.myLockedProfile;
        this.myChangedToolNames = model.myChangedToolNames;
        this.myTools = model.myTools;
        this.setProfileManager(model.getProfileManager());
        InspectionProfileManager.getInstance().fireProfileChanged((InspectionProfile)model);
    }

    @Tag
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public void convert(@NotNull Element element, @NotNull Project project2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/InspectionProfileImpl", "convert"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionProfileImpl", "convert"));
        }
        Element scopes = element.getChild("scopes");
        if (scopes == null) {
            return;
        }
        this.initInspectionTools(project2);
        for (Element scopeElement : scopes.getChildren("scope")) {
            NamedScope scope;
            String profile = scopeElement.getAttributeValue("profile");
            InspectionProfileImpl inspectionProfile = profile == null ? null : this.getProfileManager().getProfile(profile);
            NamedScope namedScope = scope = inspectionProfile == null ? null : this.getProfileManager().getScopesManager().getScope(scopeElement.getAttributeValue("name"));
            if (scope == null) continue;
            for (InspectionToolWrapper toolWrapper : inspectionProfile.getInspectionTools(null)) {
                HighlightDisplayKey key2 = HighlightDisplayKey.find((String)toolWrapper.getShortName());
                try {
                    InspectionToolWrapper toolWrapperCopy = InspectionProfileImpl.copyToolSettings(toolWrapper);
                    HighlightDisplayLevel errorLevel = inspectionProfile.getErrorLevel(key2, null, project2);
                    this.getTools(toolWrapper.getShortName(), project2).addTool(scope, toolWrapperCopy, inspectionProfile.isToolEnabled(key2), errorLevel);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        this.reduceConvertedScopes();
    }

    private void reduceConvertedScopes() {
        for (ToolsImpl tools : this.myTools.values()) {
            ScopeToolState toolState = tools.getDefaultState();
            List<ScopeToolState> nonDefaultTools = tools.getNonDefaultTools();
            if (nonDefaultTools == null) continue;
            boolean equal = true;
            boolean isEnabled = toolState.isEnabled();
            for (ScopeToolState state : nonDefaultTools) {
                isEnabled |= state.isEnabled();
                if (state.equalTo(toolState)) continue;
                equal = false;
            }
            tools.setEnabled(isEnabled);
            if (!equal) continue;
            tools.removeAllScopes();
        }
    }

    @NotNull
    public List<ScopeToolState> getAllTools(@Nullable Project project2) {
        this.initInspectionTools(project2);
        ArrayList<ScopeToolState> result2 = new ArrayList<ScopeToolState>();
        for (Tools tools : this.myTools.values()) {
            tools.collectTools(result2);
        }
        ArrayList<ScopeToolState> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getAllTools"));
        }
        return arrayList;
    }

    @NotNull
    public List<ScopeToolState> getDefaultStates(@Nullable Project project2) {
        this.initInspectionTools(project2);
        ArrayList<ScopeToolState> result2 = new ArrayList<ScopeToolState>();
        for (Tools tools : this.myTools.values()) {
            result2.add(tools.getDefaultState());
        }
        ArrayList<ScopeToolState> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getDefaultStates"));
        }
        return arrayList;
    }

    @NotNull
    public List<ScopeToolState> getNonDefaultTools(@NotNull String shortName, Project project2) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getNonDefaultTools"));
        }
        ArrayList<ScopeToolState> result2 = new ArrayList<ScopeToolState>();
        List<ScopeToolState> nonDefaultTools = this.getTools(shortName, project2).getNonDefaultTools();
        if (nonDefaultTools != null) {
            result2.addAll(nonDefaultTools);
        }
        ArrayList<ScopeToolState> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getNonDefaultTools"));
        }
        return arrayList;
    }

    public boolean isToolEnabled(@NotNull HighlightDisplayKey key2, NamedScope namedScope, Project project2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ex/InspectionProfileImpl", "isToolEnabled"));
        }
        return this.getTools(key2.toString(), project2).isEnabled(namedScope, project2);
    }

    public void removeScope(@NotNull String toolId, @NotNull String scopeName, Project project2) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/ex/InspectionProfileImpl", "removeScope"));
        }
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "removeScope"));
        }
        this.getTools(toolId, project2).removeScope(scopeName);
    }

    public void removeScopes(@NotNull List<String> toolIds, @NotNull String scopeName, Project project2) {
        if (toolIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolIds", "com/intellij/codeInspection/ex/InspectionProfileImpl", "removeScopes"));
        }
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/codeInspection/ex/InspectionProfileImpl", "removeScopes"));
        }
        for (String toolId : toolIds) {
            this.removeScope(toolId, scopeName, project2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Set<String> getChangedToolNames() {
        if (this.myBaseProfile == null) {
            return null;
        }
        if (this.myChangedToolNames == null) {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myChangedToolNames == null) {
                    this.initInspectionTools(null);
                    Set<String> names = this.myTools.keySet();
                    THashSet map = new THashSet(names.size());
                    for (String toolId : names) {
                        if (InspectionProfileImpl.toolSettingsAreEqual(toolId, this.myBaseProfile, this)) continue;
                        map.add(toolId);
                    }
                    this.myChangedToolNames = map;
                    return map;
                }
            }
        }
        return this.myChangedToolNames;
    }

    public void profileChanged() {
        this.myChangedToolNames = null;
    }

    @Transient
    @NotNull
    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key2, NamedScope scope, Project project2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getErrorLevel"));
        }
        ToolsImpl tools = this.getTools(key2.toString(), project2);
        HighlightDisplayLevel highlightDisplayLevel = tools != null ? tools.getLevel(scope, project2) : HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getErrorLevel"));
        }
        return highlightDisplayLevel;
    }

    public ScopeToolState addScope(@NotNull InspectionToolWrapper toolWrapper, NamedScope scope, @NotNull HighlightDisplayLevel level, boolean enabled, Project project2) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionProfileImpl", "addScope"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInspection/ex/InspectionProfileImpl", "addScope"));
        }
        return this.getTools(toolWrapper.getShortName(), project2).prependTool(scope, toolWrapper, enabled, level);
    }

    public void setErrorLevel(@NotNull HighlightDisplayKey key2, @NotNull HighlightDisplayLevel level, String scopeName, Project project2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setErrorLevel"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setErrorLevel"));
        }
        this.getTools(key2.toString(), project2).setLevel(level, scopeName, project2);
    }

    public void setErrorLevel(@NotNull List<HighlightDisplayKey> keys, @NotNull HighlightDisplayLevel level, String scopeName, Project project2) {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setErrorLevel"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInspection/ex/InspectionProfileImpl", "setErrorLevel"));
        }
        for (HighlightDisplayKey key2 : keys) {
            this.setErrorLevel(key2, level, scopeName, project2);
        }
    }

    public ToolsImpl getTools(@NotNull String toolId, @Nullable Project project2) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/ex/InspectionProfileImpl", "getTools"));
        }
        this.initInspectionTools(project2);
        return this.myTools.get(toolId);
    }

    public void enableAllTools(Project project2) {
        for (InspectionToolWrapper entry : this.getInspectionTools(null)) {
            this.enableTool(entry.getShortName(), project2);
        }
    }

    @NotNull
    public String toString() {
        String string = this.mySource == null ? this.getName() : this.getName() + " (copy)";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileImpl", "toString"));
        }
        return string;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && ((InspectionProfileImpl)o).getProfileManager() == this.getProfileManager();
    }

    private static class InspectionProfileImplHolder {
        private static final InspectionProfileImpl DEFAULT_PROFILE = new InspectionProfileImpl("Default");

        private InspectionProfileImplHolder() {
        }
    }
}

