/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PurityInference {
    public static boolean inferPurity(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/PurityInference", "inferPurity"));
        }
        if (!InferenceFromSourceUtil.shouldInferFromSource(method2) || PsiType.VOID.equals((Object)method2.getReturnType()) || method2.getBody() == null || method2.isConstructor() || PropertyUtil.isSimpleGetter((PsiMethod)method2)) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)method2, () -> {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/PurityInference", "lambda$inferPurity$1"));
            }
            boolean pure = RecursionManager.doPreventingRecursion((Object)method2, (boolean)true, () -> {
                if (method2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/PurityInference", "lambda$null$0"));
                }
                return PurityInference.doInferPurity(method2);
            }) == Boolean.TRUE;
            return CachedValueProvider.Result.create((Object)pure, (Object[])new Object[]{method2});
        });
    }

    private static boolean doInferPurity(final PsiMethod method2) {
        PsiCodeBlock body = method2.getBody();
        if (body == null) {
            return false;
        }
        final Ref impureFound = Ref.create((Object)false);
        final Ref hasReturns = Ref.create((Object)false);
        final ArrayList calls = ContainerUtil.newArrayList();
        body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                if (!PurityInference.isLocalVarReference(expression.getLExpression(), method2)) {
                    impureFound.set((Object)true);
                }
                super.visitAssignmentExpression(expression);
            }

            public void visitReturnStatement(PsiReturnStatement statement2) {
                if (statement2.getReturnValue() != null) {
                    hasReturns.set((Object)true);
                }
                super.visitReturnStatement(statement2);
            }

            public void visitPrefixExpression(PsiPrefixExpression expression) {
                if (this.isMutatingOperation(expression.getOperationTokenType()) && !PurityInference.isLocalVarReference(expression.getOperand(), method2)) {
                    impureFound.set((Object)true);
                }
                super.visitPrefixExpression(expression);
            }

            private boolean isMutatingOperation(IElementType operationTokenType) {
                return operationTokenType == JavaTokenType.PLUSPLUS || operationTokenType == JavaTokenType.MINUSMINUS;
            }

            public void visitPostfixExpression(PsiPostfixExpression expression) {
                if (this.isMutatingOperation(expression.getOperationTokenType()) && !PurityInference.isLocalVarReference(expression.getOperand(), method2)) {
                    impureFound.set((Object)true);
                }
                super.visitPostfixExpression(expression);
            }

            public void visitCallExpression(PsiCallExpression callExpression) {
                if (!(callExpression instanceof PsiNewExpression) || ((PsiNewExpression)callExpression).getArrayDimensions().length == 0) {
                    calls.add(callExpression);
                }
                super.visitCallExpression(callExpression);
            }
        });
        if (((Boolean)impureFound.get()).booleanValue() || calls.size() > 1 || !((Boolean)hasReturns.get()).booleanValue()) {
            return false;
        }
        if (calls.isEmpty()) {
            return true;
        }
        PsiMethod called = ((PsiCallExpression)calls.get(0)).resolveMethod();
        return called != null && ControlFlowAnalyzer.isPure(called);
    }

    private static boolean isLocalVarReference(PsiExpression expression, PsiMethod scope) {
        if (expression instanceof PsiReferenceExpression) {
            PsiElement target = ((PsiReferenceExpression)expression).resolve();
            return target instanceof PsiLocalVariable || target instanceof PsiParameter;
        }
        if (expression instanceof PsiArrayAccessExpression) {
            PsiExpression array = ((PsiArrayAccessExpression)expression).getArrayExpression();
            PsiElement target = array instanceof PsiReferenceExpression ? ((PsiReferenceExpression)array).resolve() : null;
            return target instanceof PsiLocalVariable && PurityInference.isLocallyCreatedArray(scope, (PsiLocalVariable)target);
        }
        return false;
    }

    private static boolean isLocallyCreatedArray(PsiMethod scope, PsiLocalVariable target) {
        PsiExpression initializer = target.getInitializer();
        if (initializer != null && !(initializer instanceof PsiNewExpression)) {
            return false;
        }
        for (PsiReference ref : ReferencesSearch.search((PsiElement)target, (SearchScope)new LocalSearchScope((PsiElement)scope)).findAll()) {
            PsiAssignmentExpression assign;
            if (!(ref instanceof PsiReferenceExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiReferenceExpression)ref)) || (assign = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiReferenceExpression)ref), PsiAssignmentExpression.class)) != null && assign.getRExpression() instanceof PsiNewExpression) continue;
            return false;
        }
        return true;
    }
}

