/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.PreContract;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class KnownContract
extends PreContract {
    private final MethodContract myKnownContract;

    KnownContract(@NotNull MethodContract knownContract) {
        if (knownContract == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "knownContract", "com/intellij/codeInspection/dataFlow/KnownContract", "<init>"));
        }
        this.myKnownContract = knownContract;
    }

    @NotNull
    MethodContract getContract() {
        MethodContract methodContract = this.myKnownContract;
        if (methodContract == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/KnownContract", "getContract"));
        }
        return methodContract;
    }

    @Override
    @NotNull
    List<MethodContract> toContracts(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/KnownContract", "toContracts"));
        }
        List<MethodContract> list = Collections.singletonList(this.myKnownContract);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/KnownContract", "toContracts"));
        }
        return list;
    }
}

