/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Conf;
import com.intellij.codeInspection.bytecodeAnalysis.Key;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

class AbstractValues {
    static final BasicValue InstanceOfCheckValue = new BasicValue(Type.INT_TYPE){

        public boolean equals(Object value) {
            return this == value;
        }
    };
    static final BasicValue TrueValue = new BasicValue(Type.INT_TYPE){

        public boolean equals(Object value) {
            return this == value;
        }
    };
    static final BasicValue FalseValue = new BasicValue(Type.INT_TYPE){

        public boolean equals(Object value) {
            return this == value;
        }
    };
    static final BasicValue NullValue = new BasicValue(Type.getObjectType((String)"null")){

        public boolean equals(Object value) {
            return this == value;
        }
    };
    static final BasicValue CLASS_VALUE = new NotNullValue(Type.getObjectType((String)"java/lang/Class"));
    static final BasicValue METHOD_VALUE = new NotNullValue(Type.getObjectType((String)"java/lang/invoke/MethodType"));
    static final BasicValue STRING_VALUE = new NotNullValue(Type.getObjectType((String)"java/lang/String"));
    static final BasicValue METHOD_HANDLE_VALUE = new NotNullValue(Type.getObjectType((String)"java/lang/invoke/MethodHandle"));

    AbstractValues() {
    }

    static boolean isInstance(Conf curr, Conf prev) {
        int i2;
        if (curr.insnIndex != prev.insnIndex) {
            return false;
        }
        Frame<BasicValue> currFr = curr.frame;
        Frame<BasicValue> prevFr = prev.frame;
        for (i2 = 0; i2 < currFr.getLocals(); ++i2) {
            if (AbstractValues.isInstance((BasicValue)currFr.getLocal(i2), (BasicValue)prevFr.getLocal(i2))) continue;
            return false;
        }
        for (i2 = 0; i2 < currFr.getStackSize(); ++i2) {
            if (AbstractValues.isInstance((BasicValue)currFr.getStack(i2), (BasicValue)prevFr.getStack(i2))) continue;
            return false;
        }
        return true;
    }

    static boolean isInstance(BasicValue curr, BasicValue prev) {
        if (prev instanceof ParamValue) {
            return curr instanceof ParamValue;
        }
        if (InstanceOfCheckValue == prev) {
            return InstanceOfCheckValue == curr;
        }
        if (TrueValue == prev) {
            return TrueValue == curr;
        }
        if (FalseValue == prev) {
            return FalseValue == curr;
        }
        if (NullValue == prev) {
            return NullValue == curr;
        }
        if (prev instanceof NotNullValue) {
            return curr instanceof NotNullValue;
        }
        if (prev instanceof CallResultValue) {
            if (curr instanceof CallResultValue) {
                CallResultValue prevCall = (CallResultValue)prev;
                CallResultValue currCall = (CallResultValue)curr;
                return prevCall.inters.equals(currCall.inters);
            }
            return false;
        }
        return true;
    }

    static boolean equiv(Conf curr, Conf prev) {
        int i2;
        Frame<BasicValue> currFr = curr.frame;
        Frame<BasicValue> prevFr = prev.frame;
        for (i2 = currFr.getStackSize() - 1; i2 >= 0; --i2) {
            if (AbstractValues.equiv((BasicValue)currFr.getStack(i2), (BasicValue)prevFr.getStack(i2))) continue;
            return false;
        }
        for (i2 = currFr.getLocals() - 1; i2 >= 0; --i2) {
            if (AbstractValues.equiv((BasicValue)currFr.getLocal(i2), (BasicValue)prevFr.getLocal(i2))) continue;
            return false;
        }
        return true;
    }

    static boolean equiv(BasicValue curr, BasicValue prev) {
        if (curr.getClass() == prev.getClass()) {
            if (curr instanceof CallResultValue && prev instanceof CallResultValue) {
                Set<Key> keys1 = ((CallResultValue)prev).inters;
                Set<Key> keys2 = ((CallResultValue)curr).inters;
                return keys1.equals(keys2);
            }
            return true;
        }
        return false;
    }

    static final class CallResultValue
    extends BasicValue {
        final Set<Key> inters;

        CallResultValue(Type tp, Set<Key> inters) {
            super(tp);
            this.inters = inters;
        }
    }

    static final class NotNullValue
    extends BasicValue {
        NotNullValue(Type tp) {
            super(tp);
        }
    }

    static final class ParamValue
    extends BasicValue {
        ParamValue(Type tp) {
            super(tp);
        }
    }
}

