/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantLambdaCodeBlockInspection
extends BaseJavaBatchLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance((String)("#" + RedundantLambdaCodeBlockInspection.class.getName()));

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Statement lambda can be replaced with expression lambda" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection", "getDisplayName"));
        }
        return "Statement lambda can be replaced with expression lambda";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        if ("CodeBlock2Expr" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection", "getShortName"));
        }
        return "CodeBlock2Expr";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression expression) {
                PsiElement body;
                PsiExpression psiExpression;
                super.visitLambdaExpression(expression);
                if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)expression) && (psiExpression = RedundantLambdaCodeBlockInspection.isCodeBlockRedundant(body = expression.getBody())) != null) {
                    PsiElement parent = psiExpression.getParent();
                    PsiElement errorElement = parent instanceof PsiReturnStatement ? parent.getFirstChild() : body.getFirstChild();
                    holder.registerProblem(errorElement, "Statement lambda can be replaced with expression lambda", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new ReplaceWithExprFix()});
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    public static PsiExpression isCodeBlockRedundant(PsiElement body) {
        PsiExpression psiExpression;
        if (body instanceof PsiCodeBlock && (psiExpression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body)) != null && !RedundantLambdaCodeBlockInspection.findCommentsOutsideExpression(body, psiExpression)) {
            PsiCall call;
            if (LambdaUtil.isExpressionStatementExpression((PsiElement)psiExpression) && (call = LambdaUtil.treeWalkUp((PsiElement)body)) != null && call.resolveMethod() != null) {
                PsiElement parent;
                int offsetInTopCall = body.getTextRange().getStartOffset() - call.getTextRange().getStartOffset();
                PsiCall copyCall = LambdaUtil.copyTopLevelCall((PsiCall)call);
                if (copyCall == null) {
                    return null;
                }
                PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)copyCall.findElementAt(offsetInTopCall), PsiCodeBlock.class);
                if (codeBlock != null && (parent = codeBlock.getParent()) instanceof PsiLambdaExpression) {
                    codeBlock.replace((PsiElement)psiExpression);
                    if (copyCall.resolveMethod() == null || ((PsiLambdaExpression)parent).getFunctionalInterfaceType() == null) {
                        return null;
                    }
                }
            }
            return psiExpression;
        }
        return null;
    }

    private static boolean findCommentsOutsideExpression(PsiElement body, PsiExpression psiExpression) {
        Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)body, PsiComment.class);
        for (PsiComment comment : comments) {
            if (PsiTreeUtil.isAncestor((PsiElement)psiExpression, (PsiElement)comment, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    private static class ReplaceWithExprFix
    implements LocalQuickFix,
    HighPriorityAction {
        private ReplaceWithExprFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with expression lambda" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection$ReplaceWithExprFix", "getFamilyName"));
            }
            return "Replace with expression lambda";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection$ReplaceWithExprFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection$ReplaceWithExprFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element != null) {
                PsiExpression expression;
                PsiElement body;
                if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                    return;
                }
                PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class);
                if (lambdaExpression != null && (body = lambdaExpression.getBody()) != null && (expression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body)) != null) {
                    body.replace((PsiElement)expression);
                }
            }
        }
    }
}

