/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaCanBeMethodReferenceInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)("#" + LambdaCanBeMethodReferenceInspection.class.getName()));
    public boolean REPLACE_INSTANCEOF;
    public boolean REPLACE_CAST;
    public boolean REPLACE_NULL_CHECK = true;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox("Replace instanceof with MyClass.class::isInstance", "REPLACE_INSTANCEOF");
        panel2.addCheckbox("Replace cast with MyClass.class::cast", "REPLACE_CAST");
        panel2.addCheckbox("Replace null-check with Objects::nonNull or Objects::isNull", "REPLACE_NULL_CHECK");
        return panel2;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Lambda can be replaced with method reference" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "getDisplayName"));
        }
        return "Lambda can be replaced with method reference";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        if ("Convert2MethodRef" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "getShortName"));
        }
        return "Convert2MethodRef";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression expression) {
                super.visitLambdaExpression(expression);
                if (PsiUtil.getLanguageLevel((PsiElement)expression).isAtLeast(LanguageLevel.JDK_1_8)) {
                    PsiExpression candidate;
                    PsiElement body = expression.getBody();
                    PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
                    if (functionalInterfaceType != null && (candidate = LambdaCanBeMethodReferenceInspection.this.canBeMethodReferenceProblem(body, (PsiVariable[])expression.getParameterList().getParameters(), functionalInterfaceType, null)) != null) {
                        holder.registerProblem((PsiElement)candidate, "Can be replaced with method reference", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceWithMethodRefFix()});
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Nullable
    public static String convertToMethodReference(@Nullable PsiElement body, PsiVariable[] parameters, PsiType functionalInterfaceType, @Nullable PsiElement context) {
        PsiExpression candidate = new LambdaCanBeMethodReferenceInspection().canBeMethodReferenceProblem(body, parameters, functionalInterfaceType, context);
        return LambdaCanBeMethodReferenceInspection.createMethodReferenceText((PsiElement)candidate, functionalInterfaceType, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PsiExpression canBeMethodReferenceProblem(@Nullable PsiElement body, PsiVariable[] parameters, PsiType functionalInterfaceType, @Nullable PsiElement context) {
        PsiNewExpression newExpression;
        PsiExpression methodRefCandidate = this.extractMethodReferenceCandidateExpression(body);
        if (methodRefCandidate instanceof PsiNewExpression && ((newExpression = (PsiNewExpression)methodRefCandidate).getAnonymousClass() != null || newExpression.getArrayInitializer() != null)) {
            return null;
        }
        String methodReferenceText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText((PsiElement)methodRefCandidate, functionalInterfaceType, parameters);
        if (methodReferenceText != null) {
            PsiMethodReferenceExpression methodReferenceExpression;
            LOG.assertTrue(methodRefCandidate != null);
            if (!(methodRefCandidate instanceof PsiCallExpression)) {
                return methodRefCandidate;
            }
            PsiCallExpression callExpression = (PsiCallExpression)methodRefCandidate;
            PsiMethod method2 = callExpression.resolveMethod();
            if (method2 != null) {
                if (!LambdaCanBeMethodReferenceInspection.isSimpleCall(parameters, callExpression, method2)) {
                    return null;
                }
            } else {
                LOG.assertTrue(callExpression instanceof PsiNewExpression);
                if (((PsiNewExpression)callExpression).getQualifier() != null) {
                    return null;
                }
                PsiExpression[] dims = ((PsiNewExpression)callExpression).getArrayDimensions();
                if (dims.length == 1 && parameters.length == 1 ? !LambdaCanBeMethodReferenceInspection.resolvesToParameter(dims[0], parameters[0]) : dims.length > 0) {
                    return null;
                }
                if (callExpression.getTypeArguments().length > 0) {
                    return null;
                }
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)callExpression.getProject());
            try {
                methodReferenceExpression = (PsiMethodReferenceExpression)elementFactory.createExpressionFromText(methodReferenceText, (PsiElement)(context != null ? context : callExpression));
            }
            catch (IncorrectOperationException e) {
                LOG.error(callExpression.getText(), (Throwable)e);
                return null;
            }
            Map map = LambdaUtil.getFunctionalTypeMap();
            try {
                map.put(methodReferenceExpression, functionalInterfaceType);
                JavaResolveResult result2 = methodReferenceExpression.advancedResolve(false);
                PsiElement element = result2.getElement();
                if (element != null && result2.isAccessible() && (!(result2 instanceof MethodCandidateInfo) || ((MethodCandidateInfo)result2).isApplicable())) {
                    if (!(element instanceof PsiMethod)) {
                        PsiCallExpression psiCallExpression = callExpression;
                        return psiCallExpression;
                    }
                    PsiCallExpression psiCallExpression = method2 != null && MethodSignatureUtil.areSignaturesEqual((PsiMethod)((PsiMethod)element), (PsiMethod)method2) ? callExpression : null;
                    return psiCallExpression;
                }
            }
            finally {
                map.remove(methodReferenceExpression);
            }
        }
        return null;
    }

    private static boolean isSimpleCall(final PsiVariable[] parameters, PsiCallExpression callExpression, PsiMethod psiMethod) {
        PsiExpressionList argumentList = callExpression.getArgumentList();
        if (argumentList == null) {
            return false;
        }
        int calledParametersCount = psiMethod.getParameterList().getParametersCount();
        PsiExpression[] expressions = argumentList.getExpressions();
        Object qualifier = callExpression instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)callExpression).getMethodExpression().getQualifierExpression() : (callExpression instanceof PsiNewExpression ? ((PsiNewExpression)callExpression).getQualifier() : null);
        if (expressions.length == 0 && parameters.length == 0) {
            return !(callExpression instanceof PsiNewExpression) || qualifier == null;
        }
        int offset = parameters.length - calledParametersCount;
        if (expressions.length > calledParametersCount || offset < 0) {
            return false;
        }
        for (int i2 = 0; i2 < expressions.length; ++i2) {
            if (LambdaCanBeMethodReferenceInspection.resolvesToParameter(expressions[i2], parameters[i2 + offset])) continue;
            return false;
        }
        if (offset == 0) {
            if (qualifier != null) {
                final boolean[] parameterUsed = new boolean[]{false};
                qualifier.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitElement(PsiElement element) {
                        if (parameterUsed[0]) {
                            return;
                        }
                        super.visitElement(element);
                    }

                    public void visitReferenceExpression(PsiReferenceExpression expression) {
                        super.visitReferenceExpression(expression);
                        parameterUsed[0] = parameterUsed[0] | ArrayUtil.find((Object[])parameters, (Object)expression.resolve()) >= 0;
                    }
                });
                return !parameterUsed[0];
            }
            return true;
        }
        return LambdaCanBeMethodReferenceInspection.resolvesToParameter(qualifier, parameters[0]);
    }

    @Contract(value="null, _ -> false")
    private static boolean resolvesToParameter(PsiExpression expression, PsiVariable parameter) {
        return expression instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression).resolve() == parameter;
    }

    @Nullable
    private PsiExpression extractMethodReferenceCandidateExpression(PsiElement body) {
        PsiTypeElement typeElement;
        PsiExpression expression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body);
        if (expression == null) {
            return null;
        }
        if (expression instanceof PsiNewExpression ? LambdaCanBeMethodReferenceInspection.checkQualifier((PsiElement)((PsiNewExpression)expression).getQualifier()) : expression instanceof PsiMethodCallExpression && LambdaCanBeMethodReferenceInspection.checkQualifier(((PsiMethodCallExpression)expression).getMethodExpression().getQualifier())) {
            return expression;
        }
        if (expression instanceof PsiInstanceOfExpression && this.REPLACE_INSTANCEOF) {
            return expression;
        }
        if (expression instanceof PsiBinaryExpression && this.REPLACE_NULL_CHECK) {
            IElementType tokenType = ((PsiBinaryExpression)expression).getOperationTokenType();
            if ((JavaTokenType.EQEQ.equals(tokenType) || JavaTokenType.NE.equals(tokenType)) && (ExpressionUtils.isNullLiteral(((PsiBinaryExpression)expression).getLOperand()) || ExpressionUtils.isNullLiteral(((PsiBinaryExpression)expression).getROperand()))) {
                return expression;
            }
        } else if (expression instanceof PsiTypeCastExpression && this.REPLACE_CAST && (typeElement = ((PsiTypeCastExpression)expression).getCastType()) != null) {
            PsiJavaCodeReferenceElement refs = typeElement.getInnermostComponentReferenceElement();
            if (refs != null && refs.getParameterList() != null && refs.getParameterList().getTypeParameterElements().length != 0) {
                return null;
            }
            PsiType type = typeElement.getType();
            if (type instanceof PsiPrimitiveType || PsiUtil.resolveClassInType((PsiType)type) instanceof PsiTypeParameter) {
                return null;
            }
            return expression;
        }
        return null;
    }

    public static void replaceAllLambdasWithMethodReferences(PsiElement root) {
        Collection lambdas = PsiTreeUtil.findChildrenOfType((PsiElement)root, PsiLambdaExpression.class);
        if (!lambdas.isEmpty()) {
            for (PsiLambdaExpression lambda2 : lambdas) {
                LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference(lambda2);
            }
        }
    }

    @NotNull
    public static PsiExpression replaceLambdaWithMethodReference(@NotNull PsiLambdaExpression lambda2) {
        if (lambda2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambda", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "replaceLambdaWithMethodReference"));
        }
        PsiExpression body = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
        PsiExpression candidate = new LambdaCanBeMethodReferenceInspection().canBeMethodReferenceProblem((PsiElement)body, (PsiVariable[])lambda2.getParameterList().getParameters(), lambda2.getFunctionalInterfaceType(), (PsiElement)lambda2);
        PsiExpression psiExpression = LambdaCanBeMethodReferenceInspection.tryConvertToMethodReference(lambda2, (PsiElement)candidate);
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "replaceLambdaWithMethodReference"));
        }
        return psiExpression;
    }

    private static boolean checkQualifier(PsiElement qualifier) {
        if (qualifier == null) {
            return true;
        }
        Condition callExpressionCondition = Conditions.instanceOf(PsiCallExpression.class);
        Condition nonFinalFieldRefCondition = expression -> {
            PsiElement element;
            return expression instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)expression).resolve()) instanceof PsiField && !((PsiField)element).hasModifierProperty("final");
        };
        return ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)qualifier)).filter(Conditions.or((Condition)callExpressionCondition, (Condition)nonFinalFieldRefCondition))).toList().isEmpty();
    }

    @Nullable
    private static PsiMethod getNonAmbiguousReceiver(PsiVariable[] parameters, @NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "getNonAmbiguousReceiver"));
        }
        String methodName = psiMethod.getName();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        PsiMethod[] psiMethods = containingClass.findMethodsByName(methodName, false);
        if (psiMethods.length == 1) {
            return psiMethod;
        }
        PsiType receiverType = parameters[0].getType();
        for (PsiMethod method2 : psiMethods) {
            if (!LambdaCanBeMethodReferenceInspection.isPairedNoReceiver(parameters, receiverType, method2)) continue;
            PsiMethod[] deepestSuperMethods = psiMethod.findDeepestSuperMethods();
            if (deepestSuperMethods.length > 0) {
                for (PsiMethod superMethod : deepestSuperMethods) {
                    PsiMethod validSuperMethod = LambdaCanBeMethodReferenceInspection.getNonAmbiguousReceiver(parameters, superMethod);
                    if (validSuperMethod == null) continue;
                    return validSuperMethod;
                }
            }
            return null;
        }
        return psiMethod;
    }

    private static boolean isPairedNoReceiver(PsiVariable[] parameters, PsiType receiverType, PsiMethod method2) {
        PsiParameter[] nonReceiverCandidateParams = method2.getParameterList().getParameters();
        return nonReceiverCandidateParams.length == parameters.length && method2.hasModifierProperty("static") && TypeConversionUtil.areTypesConvertible((PsiType)nonReceiverCandidateParams[0].getType(), (PsiType)receiverType);
    }

    private static boolean isSoleParameter(@NotNull PsiVariable[] parameters, @Nullable PsiExpression expression) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "isSoleParameter"));
        }
        return parameters.length == 1 && expression instanceof PsiReferenceExpression && parameters[0] == ((PsiReferenceExpression)expression).resolve();
    }

    @Nullable
    static String createMethodReferenceText(PsiElement element, PsiType functionalInterfaceType, PsiVariable[] parameters) {
        PsiTypeElement type;
        PsiTypeCastExpression castExpression;
        if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element;
            JavaResolveResult result2 = methodCall.resolveMethodGenerics();
            PsiMethod psiMethod = (PsiMethod)result2.getElement();
            if (psiMethod == null) {
                return null;
            }
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            String qualifierByMethodCall = LambdaCanBeMethodReferenceInspection.getQualifierTextByMethodCall(methodCall, functionalInterfaceType, parameters, psiMethod, result2.getSubstitutor());
            if (qualifierByMethodCall != null) {
                return qualifierByMethodCall + "::" + ((PsiMethodCallExpression)element).getTypeArgumentList().getText() + methodExpression.getReferenceName();
            }
        } else if (element instanceof PsiNewExpression) {
            String qualifierByNew = LambdaCanBeMethodReferenceInspection.getQualifierTextByNewExpression((PsiNewExpression)element);
            if (qualifierByNew != null) {
                return qualifierByNew + ((PsiNewExpression)element).getTypeArgumentList().getText() + "::new";
            }
        } else if (element instanceof PsiInstanceOfExpression) {
            PsiTypeElement type2;
            if (LambdaCanBeMethodReferenceInspection.isSoleParameter(parameters, ((PsiInstanceOfExpression)element).getOperand()) && (type2 = ((PsiInstanceOfExpression)element).getCheckType()) != null) {
                return type2.getText() + ".class::isInstance";
            }
        } else if (element instanceof PsiBinaryExpression) {
            PsiExpression operand;
            PsiBinaryExpression nullCheck = (PsiBinaryExpression)element;
            if (ExpressionUtils.isNullLiteral(nullCheck.getROperand())) {
                operand = nullCheck.getLOperand();
            } else if (ExpressionUtils.isNullLiteral(nullCheck.getLOperand())) {
                operand = nullCheck.getROperand();
            } else {
                return null;
            }
            if (LambdaCanBeMethodReferenceInspection.isSoleParameter(parameters, operand)) {
                IElementType tokenType = nullCheck.getOperationTokenType();
                if (JavaTokenType.EQEQ.equals(tokenType)) {
                    return "java.util.Objects::isNull";
                }
                if (JavaTokenType.NE.equals(tokenType)) {
                    return "java.util.Objects::nonNull";
                }
            }
        } else if (element instanceof PsiTypeCastExpression && LambdaCanBeMethodReferenceInspection.isSoleParameter(parameters, (castExpression = (PsiTypeCastExpression)element).getOperand()) && (type = castExpression.getCastType()) != null) {
            return type.getText() + ".class::cast";
        }
        return null;
    }

    private static String getQualifierTextByNewExpression(PsiNewExpression element) {
        PsiType deepComponentType;
        JavaResolveResult resolve;
        PsiElement resolveElement;
        PsiType newExprType = element.getType();
        if (newExprType == null) {
            return null;
        }
        PsiClass containingClass = null;
        PsiJavaCodeReferenceElement classReference = element.getClassOrAnonymousClassReference();
        if (classReference != null && (resolveElement = (resolve = classReference.advancedResolve(false)).getElement()) instanceof PsiClass) {
            containingClass = (PsiClass)resolveElement;
        }
        String classOrPrimitiveName = null;
        if (containingClass != null) {
            classOrPrimitiveName = LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
        } else if (newExprType instanceof PsiArrayType && (deepComponentType = newExprType.getDeepComponentType()) instanceof PsiPrimitiveType) {
            classOrPrimitiveName = deepComponentType.getCanonicalText();
        }
        if (classOrPrimitiveName == null) {
            return null;
        }
        int dim = newExprType.getArrayDimensions();
        while (dim-- > 0) {
            classOrPrimitiveName = classOrPrimitiveName + "[]";
        }
        return classOrPrimitiveName;
    }

    @Nullable
    private static String getQualifierTextByMethodCall(PsiMethodCallExpression methodCall, PsiType functionalInterfaceType, PsiVariable[] parameters, PsiMethod psiMethod, PsiSubstitutor substitutor) {
        PsiExpression qualifierExpression = methodCall.getMethodExpression().getQualifierExpression();
        PsiClass containingClass = psiMethod.getContainingClass();
        LOG.assertTrue(containingClass != null);
        if (qualifierExpression != null) {
            boolean isReceiverType = false;
            if (qualifierExpression instanceof PsiReferenceExpression && ArrayUtil.find((Object[])parameters, (Object)((PsiReferenceExpression)qualifierExpression).resolve()) > -1) {
                isReceiverType = PsiMethodReferenceUtil.isReceiverType((PsiType)PsiMethodReferenceUtil.getFirstParameterType((PsiType)functionalInterfaceType, (PsiElement)qualifierExpression), (PsiClass)containingClass, (PsiSubstitutor)substitutor);
            }
            return isReceiverType ? LambdaCanBeMethodReferenceInspection.composeReceiverQualifierText(parameters, psiMethod, containingClass, qualifierExpression) : qualifierExpression.getText();
        }
        if (psiMethod.hasModifierProperty("static")) {
            return LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
        }
        PsiClass parentContainingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiClass.class);
        if (parentContainingClass instanceof PsiAnonymousClass) {
            parentContainingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parentContainingClass, PsiClass.class, (boolean)true);
        }
        PsiClass treeContainingClass = parentContainingClass;
        while (treeContainingClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)treeContainingClass, (PsiClass)containingClass, (boolean)true)) {
            treeContainingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)treeContainingClass, PsiClass.class, (boolean)true);
        }
        if (treeContainingClass != null && containingClass != parentContainingClass && treeContainingClass != parentContainingClass) {
            String treeContainingClassName = treeContainingClass.getName();
            if (treeContainingClassName == null) {
                return null;
            }
            return treeContainingClassName + ".this";
        }
        return "this";
    }

    @Nullable
    private static String composeReceiverQualifierText(PsiVariable[] parameters, PsiMethod psiMethod, PsiClass containingClass, @NotNull PsiExpression qualifierExpression) {
        if (qualifierExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierExpression", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "composeReceiverQualifierText"));
        }
        if (psiMethod.hasModifierProperty("static")) {
            return null;
        }
        PsiMethod nonAmbiguousMethod = LambdaCanBeMethodReferenceInspection.getNonAmbiguousReceiver(parameters, psiMethod);
        if (nonAmbiguousMethod == null) {
            return null;
        }
        PsiClass nonAmbiguousContainingClass = nonAmbiguousMethod.getContainingClass();
        if (!containingClass.equals(nonAmbiguousContainingClass)) {
            return LambdaCanBeMethodReferenceInspection.getClassReferenceName(nonAmbiguousContainingClass);
        }
        if (containingClass.isPhysical() && qualifierExpression instanceof PsiReferenceExpression && !PsiTypesUtil.isGetClass((PsiMethod)psiMethod) && ArrayUtil.find((Object[])parameters, (Object)((PsiReferenceExpression)qualifierExpression).resolve()) > -1) {
            return LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
        }
        PsiType qualifierExpressionType = qualifierExpression.getType();
        if (qualifierExpressionType != null && !FunctionalInterfaceParameterizationUtil.isWildcardParameterized(qualifierExpressionType)) {
            try {
                String canonicalText = qualifierExpressionType.getCanonicalText();
                JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createExpressionFromText(canonicalText + "::foo", (PsiElement)qualifierExpression);
                return canonicalText;
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
        return LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
    }

    private static String getClassReferenceName(PsiClass containingClass) {
        String qualifiedName = containingClass.getQualifiedName();
        if (qualifiedName != null) {
            return qualifiedName;
        }
        return containingClass.getName();
    }

    @NotNull
    static PsiExpression tryConvertToMethodReference(@NotNull PsiLambdaExpression lambda2, PsiElement body) {
        if (lambda2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambda", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "tryConvertToMethodReference"));
        }
        Project project2 = lambda2.getProject();
        PsiType functionalInterfaceType = lambda2.getFunctionalInterfaceType();
        if (functionalInterfaceType == null || !functionalInterfaceType.isValid()) {
            PsiLambdaExpression psiLambdaExpression = lambda2;
            if (psiLambdaExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "tryConvertToMethodReference"));
            }
            return psiLambdaExpression;
        }
        PsiType denotableFunctionalInterfaceType = RefactoringChangeUtil.getTypeByExpression((PsiExpression)lambda2);
        if (denotableFunctionalInterfaceType == null) {
            PsiLambdaExpression psiLambdaExpression = lambda2;
            if (psiLambdaExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "tryConvertToMethodReference"));
            }
            return psiLambdaExpression;
        }
        List comments = ContainerUtil.map((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)lambda2, PsiComment.class), comment -> (PsiComment)comment.copy());
        String methodRefText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText(body, functionalInterfaceType, (PsiVariable[])lambda2.getParameterList().getParameters());
        if (methodRefText != null) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            PsiExpression psiExpression = factory.createExpressionFromText(methodRefText, (PsiElement)lambda2);
            SmartTypePointer typePointer = SmartTypePointerManager.getInstance((Project)project2).createSmartTypePointer(denotableFunctionalInterfaceType);
            PsiExpression replace = (PsiExpression)lambda2.replace((PsiElement)psiExpression);
            PsiType functionalTypeAfterReplacement = GenericsUtil.getVariableTypeByExpressionType((PsiType)((PsiMethodReferenceExpression)replace).getFunctionalInterfaceType());
            functionalInterfaceType = typePointer.getType();
            if (!(functionalInterfaceType == null || functionalTypeAfterReplacement != null && functionalTypeAfterReplacement.equals(functionalInterfaceType))) {
                PsiTypeCastExpression cast = (PsiTypeCastExpression)factory.createExpressionFromText("(A)a", (PsiElement)replace);
                PsiTypeElement castType = cast.getCastType();
                LOG.assertTrue(castType != null);
                castType.replace((PsiElement)factory.createTypeElement(functionalInterfaceType));
                PsiExpression castOperand = cast.getOperand();
                LOG.assertTrue(castOperand != null);
                castOperand.replace((PsiElement)replace);
                replace = (PsiExpression)replace.replace((PsiElement)cast);
            }
            AnonymousCanBeLambdaInspection.restoreComments(comments, (PsiElement)replace);
            JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)replace);
            PsiExpression psiExpression2 = replace;
            if (psiExpression2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "tryConvertToMethodReference"));
            }
            return psiExpression2;
        }
        PsiLambdaExpression psiLambdaExpression = lambda2;
        if (psiLambdaExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "tryConvertToMethodReference"));
        }
        return psiLambdaExpression;
    }

    private static class ReplaceWithMethodRefFix
    implements LocalQuickFix {
        private ReplaceWithMethodRefFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace lambda with method reference" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "getFamilyName"));
            }
            return "Replace lambda with method reference";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class);
            if (lambdaExpression == null) {
                return;
            }
            LambdaCanBeMethodReferenceInspection.tryConvertToMethodReference(lambdaExpression, element);
        }
    }
}

