/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalAnnotatorInspectionVisitor
extends PsiElementVisitor {
    private static final Logger LOG = Logger.getInstance(ExternalAnnotatorInspectionVisitor.class);
    private final ProblemsHolder myHolder;
    private final ExternalAnnotator myAnnotator;
    private final boolean myIsOnTheFly;

    public ExternalAnnotatorInspectionVisitor(ProblemsHolder holder, ExternalAnnotator annotator2, boolean isOnTheFly) {
        this.myHolder = holder;
        this.myAnnotator = annotator2;
        this.myIsOnTheFly = isOnTheFly;
    }

    public void visitFile(PsiFile file2) {
        ProblemDescriptor[] descriptors = ExternalAnnotatorInspectionVisitor.checkFileWithExternalAnnotator(file2, this.myHolder.getManager(), this.myIsOnTheFly, this.myAnnotator);
        this.addDescriptors(descriptors);
    }

    @NotNull
    public static <Init, Result> ProblemDescriptor[] checkFileWithExternalAnnotator(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull ExternalAnnotator<Init, Result> annotator2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor", "checkFileWithExternalAnnotator"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor", "checkFileWithExternalAnnotator"));
        }
        if (annotator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotator", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor", "checkFileWithExternalAnnotator"));
        }
        if (isOnTheFly) {
            if (ProblemDescriptor.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor", "checkFileWithExternalAnnotator"));
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Object info = annotator2.collectInformation(file2);
        if (info != null) {
            Object annotationResult = annotator2.doAnnotate(info);
            if (annotationResult == null) {
                if (ProblemDescriptor.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor", "checkFileWithExternalAnnotator"));
                }
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            AnnotationHolderImpl annotationHolder = new AnnotationHolderImpl(new AnnotationSession(file2));
            annotator2.apply(file2, annotationResult, (AnnotationHolder)annotationHolder);
            ProblemDescriptor[] problemDescriptorArray = ExternalAnnotatorInspectionVisitor.convertToProblemDescriptors((List<Annotation>)((Object)annotationHolder), manager, file2);
            if (problemDescriptorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor", "checkFileWithExternalAnnotator"));
            }
            return problemDescriptorArray;
        }
        if (ProblemDescriptor.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor", "checkFileWithExternalAnnotator"));
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    private static ProblemDescriptor[] convertToProblemDescriptors(@NotNull List<Annotation> annotations, @NotNull InspectionManager manager, @NotNull PsiFile file2) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor", "convertToProblemDescriptors"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor", "convertToProblemDescriptors"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor", "convertToProblemDescriptors"));
        }
        if (annotations.isEmpty()) {
            if (ProblemDescriptor.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor", "convertToProblemDescriptors"));
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList problems = ContainerUtil.newArrayListWithCapacity((int)annotations.size());
        IdentityHashMap quickFixMappingCache = ContainerUtil.newIdentityHashMap();
        for (Annotation annotation : annotations) {
            if (annotation.getSeverity() == HighlightSeverity.INFORMATION || annotation.getStartOffset() == annotation.getEndOffset()) continue;
            PsiElement startElement = file2.findElementAt(annotation.getStartOffset());
            PsiElement endElement = file2.findElementAt(annotation.getEndOffset() - 1);
            if (startElement == null || endElement == null) continue;
            LocalQuickFix[] quickFixes = ExternalAnnotatorInspectionVisitor.toLocalQuickFixes(annotation.getQuickFixes(), quickFixMappingCache);
            ProblemDescriptor descriptor = manager.createProblemDescriptor(startElement, endElement, annotation.getMessage(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, quickFixes);
            problems.add(descriptor);
        }
        ProblemDescriptor[] problemDescriptorArray = problems.toArray(new ProblemDescriptor[problems.size()]);
        if (problemDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor", "convertToProblemDescriptors"));
        }
        return problemDescriptorArray;
    }

    @NotNull
    private static LocalQuickFix[] toLocalQuickFixes(@Nullable List<Annotation.QuickFixInfo> fixInfos, @NotNull IdentityHashMap<IntentionAction, LocalQuickFix> quickFixMappingCache) {
        if (quickFixMappingCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixMappingCache", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor", "toLocalQuickFixes"));
        }
        if (fixInfos == null || fixInfos.isEmpty()) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor", "toLocalQuickFixes"));
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] result2 = new LocalQuickFix[fixInfos.size()];
        int i2 = 0;
        for (Annotation.QuickFixInfo fixInfo : fixInfos) {
            LocalQuickFix fix;
            IntentionAction intentionAction = fixInfo.quickFix;
            if (intentionAction instanceof LocalQuickFix) {
                fix = (LocalQuickFix)intentionAction;
            } else {
                LocalQuickFix lqf = quickFixMappingCache.get(intentionAction);
                if (lqf == null) {
                    lqf = new LocalQuickFixBackedByIntentionAction(intentionAction);
                    quickFixMappingCache.put(intentionAction, lqf);
                }
                fix = lqf;
            }
            result2[i2++] = fix;
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor", "toLocalQuickFixes"));
        }
        return result2;
    }

    private void addDescriptors(@NotNull ProblemDescriptor[] descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor", "addDescriptors"));
        }
        for (ProblemDescriptor descriptor : descriptors) {
            LOG.assertTrue(descriptor != null, (Object)((Object)((Object)this)).getClass().getName());
            this.myHolder.registerProblem(descriptor);
        }
    }

    public static class LocalQuickFixBackedByIntentionAction
    implements LocalQuickFix,
    Iconable {
        private final IntentionAction myAction;

        public LocalQuickFixBackedByIntentionAction(@NotNull IntentionAction action) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor$LocalQuickFixBackedByIntentionAction", "<init>"));
            }
            this.myAction = action;
        }

        @NotNull
        public String getName() {
            String string = this.myAction.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor$LocalQuickFixBackedByIntentionAction", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myAction.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor$LocalQuickFixBackedByIntentionAction", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor$LocalQuickFixBackedByIntentionAction", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor$LocalQuickFixBackedByIntentionAction", "applyFix"));
            }
            this.myAction.invoke(project2, null, LocalQuickFixBackedByIntentionAction.getPsiFile(descriptor));
        }

        @Nullable
        private static PsiFile getPsiFile(@NotNull ProblemDescriptor descriptor) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor$LocalQuickFixBackedByIntentionAction", "getPsiFile"));
            }
            PsiElement startElement = descriptor.getStartElement();
            if (startElement != null) {
                return startElement.getContainingFile();
            }
            PsiElement endElement = descriptor.getEndElement();
            if (endElement != null) {
                return endElement.getContainingFile();
            }
            return null;
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            if (this.myAction instanceof Iconable) {
                return ((Iconable)this.myAction).getIcon(flags);
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalQuickFixBackedByIntentionAction action = (LocalQuickFixBackedByIntentionAction)o;
            return this.myAction.equals(action.myAction);
        }

        public int hashCode() {
            return this.myAction.hashCode();
        }
    }
}

