/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.codeInsight.navigation.ListBackgroundUpdaterTask;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.HashMap;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoImplementationHandler
extends GotoTargetHandler {
    @Override
    protected String getFeatureUsedKey() {
        return "navigation.goto.implementation";
    }

    @Override
    @Nullable
    public GotoTargetHandler.GotoData getSourceAndTargetElements(@NotNull Editor editor, PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/GotoImplementationHandler", "getSourceAndTargetElements"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement source = TargetElementUtil.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags(), offset);
        if (source == null) {
            return null;
        }
        final PsiReference reference = TargetElementUtil.findReference(editor, offset);
        final TargetElementUtil instance = TargetElementUtil.getInstance();
        PsiElement[] targets = new ImplementationSearcher.FirstImplementationsSearcher(){

            @Override
            protected boolean accept(PsiElement element) {
                return instance.acceptImplementationForReference(reference, element);
            }

            @Override
            protected boolean canShowPopupWithOneItem(PsiElement element) {
                return false;
            }
        }.searchImplementations(editor, source, offset);
        if (targets == null) {
            return null;
        }
        GotoTargetHandler.GotoData gotoData = new GotoTargetHandler.GotoData(source, targets, Collections.emptyList());
        gotoData.listUpdaterTask = new ImplementationsUpdaterTask(gotoData, editor, offset, reference);
        return gotoData;
    }

    private static PsiElement getContainer(PsiElement refElement) {
        for (ContainerProvider provider : (ContainerProvider[])ContainerProvider.EP_NAME.getExtensions()) {
            PsiElement container = provider.getContainer(refElement);
            if (container == null) continue;
            return container;
        }
        return refElement.getParent();
    }

    @Override
    @NotNull
    protected String getChooserTitle(@NotNull PsiElement sourceElement, String name, int length, boolean finished) {
        String fullName;
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/codeInsight/navigation/GotoImplementationHandler", "getChooserTitle"));
        }
        ItemPresentation presentation = ((NavigationItem)sourceElement).getPresentation();
        if (presentation == null) {
            fullName = name;
        } else {
            PsiElement container = GotoImplementationHandler.getContainer(sourceElement);
            ItemPresentation containerPresentation = container == null || container instanceof PsiFile ? null : ((NavigationItem)container).getPresentation();
            String containerText = containerPresentation == null ? null : containerPresentation.getPresentableText();
            fullName = (containerText == null ? "" : containerText + ".") + presentation.getPresentableText();
        }
        String string = CodeInsightBundle.message((String)"goto.implementation.chooserTitle", (Object[])new Object[]{fullName, length, finished ? "" : " so far"});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/GotoImplementationHandler", "getChooserTitle"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name, int length) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/codeInsight/navigation/GotoImplementationHandler", "getFindUsagesTitle"));
        }
        String string = CodeInsightBundle.message((String)"goto.implementation.findUsages.title", (Object[])new Object[]{name, length});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/GotoImplementationHandler", "getFindUsagesTitle"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getNotFoundMessage(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/navigation/GotoImplementationHandler", "getNotFoundMessage"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/GotoImplementationHandler", "getNotFoundMessage"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/navigation/GotoImplementationHandler", "getNotFoundMessage"));
        }
        String string = CodeInsightBundle.message((String)"goto.implementation.notFound", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/GotoImplementationHandler", "getNotFoundMessage"));
        }
        return string;
    }

    private class ImplementationsUpdaterTask
    extends ListBackgroundUpdaterTask {
        private final Editor myEditor;
        private final int myOffset;
        private final GotoTargetHandler.GotoData myGotoData;
        private final Map<Object, PsiElementListCellRenderer> renderers;
        private final PsiReference myReference;

        ImplementationsUpdaterTask(@NotNull GotoTargetHandler.GotoData gotoData, Editor editor, int offset, PsiReference reference) {
            if (gotoData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gotoData", "com/intellij/codeInsight/navigation/GotoImplementationHandler$ImplementationsUpdaterTask", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/GotoImplementationHandler$ImplementationsUpdaterTask", "<init>"));
            }
            super(gotoData.source.getProject(), ImplementationSearcher.SEARCHING_FOR_IMPLEMENTATIONS);
            this.renderers = new HashMap();
            this.myEditor = editor;
            this.myOffset = offset;
            this.myGotoData = gotoData;
            this.myReference = reference;
        }

        @Override
        public void run(final @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/navigation/GotoImplementationHandler$ImplementationsUpdaterTask", "run"));
            }
            super.run(indicator);
            for (PsiElement element : this.myGotoData.targets) {
                if (this.updateComponent(element, GotoTargetHandler.createComparator(this.renderers, this.myGotoData))) continue;
                return;
            }
            new ImplementationSearcher.BackgroundableImplementationSearcher(){

                @Override
                protected void processElement(PsiElement element) {
                    indicator.checkCanceled();
                    if (!TargetElementUtil.getInstance().acceptImplementationForReference(ImplementationsUpdaterTask.this.myReference, element)) {
                        return;
                    }
                    if (ImplementationsUpdaterTask.this.myGotoData.addTarget(element) && !ImplementationsUpdaterTask.this.updateComponent(element, GotoTargetHandler.createComparator(ImplementationsUpdaterTask.this.renderers, ImplementationsUpdaterTask.this.myGotoData))) {
                        indicator.cancel();
                    }
                }
            }.searchImplementations(this.myEditor, this.myGotoData.source, this.myOffset);
        }

        @Override
        public String getCaption(int size) {
            return GotoImplementationHandler.this.getChooserTitle(this.myGotoData.source, ((PsiNamedElement)this.myGotoData.source).getName(), size, this.isFinished());
        }
    }
}

