/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class MergeFilterChainAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)MergeFilterChainAction.class.getName());

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/MergeFilterChainAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/MergeFilterChainAction", "isAvailable"));
        }
        if (!(element instanceof PsiIdentifier)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiElement gParent = parent.getParent();
        if (!(gParent instanceof PsiMethodCallExpression)) {
            return false;
        }
        if (!MergeFilterChainAction.isFilterCall((PsiMethodCallExpression)gParent)) {
            return false;
        }
        return MergeFilterChainAction.getFilterToMerge((PsiMethodCallExpression)gParent) != null;
    }

    private static PsiMethodCallExpression getFilterToMerge(PsiMethodCallExpression methodCallExpression) {
        PsiElement gParent;
        PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
        if (qualifierExpression instanceof PsiMethodCallExpression && MergeFilterChainAction.isFilterCall((PsiMethodCallExpression)qualifierExpression)) {
            return (PsiMethodCallExpression)qualifierExpression;
        }
        PsiElement parent = methodCallExpression.getParent();
        if (parent instanceof PsiReferenceExpression && (gParent = parent.getParent()) instanceof PsiMethodCallExpression && MergeFilterChainAction.isFilterCall((PsiMethodCallExpression)gParent)) {
            return (PsiMethodCallExpression)gParent;
        }
        return null;
    }

    public static boolean isFilterCall(PsiMethodCallExpression methodCallExpression) {
        if (!"filter".equals(methodCallExpression.getMethodExpression().getReferenceName())) {
            return false;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] expressions = argumentList.getExpressions();
        if (expressions.length != 1) {
            return false;
        }
        if (!(expressions[0] instanceof PsiLambdaExpression)) {
            return false;
        }
        PsiElement lambdaBody = ((PsiLambdaExpression)expressions[0]).getBody();
        if (!(lambdaBody instanceof PsiExpression)) {
            return false;
        }
        PsiMethod method2 = methodCallExpression.resolveMethod();
        if (method2 == null) {
            return false;
        }
        PsiClass containingClass = method2.getContainingClass();
        PsiParameter[] parameters = method2.getParameterList().getParameters();
        return parameters.length == 1 && InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)"java.util.stream.Stream") && InheritanceUtil.isInheritor((PsiType)parameters[0].getType(), (String)"java.util.function.Predicate");
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.merge.filter.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/MergeFilterChainAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.merge.filter.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/MergeFilterChainAction", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/MergeFilterChainAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/MergeFilterChainAction", "invoke"));
        }
        try {
            PsiParameter[] sourceLambdaParams;
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            PsiMethodCallExpression filterCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
            LOG.assertTrue(filterCall != null);
            PsiMethodCallExpression filterToMerge = MergeFilterChainAction.getFilterToMerge(filterCall);
            LOG.assertTrue(filterToMerge != null);
            PsiMethodCallExpression callToStay = filterCall.getTextLength() < filterToMerge.getTextLength() ? filterCall : filterToMerge;
            PsiMethodCallExpression callToEliminate = callToStay == filterCall ? filterToMerge : filterCall;
            PsiLambdaExpression targetLambda = (PsiLambdaExpression)callToStay.getArgumentList().getExpressions()[0];
            PsiParameter[] parameters = targetLambda.getParameterList().getParameters();
            String name = parameters.length > 0 ? parameters[0].getName() : null;
            PsiLambdaExpression sourceLambda = (PsiLambdaExpression)callToEliminate.getArgumentList().getExpressions()[0];
            if (name != null && (sourceLambdaParams = sourceLambda.getParameterList().getParameters()).length > 0 && !name.equals(sourceLambdaParams[0].getName())) {
                for (PsiReference reference : ReferencesSearch.search((PsiElement)sourceLambdaParams[0]).findAll()) {
                    PsiElement referenceElement = reference.getElement();
                    if (!(referenceElement instanceof PsiReferenceExpression)) continue;
                    ((PsiReferenceExpression)referenceElement).handleElementRename(name);
                }
            }
            PsiElement targetBody = targetLambda.getBody();
            LOG.assertTrue(targetBody instanceof PsiExpression);
            PsiElement sourceLambdaBody = sourceLambda.getBody();
            LOG.assertTrue(sourceLambdaBody instanceof PsiExpression);
            PsiExpression compoundExpression = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(ParenthesesUtils.getText((PsiExpression)targetBody, 14) + " && " + ParenthesesUtils.getText((PsiExpression)sourceLambdaBody, 14), (PsiElement)sourceLambda);
            targetBody = targetBody.replace((PsiElement)compoundExpression);
            CodeStyleManager.getInstance((Project)project2).reformat(targetBody);
            PsiExpression qualifierExpression = callToEliminate.getMethodExpression().getQualifierExpression();
            LOG.assertTrue(qualifierExpression != null, (Object)callToEliminate);
            Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)callToEliminate, PsiComment.class);
            for (PsiComment comment : comments) {
                TextRange commentRange = comment.getTextRange();
                if (sourceLambdaBody.getTextRange().contains(commentRange) || qualifierExpression.getTextRange().contains(commentRange)) continue;
                targetBody.add((PsiElement)comment);
            }
            callToEliminate.replace((PsiElement)qualifierExpression);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

