/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddOnDemandStaticImportAction
extends BaseElementAtCaretIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.AddOnDemandStaticImportAction");

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.add.on.demand.static.import.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/AddOnDemandStaticImportAction", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    public static PsiClass getClassToPerformStaticImport(@NotNull PsiElement element) {
        PsiFile file2;
        PsiElement qualifier;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/AddOnDemandStaticImportAction", "getClassToPerformStaticImport"));
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)element)) {
            return null;
        }
        if (!(element instanceof PsiIdentifier) || !(element.getParent() instanceof PsiJavaCodeReferenceElement)) {
            return null;
        }
        PsiJavaCodeReferenceElement refExpr = (PsiJavaCodeReferenceElement)element.getParent();
        if (refExpr instanceof PsiMethodReferenceExpression) {
            return null;
        }
        PsiElement gParent = refExpr.getParent();
        if (gParent instanceof PsiMethodReferenceExpression) {
            return null;
        }
        if (!(gParent instanceof PsiJavaCodeReferenceElement) || AddOnDemandStaticImportAction.isParameterizedReference((PsiJavaCodeReferenceElement)gParent)) {
            return null;
        }
        PsiElement resolved = refExpr.resolve();
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiClass psiClass = (PsiClass)resolved;
        if (PsiUtil.isFromDefaultPackage((PsiClass)psiClass) || psiClass.hasModifierProperty("private") || psiClass.getQualifiedName() == null) {
            return null;
        }
        PsiElement ggParent = gParent.getParent();
        if (ggParent instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)ggParent.copy();
            qualifier = call.getMethodExpression().getQualifier();
            if (qualifier == null) {
                return null;
            }
            qualifier.delete();
            PsiMethod method2 = call.resolveMethod();
            if (method2 != null && method2.getContainingClass() != psiClass) {
                return null;
            }
        } else {
            PsiJavaCodeReferenceElement copy = (PsiJavaCodeReferenceElement)gParent.copy();
            qualifier = copy.getQualifier();
            if (qualifier == null) {
                return null;
            }
            qualifier.delete();
            PsiElement target = copy.resolve();
            if (target != null && PsiTreeUtil.getParentOfType((PsiElement)target, PsiClass.class) != psiClass) {
                return null;
            }
        }
        if (!((file2 = refExpr.getContainingFile()) instanceof PsiJavaFile)) {
            return null;
        }
        PsiImportList importList = ((PsiJavaFile)file2).getImportList();
        if (importList == null) {
            return null;
        }
        return psiClass;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/AddOnDemandStaticImportAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/AddOnDemandStaticImportAction", "isAvailable"));
        }
        PsiClass classToImport = AddOnDemandStaticImportAction.getClassToPerformStaticImport(element);
        if (classToImport != null) {
            String text = CodeInsightBundle.message((String)"intention.add.on.demand.static.import.text", (Object[])new Object[]{classToImport.getQualifiedName()});
            this.setText(text);
        }
        return classToImport != null;
    }

    public static void invoke(final Project project2, PsiFile file2, final Editor editor, PsiElement element) {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiJavaCodeReferenceElement refExpr = (PsiJavaCodeReferenceElement)element.getParent();
        final PsiClass aClass = (PsiClass)refExpr.resolve();
        if (aClass == null) {
            return;
        }
        PsiClass containingClass = PsiUtil.getTopLevelClass((PsiElement)refExpr);
        if (aClass != containingClass) {
            PsiImportList importList = ((PsiJavaFile)file2).getImportList();
            if (importList == null) {
                return;
            }
            boolean alreadyImported = false;
            for (PsiImportStaticStatement statement2 : importList.getImportStaticStatements()) {
                PsiClass staticResolve;
                if (!statement2.isOnDemand() || aClass != (staticResolve = statement2.resolveTargetClass())) continue;
                alreadyImported = true;
                break;
            }
            if (!alreadyImported) {
                PsiImportStaticStatement importStaticStatement = JavaPsiFacade.getInstance((Project)file2.getProject()).getElementFactory().createImportStaticStatement(aClass, "*");
                importList.add((PsiElement)importStaticStatement);
            }
        }
        List roots = file2.getViewProvider().getAllFiles();
        for (final PsiFile root : roots) {
            PsiElement copy = root.copy();
            final PsiManager manager = root.getManager();
            final TIntArrayList expressionToDequalifyOffsets = new TIntArrayList();
            copy.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){
                int delta;

                public void visitReferenceElement(PsiJavaCodeReferenceElement expression) {
                    if (AddOnDemandStaticImportAction.isParameterizedReference(expression)) {
                        return;
                    }
                    PsiElement qualifierExpression = expression.getQualifier();
                    if (qualifierExpression instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)qualifierExpression).isReferenceTo((PsiElement)aClass)) {
                        try {
                            PsiElement resolved = expression.resolve();
                            int end = expression.getTextRange().getEndOffset();
                            qualifierExpression.delete();
                            this.delta += end - expression.getTextRange().getEndOffset();
                            PsiElement after2 = expression.resolve();
                            if (manager.areElementsEquivalent(after2, resolved)) {
                                expressionToDequalifyOffsets.add(expression.getTextRange().getStartOffset() + this.delta);
                            }
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                    super.visitElement((PsiElement)expression);
                }
            });
            expressionToDequalifyOffsets.forEachDescending(new TIntProcedure(){

                public boolean execute(int offset) {
                    PsiJavaCodeReferenceElement expression = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)root, (int)offset, PsiJavaCodeReferenceElement.class, (boolean)false);
                    if (expression == null) {
                        return false;
                    }
                    PsiElement qualifierExpression = expression.getQualifier();
                    if (qualifierExpression instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)qualifierExpression).isReferenceTo((PsiElement)aClass)) {
                        qualifierExpression.delete();
                        if (editor != null) {
                            HighlightManager.getInstance((Project)project2).addRangeHighlight(editor, expression.getTextRange().getStartOffset(), expression.getTextRange().getEndOffset(), EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES), false, null);
                        }
                    }
                    return true;
                }
            });
        }
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/AddOnDemandStaticImportAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/AddOnDemandStaticImportAction", "invoke"));
        }
        AddOnDemandStaticImportAction.invoke(project2, element.getContainingFile(), editor, element);
    }

    private static boolean isParameterizedReference(PsiJavaCodeReferenceElement expression) {
        PsiReferenceParameterList parameterList = expression.getParameterList();
        return parameterList != null && parameterList.getFirstChild() != null;
    }
}

