/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class InjectedHtmlErrorFilter
extends HighlightErrorFilter {
    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/highlighting/InjectedHtmlErrorFilter", "shouldHighlightErrorElement"));
        }
        PsiFile containingFile = element.getContainingFile();
        return containingFile.getLanguage() != HTMLLanguage.INSTANCE || containingFile.getContext() == null || !InjectedHtmlErrorFilter.isErrorToBeFiltered(element.getErrorDescription());
    }

    private static boolean isErrorToBeFiltered(@NotNull String errorDescription) {
        if (errorDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorDescription", "com/intellij/codeInsight/highlighting/InjectedHtmlErrorFilter", "isErrorToBeFiltered"));
        }
        return errorDescription.contains("is not closed") || errorDescription.contains("is not completed") || errorDescription.contains("expected") || errorDescription.contains("not terminated") || errorDescription.contains("Unclosed string") || errorDescription.contains("Unexpected tokens");
    }
}

