/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HighlightUsagesHandlerFactoryBase
implements HighlightUsagesHandlerFactory {
    @Override
    @Nullable
    public final HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightUsagesHandlerFactoryBase", "createHighlightUsagesHandler"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/highlighting/HighlightUsagesHandlerFactoryBase", "createHighlightUsagesHandler"));
        }
        int offset = TargetElementUtil.adjustOffset(file2, editor.getDocument(), editor.getCaretModel().getOffset());
        PsiElement target = file2.findElementAt(offset);
        if (target == null) {
            return null;
        }
        return this.createHighlightUsagesHandler(editor, file2, target);
    }

    @Nullable
    public abstract HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor var1, @NotNull PsiFile var2, @NotNull PsiElement var3);
}

